/* Sonali Calendar is a copyright of its author but may be distributed under GPL.
See license for more details.
*/
import java.applet.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.util.*;
import java.net.*;
import java.lang.Math;

public class calendar extends Applet implements ItemListener,MouseListener{
        URL url,mail;
        Frame frame;
        TextField year,fade,title,path,picsize;
        Choice fntcol;
        Button close,calen,home,email;
        Label msg;
        String message,error;
        String stitle,col,file,dtitle;
        Color fcol;
        Image img,pic;
        int wid,ht,yr,alpha,wide,high,imagesize;
        int pix[];
        boolean done=false,dopaint=false;
// variables for calendar

        Font font1, font2;
        FontMetrics fm1,fm2;
        GregorianCalendar ucal;
        int mm[];
        int jan,feb,mar,apr,may,jun,jul,aug,sep,oct,nov,dec;
        char day[]={'S','M','T','W','T','F','S'};
        int end[]={31,28,31,30,31,30,31,31,30,31,30,31};
        String month[]={"January","February","March","April","May","June","July","August","September","October","November","December"};
String fcolor[]={"blue","black","cyan","darkGray","gray","green","lightGray","magenta","orange" , "pink" , "red","white","yellow"};
        int w,h,w0,h0;
        int wm,hm,dw;
        int wstart;

        public void paint(Graphics g){
            if(dopaint){
                int daycount=1,monthcount=0;
                int wc=0,hc=0;
                Image im=createImage(wid,ht);
                Graphics pad=im.getGraphics();
//draw the calendar and start with background picture
                int x0=(wid-wide)/2;
                int y0=(ht-high)/2;
                pad.drawImage(pic,x0,y0,wide,high,this);
// draw the title
                pad.setColor(Color.blue);
                pad.setFont(new Font("Arial",Font.BOLD,36));
                pad.drawString(stitle,20,40);
                for (int k=0;k<12;k++){
                   wc=20;
                   hc=60; //to offset the title on top
                   getorientation(k);
                   w=wm+wc;
                   h=hm+hc;
                   pad.setFont(font1);
                   pad.setColor(fcol);
                   pad.drawString("----------------------------------",w,h);
                   h=h+15;
                   pad.drawString("           "+month[k],w,h);
                   h=h+15;
                   pad.drawString("----------------------------------",w,h); //finished writing the month
                   w+=10;
                   h+=20;
                   wstart=w;
                   for(int j=0;j<7;j++){
                    if(j==0)
                        pad.setColor(Color.red);
                    else
                        pad.setColor(fcol);
                    pad.drawString(""+day[j],w,h);
                    w+=30;
                   }
                   pad.setFont(font2);
                   w=0;
                   h+=25;
                   dw=mm[k];
                   for(int l=1;l<end[k]+1;l++){
                        if(dw==1)
                                w=30+wm;
                        if(dw==2)
                                w=62+wm;
                        if(dw==3)
                                w=90+wm;
                        if(dw==4)
                                w=120+wm;
                        if(dw==5)
                                w=150+wm;
                        if(dw==6)
                                w=180+wm;
                        if(dw==7)
                                w=210+wm;
                        if(dw==1)
                                pad.setColor(Color.red);
                        else
                                pad.setColor(fcol);
                        pad.drawString(""+l,w,h);
                        dw++;
                        if(dw==8){
                         dw=1;
                         h+=22;
                        }
                   }

                }
                h+=45;
                pad.setFont(new Font("Arial",Font.PLAIN,10));
                pad.setColor(Color.blue);
                pad.drawString("Designed by Pankaj Mathur (http://www.pratyush.net)",30,h);
                g.drawImage(im,0,0,this);
            }
        }
        public void getorientation(int n){
                if(n==0){
                wm=0;
                hm=0;
                }
                if(n==1){
                wm=220;
                hm=0;
                }
                if(n==2){
                wm=440;
                hm=0;
                } //End of first row
                if(n==3){
                wm=0;
                hm=210;
                }
                if(n==4){
                wm=220;
                hm=210;
                }
                if(n==5){
                wm=440;
                hm=210;
                }  //End of second row
                if(n==6){
                wm=0;
                hm=420;
                }
                if(n==7){
                wm=220;
                hm=420;
                }
                if(n==8){
                wm=440;
                hm=420;
                }   //End of third row
                if(n==9){
                wm=0;
                hm=630;
                }
                if(n==10){
                wm=220;
                hm=630;
                }
                if(n==11){
                wm=440;
                hm=630;
                }   //End of fourth row

        }
        public void startcalendar(){
                getvalues();
                ucal.set(Calendar.YEAR,yr);
                ucal.set(Calendar.MONTH,Calendar.JANUARY);
                ucal.set(Calendar.DAY_OF_MONTH,01);
                jan=ucal.get(Calendar.DAY_OF_WEEK);
                mm[0]=jan;
                ucal.add(Calendar.MONTH,1);
                feb=ucal.get(Calendar.DAY_OF_WEEK);
                mm[1]=feb;
                if(ucal.isLeapYear(yr))
                        end[1]=29;
                ucal.add(Calendar.MONTH,1);
                mar=ucal.get(Calendar.DAY_OF_WEEK);
                mm[2]=mar;
                ucal.add(Calendar.MONTH,1);
                apr=ucal.get(Calendar.DAY_OF_WEEK);
                mm[3]=apr;
                ucal.add(Calendar.MONTH,1);
                may=ucal.get(Calendar.DAY_OF_WEEK);
                mm[4]=may;
                ucal.add(Calendar.MONTH,1);
                jun=ucal.get(Calendar.DAY_OF_WEEK);
                mm[5]=jun;
                ucal.add(Calendar.MONTH,1);
                jul=ucal.get(Calendar.DAY_OF_WEEK);
                mm[6]=jul;
                ucal.add(Calendar.MONTH,1);
                aug=ucal.get(Calendar.DAY_OF_WEEK);
                mm[7]=aug;
                ucal.add(Calendar.MONTH,1);
                sep=ucal.get(Calendar.DAY_OF_WEEK);
                mm[8]=sep;
                ucal.add(Calendar.MONTH,1);
                oct=ucal.get(Calendar.DAY_OF_WEEK);
                mm[9]=oct;
                ucal.add(Calendar.MONTH,1);
                nov=ucal.get(Calendar.DAY_OF_WEEK);
                mm[10]=nov;
                ucal.add(Calendar.MONTH,1);
                dec=ucal.get(Calendar.DAY_OF_WEEK);
                mm[11]=dec;
                ucal.add(Calendar.MONTH,1);
                repaint();
        }
        public calendar(){
                frame=new Frame("Sonali Calendar");
                frame.setSize(250,250);
                frame.addMouseListener(this);
                frame.setLayout(new GridLayout(8,2));
                frame.setFont(new Font("Arial",Font.PLAIN,10));
                close=new Button ("Close");
                close.addMouseListener(this);
                calen=new Button("Make calendar");
                calen.addMouseListener(this);
                home=new Button("Homepage");
                home.addMouseListener(this);
                email=new Button("email");
                email.addMouseListener(this);
                fade=new TextField("60");
                title= new TextField();
                fntcol= new Choice();
                for (int kk=0;kk<fcolor.length;kk++)
                        fntcol.add(fcolor[kk]);
                path= new TextField("pic.jpg");
                picsize=new TextField("70");
                msg=new Label("Welcome to Sonali Calendar");
                ucal=new GregorianCalendar(); // Make a calendar object
                String s=""+ucal.get(Calendar.YEAR);
                year=new TextField(s);
//first row
                frame.add(new Label("Input values for your calendar"));
                frame.add(new Label("(default values are indicated)"));
// second row
                frame.add(new Label("Input the year for which you want the calendar"));
                frame.add(year);
//third row
                frame.add(new Label("What title do you want on top"));
                frame.add(title);
//fourth row
                frame.add(new Label("Color of calendar font"));
                frame.add(fntcol);
//fifth row
                frame.add(new Label("Fade the picture in background upto (%)"));
                frame.add(fade);
//sixth row
                frame.add(new Label("Name of pciture file (jpg, gif or jpeg)"));
                frame.add(path);
// seventh row
                frame.add(new Label("Size of picture (in % of window size)"));
                frame.add(picsize);
// eighth row
                Panel p=new Panel();
                p.setLayout(new GridLayout(1,2));
                p.add(calen);
                p.add(close);
                frame.add(p);
                Panel pp=new Panel();
                pp.setLayout(new GridLayout(1,2));
                pp.add(home);
                pp.add(email);
                frame.add(pp);
//end of frame layout
                font1=new Font("Arial",Font.BOLD,18);
                fm1=getFontMetrics(font1);
                font2=new Font("Arial",Font.BOLD,14);
                fm2=getFontMetrics(font2);
                mm=new int[12];
        }
        public void init(){
                setFont(new Font("Arial",Font.PLAIN,12));
                frame.pack();
                frame.show();
                Dimension d=getSize();
                wid=d.width;
                ht=d.height;
                try{
			url=new URL("http://www.pratyush.net");
                        mail=new URL("mailto:pankaj@pratyush.net");
		}catch(MalformedURLException e){System.out.println("malformed URL");}
	}

	public void start(){}
	public void stop(){}

	public void Update(Graphics g){
		paint(g);
	}
        public void mouseClicked(MouseEvent e){
		Component o=e.getComponent();
                if(o==close){
                        if(frame.isShowing())
                                frame.hide();
                }
                if(o==calen){
                        frame.hide();
                        startcalendar();
                }
                if(o==home){
                        this.getAppletContext().showDocument(url);
                }
                if(o==email){
                        this.getAppletContext().showDocument(mail);
                }
        }
	public void mouseReleased(MouseEvent e){}
	public void mousePressed(MouseEvent e){}
	public void mouseExited(MouseEvent e){}
	public void mouseEntered(MouseEvent e){}
        public void itemStateChanged(ItemEvent e) {}
        public void getbackimage(){
                wide=imagesize*wid/100;
                high=(imagesize*ht)/100;
                Image temp=img.getScaledInstance(wide, high, 2);
                pix = new int[wide * high];
                try{
                        PixelGrabber pixelgrabber = new PixelGrabber(temp, 0, 0, wide, high, pix, 0, wide);
                        pixelgrabber.grabPixels();
                }catch(InterruptedException interruptedexception){
                        System.out.println("Unable to grab pixels" + interruptedexception);
                }
                for(int j = 0; j < wide * high; j++)
                pix[j] = pix[j] & 0xffffff | alpha;
                pic = createImage(new MemoryImageSource(wide, high, pix, 0, wide));
                dopaint=true;
        }
        public void getvalues(){
                yr=Integer.parseInt(year.getText());
                stitle=title.getText()+"Year "+yr;
//get font color
                if(fntcol.getSelectedItem()=="blue")
                        fcol=Color.blue;
                if(fntcol.getSelectedItem()=="black")
                        fcol=(Color.black);
                if(fntcol.getSelectedItem()=="cyan")
                        fcol=(Color.cyan);
                if(fntcol.getSelectedItem()=="darkGray")
                        fcol=(Color.darkGray);
                if(fntcol.getSelectedItem()=="gray")
                        fcol=(Color.gray);
                if(fntcol.getSelectedItem()=="green")
                        fcol=(Color.green);
                if(fntcol.getSelectedItem()=="lightGray")
                        fcol=(Color.lightGray);
                if(fntcol.getSelectedItem()=="magenta")
                        fcol=(Color.magenta);
                if(fntcol.getSelectedItem()=="orange")
                        fcol=(Color.orange);
                if(fntcol.getSelectedItem()=="pink")
                        fcol=(Color.pink);
                if(fntcol.getSelectedItem()=="red")
                        fcol=(Color.red);
                if(fntcol.getSelectedItem()=="white")
                        fcol=(Color.white);
                if(fntcol.getSelectedItem()=="yellow")
                        fcol=(Color.yellow);
                double n=Integer.parseInt(fade.getText());
                double k= ((100-n)/100)*255;
                alpha=(int)(k) << 24;
                file="images/"+path.getText();
                img=getImage(getCodeBase(),"images/pic.jpg");
                imagesize=Integer.parseInt(picsize.getText());
                getbackimage();
        }
}