#include "stdafx.h"
#include "resource.h"
#include <afxcmn.h>
#include "General.h"

UINT BadDetectProc(LPVOID lRes);
extern CButton	m_Badetect;
extern CButton	m_Stop;
extern CComboBox	m_Drive;
extern HLOCAL hMem;
extern BOOT *BootPtr;
extern BOOL g_StopThread;
extern HWND hWndMain;
extern LPBYTE DiskBuffer;
extern DWORD Drive;
DLLFUNC *DllThunk32, *DllThunk32Write;
extern CListCtrl m_BadList;
void Message(DWORD CurrSect, DWORD Track, DWORD Head);

UINT BadDetectProc(LPVOID lRes)
{
	DWORD CurrSect = 0;
	while((!g_StopThread) && (!(CurrSect >= BootPtr->TotalSectors))){
		char TmpStr[10];
		DWORD Sector = CurrSect % BootPtr->SectorsPerTrack + 1;
		DWORD CalcSect = CurrSect / BootPtr->SectorsPerTrack;
		DWORD Track = CalcSect/BootPtr->NumHeads;
		DWORD Head = CalcSect % BootPtr->NumHeads;
		Message(CurrSect, Track, Head);
		if(!(DllThunk32)(Drive, Track, Head, Sector, BootPtr->SectorsPerTrack, DiskBuffer)){
			wsprintf(TmpStr, "%u", Track);
			m_BadList.InsertItem(0, TmpStr, NULL);
			wsprintf(TmpStr, "%u", Head);
			m_BadList.SetItemText(0, 1, TmpStr);
			for(int i=1; i<=BootPtr->SectorsPerTrack; i++){
				if(!(DllThunk32)(Drive, Track, Head, i, 1, DiskBuffer)){
					wsprintf(TmpStr, "%u", i);
					m_BadList.SetItemText(0, 2, TmpStr);
					break;
				}
			}
		}
		CurrSect += BootPtr->SectorsPerTrack;
	}
	::SetWindowText(hWndMain, "Bad Sectors Detect");
	if(!g_StopThread){
		m_Stop.EnableWindow(FALSE);	
		m_Badetect.EnableWindow(TRUE);	
		m_Drive.EnableWindow(TRUE);
		g_StopThread = TRUE;
	}
	LocalUnlock(hMem);
	LocalFree(hMem);
	AfxEndThread(0);
	return 0;
}

void Message(DWORD CurrSect, DWORD Track, DWORD Head)
{
	char TmpStr[100];
	wsprintf(TmpStr, "%d%% - Track %u, Head %u", (CurrSect*100)/BootPtr->TotalSectors, Track, Head);
	::SetWindowText(hWndMain, TmpStr);
}
