/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.regexp.CompilerState;
import org.mozilla.javascript.regexp.GreedyState;
import org.mozilla.javascript.regexp.MatchState;
import org.mozilla.javascript.regexp.NativeRegExpCtor;
import org.mozilla.javascript.regexp.RENode;
import org.mozilla.javascript.regexp.RegExpImpl;
import org.mozilla.javascript.regexp.SubString;

public class NativeRegExp
extends ScriptableObject
implements Function {
    public static final int GLOB = 1;
    public static final int FOLD = 2;
    public static final int MULTILINE = 4;
    private static final boolean debug = false;
    static final int JS_BITS_PER_BYTE = 8;
    private static final byte REOP_EMPTY = 0;
    private static final byte REOP_ALT = 1;
    private static final byte REOP_BOL = 2;
    private static final byte REOP_EOL = 3;
    private static final byte REOP_WBDRY = 4;
    private static final byte REOP_WNONBDRY = 5;
    private static final byte REOP_QUANT = 6;
    private static final byte REOP_STAR = 7;
    private static final byte REOP_PLUS = 8;
    private static final byte REOP_OPT = 9;
    private static final byte REOP_LPAREN = 10;
    private static final byte REOP_RPAREN = 11;
    private static final byte REOP_DOT = 12;
    private static final byte REOP_CCLASS = 13;
    private static final byte REOP_DIGIT = 14;
    private static final byte REOP_NONDIGIT = 15;
    private static final byte REOP_ALNUM = 16;
    private static final byte REOP_NONALNUM = 17;
    private static final byte REOP_SPACE = 18;
    private static final byte REOP_NONSPACE = 19;
    private static final byte REOP_BACKREF = 20;
    private static final byte REOP_FLAT = 21;
    private static final byte REOP_FLAT1 = 22;
    private static final byte REOP_JUMP = 23;
    private static final byte REOP_DOTSTAR = 24;
    private static final byte REOP_ANCHOR = 25;
    private static final byte REOP_EOLONLY = 26;
    private static final byte REOP_UCFLAT = 27;
    private static final byte REOP_UCFLAT1 = 28;
    private static final byte REOP_UCCLASS = 29;
    private static final byte REOP_NUCCLASS = 30;
    private static final byte REOP_BACKREFi = 31;
    private static final byte REOP_FLATi = 32;
    private static final byte REOP_FLAT1i = 33;
    private static final byte REOP_UCFLATi = 34;
    private static final byte REOP_UCFLAT1i = 35;
    private static final byte REOP_ANCHOR1 = 36;
    private static final byte REOP_NCCLASS = 37;
    private static final byte REOP_DOTSTARMIN = 38;
    private static final byte REOP_LPARENNON = 39;
    private static final byte REOP_RPARENNON = 40;
    private static final byte REOP_ASSERT = 41;
    private static final byte REOP_ASSERT_NOT = 42;
    private static final byte REOP_END = 43;
    private static final int REOP_FLATLEN_MAX = 255;
    private static int level;
    private static String[] reopname;
    static final String metachars = "|^${*+?().[\\";
    static final String closurechars = "{*+?";
    private String source;
    private int lastIndex;
    private int parenCount;
    private byte flags;
    private byte[] program;
    RENode ren;
    static /* synthetic */ Class class$org$mozilla$javascript$regexp$NativeRegExp;

    static {
        reopname = null;
    }

    public NativeRegExp() {
    }

    public NativeRegExp(Context context, Scriptable scriptable, String string, String string2, boolean bl) {
        this.init(context, scriptable, string, string2, bl);
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return NativeRegExp.execSub(context, this, objectArray, scriptable, false, this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Scriptable compile(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        NativeRegExp nativeRegExp = (NativeRegExp)scriptable;
        String string = objectArray.length == 0 ? "" : ScriptRuntime.toString(objectArray[0]);
        String string2 = objectArray.length > 1 ? ScriptRuntime.toString(objectArray[1]) : null;
        nativeRegExp.init(context, function, string, string2, false);
        return nativeRegExp;
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        return (Scriptable)this.call(context, scriptable, null, objectArray);
    }

    private int doOctal(CompilerState compilerState) {
        char c;
        char[] cArray = compilerState.source;
        int n = compilerState.index;
        int n2 = 0;
        while (++n < cArray.length && (c = cArray[n]) >= '0' && c <= '7') {
            int n3 = 8 * n2 + (c - 48);
            if (n3 > 255) break;
            n2 = n3;
        }
        compilerState.index = --n;
        return n2;
    }

    private void dumpRegExp(CompilerState compilerState, RENode rENode) {
    }

    public static Object exec(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return NativeRegExp.execSub(context, scriptable, objectArray, function, false, function);
    }

    private static Object execSub(Context context, Scriptable scriptable, Object[] objectArray, Scriptable scriptable2, boolean bl, Function function) {
        String string;
        if (!(scriptable instanceof NativeRegExp)) {
            Object[] objectArray2 = new Object[]{((NativeFunction)function).jsGet_name()};
            throw NativeGlobal.constructError(context, "TypeError", ScriptRuntime.getMessage("msg.incompat.call", objectArray2), scriptable2);
        }
        NativeRegExp nativeRegExp = (NativeRegExp)scriptable;
        if (objectArray.length == 0) {
            string = NativeRegExp.getImpl((Context)context).input;
            if (string == null) {
                Object[] objectArray3 = new Object[]{nativeRegExp.toString()};
                throw NativeGlobal.constructError(context, "SyntaxError", ScriptRuntime.getMessage("msg.no.re.input.for", objectArray3), scriptable);
            }
        } else {
            string = ScriptRuntime.toString(objectArray[0]);
        }
        int n = (nativeRegExp.flags & 1) != 0 ? nativeRegExp.lastIndex : 0;
        int[] nArray = new int[]{n};
        Object object = nativeRegExp.executeRegExp(scriptable2, string, nArray, bl);
        if ((nativeRegExp.flags & 1) != 0) {
            nativeRegExp.lastIndex = object == null ? 0 : nArray[0];
        }
        return object;
    }

    Object executeRegExp(Scriptable scriptable, String string, int[] nArray, boolean bl) {
        Object object;
        Scriptable scriptable2;
        Object object2;
        int n;
        NativeRegExp nativeRegExp = this;
        Context context = Context.getCurrentContext();
        RegExpImpl regExpImpl = NativeRegExp.getImpl(context);
        MatchState matchState = new MatchState();
        matchState.anchoring = false;
        matchState.flags = nativeRegExp.flags;
        matchState.scope = scriptable;
        int n2 = nArray[0];
        char[] cArray = string.toCharArray();
        if (n2 > cArray.length) {
            n2 = cArray.length;
        }
        int n3 = n2;
        matchState.cpbegin = 0;
        matchState.cpend = cArray.length;
        matchState.start = n2;
        matchState.skipped = 0;
        matchState.input = cArray;
        matchState.parenCount = 0;
        matchState.maybeParens = new SubString[nativeRegExp.parenCount];
        matchState.parens = new SubString[nativeRegExp.parenCount];
        if ((n3 = this.matchRegExp(matchState, this.ren, n3)) == -1) {
            return null;
        }
        nArray[0] = n = n3 - matchState.cpbegin;
        int n4 = n - (n2 + matchState.skipped);
        int n5 = n3;
        n3 -= n4;
        if (bl) {
            object2 = Boolean.TRUE;
            scriptable2 = null;
        } else {
            object = ScriptableObject.getTopLevelScope(scriptable);
            object2 = ScriptRuntime.newObject(context, (Scriptable)object, "Array", null);
            scriptable2 = (Scriptable)object2;
            String string2 = new String(cArray, n3, n4);
            scriptable2.put(0, scriptable2, (Object)string2);
        }
        if (matchState.parenCount > nativeRegExp.parenCount) {
            throw new RuntimeException();
        }
        if (matchState.parenCount == 0) {
            regExpImpl.parens.setSize(0);
            regExpImpl.lastParen = SubString.emptySubString;
        } else {
            object = null;
            regExpImpl.parens.setSize(matchState.parenCount);
            int n6 = 0;
            while (n6 < matchState.parenCount) {
                object = matchState.parens[n6];
                regExpImpl.parens.setElementAt(object, n6);
                if (!bl) {
                    String string3 = object == null ? "" : ((SubString)object).toString();
                    scriptable2.put(n6 + 1, scriptable2, (Object)string3);
                }
                ++n6;
            }
            regExpImpl.lastParen = object;
        }
        if (!bl) {
            scriptable2.put("index", scriptable2, (Object)new Integer(n2 + matchState.skipped));
            scriptable2.put("input", scriptable2, (Object)string);
        }
        if (regExpImpl.lastMatch == null) {
            regExpImpl.lastMatch = new SubString();
            regExpImpl.leftContext = new SubString();
            regExpImpl.rightContext = new SubString();
        }
        regExpImpl.lastMatch.charArray = cArray;
        regExpImpl.lastMatch.index = n3;
        regExpImpl.lastMatch.length = n4;
        regExpImpl.leftContext.charArray = cArray;
        if (context.getLanguageVersion() == 120) {
            regExpImpl.leftContext.index = n2;
            regExpImpl.leftContext.length = matchState.skipped;
        } else {
            regExpImpl.leftContext.index = 0;
            regExpImpl.leftContext.length = n2 + matchState.skipped;
        }
        regExpImpl.rightContext.charArray = cArray;
        regExpImpl.rightContext.index = n5;
        regExpImpl.rightContext.length = matchState.cpend - n5;
        return object2;
    }

    private void fixNext(CompilerState compilerState, RENode rENode, RENode rENode2, RENode rENode3) {
        RENode rENode4;
        boolean bl = rENode2 != null && (rENode2.flags & 8) == 0;
        while ((rENode4 = rENode.next) != null && rENode4 != rENode3) {
            if (rENode.op == 1) {
                RENode rENode5 = (RENode)rENode.kid;
                if (rENode5.op != 23) {
                    RENode rENode6 = rENode5;
                    while (rENode6.next != null) {
                        if (rENode6.op == 1) {
                            throw new RuntimeException("REOP_ALT not expected");
                        }
                        rENode6 = rENode6.next;
                    }
                    rENode6.next = new RENode(compilerState, 23, null);
                    rENode6.next.flags = (byte)(rENode6.next.flags | 8);
                    rENode6.flags = (byte)(rENode6.flags | 0x10);
                    this.fixNext(compilerState, rENode5, rENode2, rENode3);
                }
            }
            rENode = rENode4;
        }
        if (rENode2 != null) {
            rENode2.flags = (rENode2.flags & 8) == 0 ? (byte)(rENode2.flags | 8) : (byte)(rENode2.flags | 0x20);
        }
        rENode.next = rENode2;
        if (bl) {
            rENode.flags = (byte)(rENode.flags | 0x10);
        }
        switch (rENode.op) {
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 39: 
            case 41: 
            case 42: {
                this.fixNext(compilerState, (RENode)rENode.kid, rENode2, rENode3);
                break;
            }
        }
    }

    public String getClassName() {
        return "RegExp";
    }

    static char getEscape(char c) {
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'v': {
                return '\u000b';
            }
        }
        throw new RuntimeException();
    }

    public byte getFlags() {
        return this.flags;
    }

    public boolean getGlobal() {
        return (this.flags & 1) != 0;
    }

    public boolean getIgnoreCase() {
        return (this.flags & 2) != 0;
    }

    private static RegExpImpl getImpl(Context context) {
        return (RegExpImpl)ScriptRuntime.getRegExpProxy(context);
    }

    public long getLastIndex() {
        return (long)this.lastIndex & 0xFFFFFFFFL;
    }

    public boolean getMultiline() {
        return (this.flags & 4) != 0;
    }

    private String getPrintableString(String string) {
        return "";
    }

    public String getSource() {
        return this.source;
    }

    int greedyRecurse(GreedyState greedyState, int n, int n2) {
        int n3;
        int n4 = greedyState.state.parenCount;
        int n5 = this.matchRENodes(greedyState.state, greedyState.kid, greedyState.next, n);
        if (n5 == -1) {
            greedyState.state.parenCount = n4;
            if (n2 != -1) {
                this.matchRENodes(greedyState.state, greedyState.kid, greedyState.next, n2);
            }
            return this.matchRENodes(greedyState.state, greedyState.next, greedyState.stop, n);
        }
        if (n5 == n) {
            return n5;
        }
        if (greedyState.maxKid == 0 || ++greedyState.kidCount < greedyState.maxKid) {
            n3 = this.greedyRecurse(greedyState, n5, n);
            if (n3 != -1) {
                return n3;
            }
            --greedyState.kidCount;
            greedyState.state.parenCount = n4;
            this.matchRENodes(greedyState.state, greedyState.kid, greedyState.next, n);
        }
        if ((n3 = this.matchRENodes(greedyState.state, greedyState.next, greedyState.stop, n5)) != -1) {
            return n3;
        }
        greedyState.state.parenCount = n4;
        if (n2 != -1) {
            this.matchRENodes(greedyState.state, greedyState.kid, greedyState.next, n2);
        }
        return this.matchRENodes(greedyState.state, greedyState.next, greedyState.stop, n);
    }

    public void init(Context context, Scriptable scriptable, String string, String string2, boolean bl) {
        int n;
        this.source = string;
        this.flags = 0;
        if (string2 != null) {
            int n2 = 0;
            while (n2 < string2.length()) {
                n = string2.charAt(n2);
                if (n == 103) {
                    this.flags = (byte)(this.flags | 1);
                } else if (n == 105) {
                    this.flags = (byte)(this.flags | 2);
                } else if (n == 109) {
                    this.flags = (byte)(this.flags | 4);
                } else {
                    Object[] objectArray = new Object[]{new Character((char)n)};
                    throw NativeGlobal.constructError(context, "SyntaxError", ScriptRuntime.getMessage("msg.invalid.re.flag", objectArray), scriptable);
                }
                ++n2;
            }
        }
        CompilerState compilerState = new CompilerState(string, this.flags, context, scriptable);
        if (bl) {
            this.ren = null;
            n = string.length();
            int n3 = 0;
            while (n > 0) {
                int n4 = n;
                if (n4 > 255) {
                    n4 = 255;
                }
                RENode rENode = new RENode(compilerState, n4 == 1 ? (byte)22 : 21, new Integer(n3));
                rENode.flags = (byte)4;
                if (n4 > 1) {
                    rENode.kid2 = n3 + n4;
                } else {
                    rENode.flags = (byte)(rENode.flags | 2);
                    rENode.chr = compilerState.source[n3];
                }
                n3 += n4;
                n -= n4;
                if (this.ren == null) {
                    this.ren = rENode;
                    continue;
                }
                this.setNext(compilerState, this.ren, rENode);
            }
        } else {
            this.ren = this.parseRegExp(compilerState);
        }
        if (this.ren == null) {
            return;
        }
        RENode rENode = new RENode(compilerState, 43, null);
        this.setNext(compilerState, this.ren, rENode);
        this.lastIndex = 0;
        this.parenCount = compilerState.parenCount;
        this.flags = this.flags;
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        this.setPrototype(ScriptableObject.getClassPrototype(scriptable, "RegExp"));
        this.setParentScope(scriptable);
    }

    public static void init(Scriptable scriptable) throws PropertyException {
        NativeRegExp nativeRegExp = new NativeRegExp();
        nativeRegExp.setParentScope(scriptable);
        nativeRegExp.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        String[] stringArray = new String[]{"compile", "toString", "exec", "test"};
        nativeRegExp.defineFunctionProperties(stringArray, class$org$mozilla$javascript$regexp$NativeRegExp != null ? class$org$mozilla$javascript$regexp$NativeRegExp : (class$org$mozilla$javascript$regexp$NativeRegExp = NativeRegExp.class$("org.mozilla.javascript.regexp.NativeRegExp")), 2);
        String[] stringArray2 = new String[]{"lastIndex", "source", "global", "ignoreCase", "multiline"};
        int[] nArray = new int[]{4, 5, 5, 5, 5};
        int n = 0;
        while (n < stringArray2.length) {
            nativeRegExp.defineProperty(stringArray2[n], class$org$mozilla$javascript$regexp$NativeRegExp != null ? class$org$mozilla$javascript$regexp$NativeRegExp : NativeRegExp.class$("org.mozilla.javascript.regexp.NativeRegExp"), nArray[n]);
            ++n;
        }
        Scriptable scriptable2 = NativeRegExpCtor.init(scriptable);
        scriptable2.put("prototype", scriptable2, (Object)nativeRegExp);
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    static boolean isWord(char c) {
        return Character.isLetter(c) || NativeRegExp.isDigit(c) || c == '_';
    }

    private static boolean matchChar(int n, char c, char c2) {
        if (c == c2) {
            return true;
        }
        if ((n & 2) != 0) {
            return (c = Character.toUpperCase(c)) == (c2 = Character.toUpperCase(c2)) || Character.toLowerCase(c) == Character.toLowerCase(c2);
        }
        return false;
    }

    int matchGreedyKid(MatchState matchState, RENode rENode, RENode rENode2, int n, int n2, int n3) {
        GreedyState greedyState = new GreedyState();
        greedyState.state = matchState;
        greedyState.kid = (RENode)rENode.kid;
        greedyState.next = rENode.next;
        greedyState.stop = rENode2;
        greedyState.kidCount = n;
        greedyState.maxKid = rENode.op == 6 ? rENode.max : (short)0;
        return this.greedyRecurse(greedyState, n2, n3);
    }

    int matchNonGreedyKid(MatchState matchState, RENode rENode, int n, int n2, int n3) {
        int n4 = this.matchRENodes(matchState, rENode.next, null, n3);
        if (n4 != -1) {
            return n3;
        }
        int n5 = this.matchRENodes(matchState, (RENode)rENode.kid, rENode.next, n3);
        if (n5 == -1) {
            return -1;
        }
        if (n5 == n3) {
            return n5;
        }
        return this.matchNonGreedyKid(matchState, rENode, n, n2, n5);
    }

    /*
     * Unable to fully structure code
     */
    int matchRENodes(MatchState var1_1, RENode var2_2, RENode var3_3, int var4_4) {
        var6_5 = var1_1.input;
        block30: while (var2_2 != var3_3 && var2_2 != null) {
            switch (var2_2.op) {
                case 1: {
                    if (var2_2.next.op != 1) {
                        var2_2 = (RENode)var2_2.kid;
                        break;
                    }
                    var5_6 = var1_1.parenCount;
                    var7_7 = this.matchRENodes(var1_1, (RENode)var2_2.kid, var3_3, var4_4);
                    if (var7_7 != -1) {
                        return var7_7;
                    }
                    var8_23 = var5_6;
                    while (var8_23 < var1_1.parenCount) {
                        var1_1.parens[var8_23].length = 0;
                        ++var8_23;
                    }
                    var1_1.parenCount = var5_6;
                    ** GOTO lbl234
                }
                case 6: {
                    var7_8 = -1;
                    var5_6 = 0;
                    while (var5_6 < var2_2.min) {
                        var8_24 = this.matchRENodes(var1_1, (RENode)var2_2.kid, var2_2.next, var4_4);
                        if (var8_24 == -1) {
                            return -1;
                        }
                        var7_8 = var4_4;
                        var4_4 = var8_24;
                        ++var5_6;
                    }
                    if (var5_6 != var2_2.max) {
                        if ((var2_2.flags & 128) == 0) {
                            return this.matchGreedyKid(var1_1, var2_2, var3_3, var5_6, var4_4, var7_8);
                        }
                        if ((var4_4 = this.matchNonGreedyKid(var1_1, var2_2, var5_6, var2_2.max, var4_4)) == -1) {
                            return -1;
                        }
                    }
                    ** GOTO lbl234
                }
                case 8: {
                    var7_9 = this.matchRENodes(var1_1, (RENode)var2_2.kid, var2_2.next, var4_4);
                    if (var7_9 == -1) {
                        return -1;
                    }
                    if ((var2_2.flags & 128) == 0) {
                        return this.matchGreedyKid(var1_1, var2_2, var3_3, 1, var7_9, var4_4);
                    }
                    var4_4 = this.matchNonGreedyKid(var1_1, var2_2, 1, 0, var7_9);
                    if (var4_4 == -1) {
                        return -1;
                    }
                    ** GOTO lbl234
                }
                case 7: {
                    if ((var2_2.flags & 128) == 0) {
                        return this.matchGreedyKid(var1_1, var2_2, var3_3, 0, var4_4, -1);
                    }
                    if ((var4_4 = this.matchNonGreedyKid(var1_1, var2_2, 0, 0, var4_4)) == -1) {
                        return -1;
                    }
                    ** GOTO lbl234
                }
                case 9: {
                    var7_10 = var1_1.parenCount;
                    if ((var2_2.flags & 128) != 0 && (var8_25 = this.matchRENodes(var1_1, var2_2.next, var3_3, var4_4)) != -1) {
                        return var8_25;
                    }
                    var8_26 = this.matchRENodes(var1_1, (RENode)var2_2.kid, var2_2.next, var4_4);
                    if (var8_26 != -1) ** GOTO lbl60
                    var1_1.parenCount = var7_10;
                    ** GOTO lbl234
lbl60:
                    // 1 sources

                    var9_34 = this.matchRENodes(var1_1, var2_2.next, var3_3, var8_26);
                    if (var9_34 != -1) ** GOTO lbl64
                    var1_1.parenCount = var7_10;
                    ** GOTO lbl234
lbl64:
                    // 1 sources

                    return var9_34;
                }
                case 39: {
                    var2_2 = (RENode)var2_2.kid;
                    break;
                }
                case 10: {
                    var5_6 = var2_2.num;
                    var2_2 = (RENode)var2_2.kid;
                    var7_11 = var1_1.parens[var5_6];
                    if (var7_11 == null) {
                        var7_11 = var1_1.parens[var5_6] = new SubString();
                        var7_11.charArray = var6_5;
                    }
                    var7_11.index = var4_4;
                    var7_11.length = 0;
                    if (var5_6 < var1_1.parenCount) continue block30;
                    var1_1.parenCount = var5_6 + 1;
                    break;
                }
                case 11: {
                    var5_6 = var2_2.num;
                    var7_12 = var1_1.parens[var5_6];
                    if (var7_12 == null) {
                        throw new RuntimeException("Paren problem");
                    }
                    var7_12.length = var4_4 - var7_12.index;
                    ** GOTO lbl234
                }
                case 41: {
                    var7_13 = this.matchRENodes(var1_1, (RENode)var2_2.kid, var2_2.next, var4_4);
                    if (var7_13 == -1) {
                        return -1;
                    }
                    ** GOTO lbl234
                }
                case 42: {
                    var7_14 = this.matchRENodes(var1_1, (RENode)var2_2.kid, var2_2.next, var4_4);
                    if (var7_14 != -1) {
                        return -1;
                    }
                    ** GOTO lbl234
                }
                case 20: {
                    var5_6 = var2_2.num;
                    if (var5_6 >= var1_1.parens.length) {
                        Context.reportError(ScriptRuntime.getMessage("msg.bad.backref", null));
                        return -1;
                    }
                    var7_15 = var1_1.parens[var5_6];
                    if (var7_15 == null) {
                        var7_15 = var1_1.parens[var5_6] = new SubString();
                    }
                    if (var6_5.length - var4_4 < (var8_27 = var7_15.length)) {
                        return -1;
                    }
                    var9_34 = 0;
                    while (var9_34 < var8_27) {
                        if (!NativeRegExp.matchChar(var1_1.flags, var6_5[var4_4], var7_15.charArray[var7_15.index + var9_34])) {
                            return -1;
                        }
                        ++var9_34;
                        ++var4_4;
                    }
                    ** GOTO lbl234
                }
                case 13: {
                    if (var4_4 >= var6_5.length) ** GOTO lbl130
                    if (var2_2.bitmap == null) {
                        var7_16 = var2_2.s != null ? var2_2.s : this.source.toCharArray();
                        var2_2.buildBitmap(var1_1, var7_16, (var1_1.flags & 2) != 0);
                    }
                    if ((var8_28 = (var7_17 = var6_5[var4_4]) >>> 3) < var2_2.bmsize) ** GOTO lbl125
                    if (var2_2.kid2 != -1) ** GOTO lbl124
                    ++var4_4;
                    ** GOTO lbl234
lbl124:
                    // 1 sources

                    return -1;
lbl125:
                    // 1 sources

                    var9_34 = var7_17 & 7;
                    if ((var2_2.bitmap[var8_28] & (var9_34 = 1 << var9_34)) == 0) ** GOTO lbl129
                    ++var4_4;
                    ** GOTO lbl234
lbl129:
                    // 1 sources

                    return -1;
lbl130:
                    // 1 sources

                    return -1;
                }
                case 12: {
                    if (var4_4 >= var6_5.length || var6_5[var4_4] == '\n') ** GOTO lbl135
                    ++var4_4;
                    ** GOTO lbl234
lbl135:
                    // 1 sources

                    return -1;
                }
                case 38: {
                    var7_18 = var4_4;
                    while (var7_18 < var6_5.length) {
                        var8_29 = this.matchRENodes(var1_1, var2_2.next, var3_3, var7_18);
                        if (var8_29 != -1) {
                            return var8_29;
                        }
                        if (var6_5[var7_18] == '\n') {
                            return -1;
                        }
                        ++var7_18;
                    }
                    return -1;
                }
                case 24: {
                    var7_19 = var4_4;
                    while (var7_19 < var6_5.length) {
                        if (var6_5[var7_19] == '\n') break;
                        ++var7_19;
                    }
                    while (var7_19 >= var4_4) {
                        var8_30 = this.matchRENodes(var1_1, var2_2.next, var3_3, var7_19);
                        if (var8_30 != -1) {
                            return var8_30;
                        }
                        --var7_19;
                    }
                    return -1;
                }
                case 4: {
                    if (!((var4_4 == 0 || NativeRegExp.isWord(var6_5[var4_4 - 1]) == false) ^ (var4_4 >= var6_5.length || NativeRegExp.isWord(var6_5[var4_4]) == false))) {
                        return -1;
                    }
                    ** GOTO lbl234
                }
                case 5: {
                    if (!((var4_4 == 0 || NativeRegExp.isWord(var6_5[var4_4 - 1]) == false) ^ (var4_4 < var6_5.length && NativeRegExp.isWord(var6_5[var4_4]) != false))) {
                        return -1;
                    }
                    ** GOTO lbl234
                }
                case 3: 
                case 26: {
                    if (var4_4 == var6_5.length) ** GOTO lbl234
                    var7_20 = Context.getCurrentContext();
                    var8_31 = NativeRegExp.getImpl(var7_20);
                    if (!var8_31.multiline && (var1_1.flags & 4) == 0) ** GOTO lbl176
                    if (var6_5[var4_4] != '\n') {
                        return -1;
                    }
                    ** GOTO lbl234
lbl176:
                    // 1 sources

                    return -1;
                }
                case 2: {
                    var7_21 = Context.getCurrentContext();
                    var8_32 = NativeRegExp.getImpl(var7_21);
                    if (var4_4 != 0 && (var4_4 >= var6_5.length || !var8_32.multiline && (var1_1.flags & 4) == 0 || var6_5[var4_4 - 1] != '\n')) {
                        return -1;
                    }
                    ** GOTO lbl234
                }
                case 14: {
                    if (var4_4 >= var6_5.length || !NativeRegExp.isDigit(var6_5[var4_4])) ** GOTO lbl187
                    ++var4_4;
                    ** GOTO lbl234
lbl187:
                    // 1 sources

                    return -1;
                }
                case 15: {
                    if (var4_4 >= var6_5.length || NativeRegExp.isDigit(var6_5[var4_4])) ** GOTO lbl192
                    ++var4_4;
                    ** GOTO lbl234
lbl192:
                    // 1 sources

                    return -1;
                }
                case 16: {
                    if (var4_4 >= var6_5.length || !NativeRegExp.isWord(var6_5[var4_4])) ** GOTO lbl197
                    ++var4_4;
                    ** GOTO lbl234
lbl197:
                    // 1 sources

                    return -1;
                }
                case 17: {
                    if (var4_4 >= var6_5.length || NativeRegExp.isWord(var6_5[var4_4])) ** GOTO lbl202
                    ++var4_4;
                    ** GOTO lbl234
lbl202:
                    // 1 sources

                    return -1;
                }
                case 18: {
                    if (var4_4 >= var6_5.length || !TokenStream.isJSSpace(var6_5[var4_4]) && !TokenStream.isJSLineTerminator(var6_5[var4_4])) ** GOTO lbl207
                    ++var4_4;
                    ** GOTO lbl234
lbl207:
                    // 1 sources

                    return -1;
                }
                case 19: {
                    if (var4_4 >= var6_5.length || TokenStream.isJSSpace(var6_5[var4_4]) || TokenStream.isJSLineTerminator(var6_5[var4_4])) ** GOTO lbl212
                    ++var4_4;
                    ** GOTO lbl234
lbl212:
                    // 1 sources

                    return -1;
                }
                case 22: {
                    if (var4_4 >= var6_5.length || !NativeRegExp.matchChar(var1_1.flags, var2_2.chr, var6_5[var4_4])) ** GOTO lbl217
                    ++var4_4;
                    ** GOTO lbl234
lbl217:
                    // 1 sources

                    return -1;
                }
                case 21: {
                    var7_22 = var2_2.s != null ? var2_2.s : this.source.toCharArray();
                    var8_33 = (Integer)var2_2.kid;
                    var9_34 = var2_2.kid2 - var8_33;
                    if (var6_5.length - var4_4 < var9_34) {
                        return -1;
                    }
                    var10_35 = 0;
                    while (var10_35 < var9_34) {
                        if (!NativeRegExp.matchChar(var1_1.flags, var6_5[var4_4], var7_22[var8_33 + var10_35])) {
                            return -1;
                        }
                        ++var10_35;
                        ++var4_4;
                    }
                    ** GOTO lbl234
                }
                default: {
                    throw new RuntimeException("Unsupported by node matcher");
                }
lbl234:
                // 27 sources

                case 0: 
                case 23: 
                case 40: 
                case 43: {
                    var2_2 = var2_2.next;
                }
            }
        }
        return var4_4;
    }

    int matchRegExp(MatchState matchState, RENode rENode, int n) {
        int n2 = n;
        while (n2 <= matchState.input.length) {
            matchState.skipped = n2 - n;
            matchState.parenCount = 0;
            int n3 = this.matchRENodes(matchState, rENode, null, n2);
            if (n3 != -1) {
                return n3;
            }
            ++n2;
        }
        return -1;
    }

    private RENode parseAltern(CompilerState compilerState) {
        char c;
        RENode rENode = this.parseItem(compilerState);
        if (rENode == null) {
            return null;
        }
        RENode rENode2 = rENode;
        int n = 0;
        char[] cArray = compilerState.source;
        int n2 = compilerState.index;
        while (n2 != cArray.length && (c = cArray[n2]) != '|' && c != ')') {
            RENode rENode3 = this.parseItem(compilerState);
            if (rENode3 == null) {
                return null;
            }
            this.setNext(compilerState, rENode2, rENode3);
            n |= rENode3.flags;
            rENode2 = rENode3;
            n2 = compilerState.index;
        }
        rENode.flags = (byte)(rENode.flags | n & 4);
        return rENode;
    }

    /*
     * Unable to fully structure code
     */
    RENode parseAtom(CompilerState var1_1) {
        var2_2 = 0;
        var4_3 = null;
        var8_4 = false;
        var9_5 = false;
        var10_6 = var1_1.source;
        var12_8 = var11_7 = var1_1.index;
        if (var11_7 == var10_6.length) {
            var1_1.index = var11_7;
            return new RENode(var1_1, 0, null);
        }
        switch (var10_6[var11_7]) {
            case '|': {
                return new RENode(var1_1, 0, null);
            }
            case '(': {
                var7_9 = 43;
                if (var10_6[var11_7 + 1] == '?') {
                    switch (var10_6[var11_7 + 2]) {
                        case ':': {
                            var7_9 = 39;
                            break;
                        }
                        case '=': {
                            var7_9 = 41;
                            break;
                        }
                        case '!': {
                            var7_9 = 42;
                            break;
                        }
                    }
                }
                if (var7_9 == 43) {
                    var7_9 = 10;
                    var2_2 = var1_1.parenCount++;
                    var1_1.index = var11_7 + 1;
                } else {
                    var1_1.index = var11_7 + 3;
                }
                var5_11 = this.parseRegExp(var1_1);
                if (var5_11 == null) {
                    return null;
                }
                var11_7 = var1_1.index;
                if (var11_7 >= var10_6.length || var10_6[var11_7] != ')') {
                    this.reportError("msg.unterm.paren", this.tail(var10_6, var12_8), var1_1);
                    return null;
                }
                ++var11_7;
                var4_3 = new RENode(var1_1, var7_9, var5_11);
                var4_3.flags = (byte)(var5_11.flags & 5);
                var4_3.num = var2_2;
                if (var7_9 != 10 && var7_9 != 39) break;
                var5_11 = new RENode(var1_1, (byte)(var7_9 + 1), null);
                this.setNext(var1_1, var4_3, var5_11);
                var5_11.num = var2_2;
                break;
            }
            case '.': {
                var7_10 = 12;
                if (++var11_7 < var10_6.length && var10_6[var11_7] == '*') {
                    var7_10 = 24;
                    if (++var11_7 < var10_6.length && var10_6[var11_7] == '?') {
                        ++var11_7;
                        var7_10 = 38;
                    }
                }
                var4_3 = new RENode(var1_1, (byte)var7_10, null);
                if (var4_3.op != 12) break;
                var4_3.flags = (byte)6;
                break;
            }
            case '[': {
                if (++var11_7 == var10_6.length) {
                    this.reportError("msg.unterm.class", this.tail(var10_6, var12_8), var1_1);
                    return null;
                }
                var6_12 = var10_6[var11_7];
                var4_3 = new RENode(var1_1, 13, new Integer(var11_7));
                if (var6_12 == '^' && ++var11_7 == var10_6.length) {
                    this.reportError("msg.unterm.class", this.tail(var10_6, var12_8), var1_1);
                    return null;
                }
                while (true) {
                    if (++var11_7 == var10_6.length) {
                        this.reportError("msg.unterm.paren", this.tail(var10_6, var12_8), var1_1);
                        return null;
                    }
                    var6_12 = var10_6[var11_7];
                    if (var6_12 == ']') break;
                    if (var6_12 != '\\' || var11_7 + 1 == var10_6.length) continue;
                    ++var11_7;
                }
                var4_3.kid2 = var11_7++;
                var4_3.flags = (byte)6;
                break;
            }
            case '\\': {
                if (++var11_7 == var10_6.length) {
                    Context.reportError(ScriptRuntime.getMessage("msg.trail.backslash", null));
                    return null;
                }
                var6_13 = var10_6[var11_7];
                switch (var6_13) {
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': 
                    case 'v': {
                        var6_13 = NativeRegExp.getEscape(var6_13);
                        var4_3 = new RENode(var1_1, 22, null);
                        break;
                    }
                    case 'd': {
                        var4_3 = new RENode(var1_1, 14, null);
                        break;
                    }
                    case 'D': {
                        var4_3 = new RENode(var1_1, 15, null);
                        break;
                    }
                    case 'w': {
                        var4_3 = new RENode(var1_1, 16, null);
                        break;
                    }
                    case 'W': {
                        var4_3 = new RENode(var1_1, 17, null);
                        break;
                    }
                    case 's': {
                        var4_3 = new RENode(var1_1, 18, null);
                        break;
                    }
                    case 'S': {
                        var4_3 = new RENode(var1_1, 19, null);
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (var1_1.cx.getLanguageVersion() == 0 || var1_1.cx.getLanguageVersion() > 140) ** GOTO lbl145
                        switch (var6_13) {
                            case '0': {
                                var1_1.index = var11_7;
                                var2_2 = this.doOctal(var1_1);
                                var11_7 = var1_1.index;
                                var4_3 = new RENode(var1_1, 22, null);
                                var6_13 = (char)var2_2;
                                ** break;
                            }
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                var2_2 = NativeRegExp.unDigit(var6_13);
                                var3_14 = 1;
                                while (++var11_7 < var10_6.length && NativeRegExp.isDigit(var6_13 = var10_6[var11_7])) {
                                    var2_2 = 10 * var2_2 + NativeRegExp.unDigit(var6_13);
                                    ++var3_14;
                                }
                                if ((var2_2 == 8 || var2_2 == 9) && var2_2 > var1_1.parenCount) {
                                    var12_8 = --var11_7;
                                    var9_5 = true;
                                    var8_4 = true;
                                    ** break;
                                }
                                if (var3_14 > 1 || var2_2 > var1_1.parenCount) {
                                    var1_1.index = var12_8;
                                    var2_2 = this.doOctal(var1_1);
                                    var11_7 = var1_1.index;
                                    var4_3 = new RENode(var1_1, 22, null);
                                    var6_13 = (char)var2_2;
                                    ** break;
                                }
                                --var11_7;
                                var4_3 = new RENode(var1_1, 20, null);
                                var4_3.num = var2_2 - 1;
                                var4_3.flags = (byte)4;
                                var8_4 = true;
                                ** break;
                            }
                            default: {
                                if (var4_3 == null) ** GOTO lbl210
                            }
                        }
lbl145:
                        // 1 sources

                        if (var6_13 == '0') {
                            var4_3 = new RENode(var1_1, 22, null);
                            var6_13 = '\u0000';
                            ** break;
                        }
                        var2_2 = NativeRegExp.unDigit(var6_13);
                        var3_14 = 1;
                        while (++var11_7 < var10_6.length && NativeRegExp.isDigit(var6_13 = var10_6[var11_7])) {
                            var2_2 = 10 * var2_2 + NativeRegExp.unDigit(var6_13);
                            ++var3_14;
                        }
                        --var11_7;
                        var4_3 = new RENode(var1_1, 20, null);
                        var4_3.num = var2_2 - 1;
                        var4_3.flags = (byte)4;
                        var8_4 = true;
                        ** break;
                    }
                    case 'x': {
                        var12_8 = var11_7++;
                        if (var11_7 < var10_6.length && NativeRegExp.isHex(var6_13 = var10_6[var11_7])) {
                            var2_2 = NativeRegExp.unHex(var6_13);
                            if (++var11_7 < var10_6.length && NativeRegExp.isHex(var6_13 = var10_6[var11_7])) {
                                var2_2 <<= 4;
                                var2_2 += NativeRegExp.unHex(var6_13);
                            } else if (var1_1.cx.getLanguageVersion() != 0 && var1_1.cx.getLanguageVersion() <= 140) {
                                --var11_7;
                            } else {
                                var11_7 = var12_8;
                                var2_2 = 120;
                            }
                        } else {
                            var11_7 = var12_8;
                            var2_2 = 120;
                        }
                        var4_3 = new RENode(var1_1, 22, null);
                        var6_13 = (char)var2_2;
                        ** break;
                    }
                    case 'c': {
                        var6_13 = var10_6[++var11_7];
                        if (!(var6_13 >= 'A' && var6_13 <= 'Z' || var6_13 >= 'a' && var6_13 <= 'z')) {
                            var12_8 = var11_7 -= 2;
                            var9_5 = true;
                            var8_4 = true;
                            ** break;
                        }
                        var6_13 = Character.toUpperCase(var6_13);
                        var6_13 = (char)(var6_13 ^ 64);
                        var4_3 = new RENode(var1_1, 22, null);
                        ** break;
                    }
                    case 'u': {
                        if (var11_7 + 4 < var10_6.length && NativeRegExp.isHex(var10_6[var11_7 + 1]) && NativeRegExp.isHex(var10_6[var11_7 + 2]) && NativeRegExp.isHex(var10_6[var11_7 + 3]) && NativeRegExp.isHex(var10_6[var11_7 + 4])) {
                            var2_2 = (((NativeRegExp.unHex(var10_6[var11_7 + 1]) << 4) + NativeRegExp.unHex(var10_6[var11_7 + 2]) << 4) + NativeRegExp.unHex(var10_6[var11_7 + 3]) << 4) + NativeRegExp.unHex(var10_6[var11_7 + 4]);
                            var6_13 = (char)var2_2;
                            var11_7 += 4;
                            var4_3 = new RENode(var1_1, 22, null);
                            ** break;
                        }
                        var12_8 = var11_7;
                        var9_5 = true;
                        var8_4 = true;
                        ** break;
                    }
                    default: {
                        var12_8 = var11_7;
                        var9_5 = true;
                        var8_4 = true;
                    }
                }
lbl206:
                // 19 sources

                if (var4_3 == null) ** GOTO lbl210
                if (!var8_4) {
                    var4_3.chr = var6_13;
                    var4_3.flags = (byte)6;
                }
lbl210:
                // 5 sources

                var8_4 = false;
                if (!var9_5) {
                    ++var11_7;
                    break;
                }
                var9_5 = false;
            }
            default: {
                while (++var11_7 != var10_6.length && "|^${*+?().[\\".indexOf(var10_6[var11_7]) == -1) {
                }
                var3_14 = var11_7 - var12_8;
                if (var11_7 != var10_6.length && var3_14 > 1 && "{*+?".indexOf(var10_6[var11_7]) != -1) {
                    --var11_7;
                    --var3_14;
                }
                if (var3_14 > 255) {
                    var3_14 = 255;
                    var11_7 = var12_8 + var3_14;
                }
                var4_3 = new RENode(var1_1, var3_14 == 1 ? 22 : 21, new Integer(var12_8));
                var4_3.flags = (byte)4;
                if (var3_14 > 1) {
                    var4_3.kid2 = var11_7;
                    break;
                }
                var4_3.flags = (byte)(var4_3.flags | 2);
                var4_3.chr = var10_6[var12_8];
            }
        }
        var1_1.index = var11_7;
        return var4_3;
    }

    RENode parseItem(CompilerState compilerState) {
        int n = compilerState.index;
        char[] cArray = compilerState.source;
        switch (n < cArray.length ? cArray[n] : 0) {
            case 94: {
                compilerState.index = n + 1;
                RENode rENode = new RENode(compilerState, 2, null);
                rENode.flags = (byte)(rENode.flags | 1);
                return rENode;
            }
            case 36: {
                compilerState.index = n + 1;
                return new RENode(compilerState, (byte)(n == compilerState.indexBegin || (cArray[n - 1] == '(' || cArray[n - 1] == '|') && (n - 1 == compilerState.indexBegin || cArray[n - 2] != '\\') ? 26 : 3), null);
            }
            case 92: {
                byte by;
                switch (++n < cArray.length ? cArray[n] : 0) {
                    case 98: {
                        by = 4;
                        break;
                    }
                    case 66: {
                        by = 5;
                        break;
                    }
                    default: {
                        return this.parseQuantAtom(compilerState);
                    }
                }
                compilerState.index = n + 1;
                RENode rENode = new RENode(compilerState, by, null);
                rENode.flags = (byte)(rENode.flags | 4);
                return rENode;
            }
        }
        return this.parseQuantAtom(compilerState);
    }

    /*
     * Unable to fully structure code
     */
    RENode parseQuantAtom(CompilerState var1_1) {
        var2_2 = this.parseAtom(var1_1);
        if (var2_2 == null) {
            return null;
        }
        var8_3 = var1_1.source;
        var9_4 = var1_1.index;
        block6: while (var9_4 < var8_3.length) {
            switch (var8_3[var9_4]) {
                case '{': {
                    if (++var9_4 == var8_3.length || !NativeRegExp.isDigit(var4_6 = var8_3[var9_4])) {
                        this.reportError("msg.bad.quant", String.valueOf(var8_3[var1_1.index]), var1_1);
                        return null;
                    }
                    var6_8 = NativeRegExp.unDigit(var4_6);
                    while (++var9_4 < var8_3.length && NativeRegExp.isDigit(var4_6 = var8_3[var9_4])) {
                        if ((var6_8 = 10 * var6_8 + NativeRegExp.unDigit(var4_6)) >> 16 == 0) continue;
                        this.reportError("msg.overlarge.max", this.tail(var8_3, var9_4), var1_1);
                        return null;
                    }
                    if (var8_3[var9_4] == ',') {
                        var3_5 = ++var9_4;
                        if (NativeRegExp.isDigit(var8_3[var9_4])) {
                            var7_9 = NativeRegExp.unDigit(var8_3[var9_4]);
                            while (NativeRegExp.isDigit(var4_6 = var8_3[++var9_4])) {
                                if ((var7_9 = 10 * var7_9 + NativeRegExp.unDigit(var4_6)) >> 16 == 0) continue;
                                this.reportError("msg.overlarge.max", String.valueOf(var8_3[var3_5]), var1_1);
                                return null;
                            }
                            if (var7_9 == 0) {
                                this.reportError("msg.zero.quant", this.tail(var8_3, var1_1.index), var1_1);
                                return null;
                            }
                            if (var6_8 > var7_9) {
                                this.reportError("msg.max.lt.min", this.tail(var8_3, var3_5), var1_1);
                                return null;
                            }
                        } else {
                            var7_9 = 0;
                        }
                    } else {
                        if (var6_8 == 0) {
                            this.reportError("msg.zero.quant", this.tail(var8_3, var1_1.index), var1_1);
                            return null;
                        }
                        var7_9 = var6_8;
                    }
                    if (var8_3[var9_4] != '}') {
                        this.reportError("msg.unterm.quant", String.valueOf(var8_3[var1_1.index]), var1_1);
                        return null;
                    }
                    ++var9_4;
                    var5_7 = new RENode(var1_1, 6, var2_2);
                    if (var6_8 > 0 && (var2_2.flags & 4) != 0) {
                        var5_7.flags = (byte)(var5_7.flags | 4);
                    }
                    var5_7.min = (short)var6_8;
                    var5_7.max = (short)var7_9;
                    var2_2 = var5_7;
                    ** GOTO lbl63
                }
                case '*': {
                    ++var9_4;
                    var2_2 = new RENode(var1_1, 7, var2_2);
                    ** GOTO lbl63
                }
                case '+': {
                    ++var9_4;
                    var5_7 = new RENode(var1_1, 8, var2_2);
                    if ((var2_2.flags & 4) != 0) {
                        var5_7.flags = (byte)(var5_7.flags | 4);
                    }
                    var2_2 = var5_7;
                    ** GOTO lbl63
                }
                case '?': {
                    ++var9_4;
                    var2_2 = new RENode(var1_1, 9, var2_2);
lbl63:
                    // 4 sources

                    if (var9_4 >= var8_3.length || var8_3[var9_4] != '?') continue block6;
                    var2_2.flags = (byte)(var2_2.flags | 128);
                    ++var9_4;
                    continue block6;
                }
            }
        }
        var1_1.index = var9_4;
        return var2_2;
    }

    private RENode parseRegExp(CompilerState compilerState) {
        RENode rENode = this.parseAltern(compilerState);
        if (rENode == null) {
            return null;
        }
        int n = compilerState.index;
        char[] cArray = compilerState.source;
        if (n < cArray.length && cArray[n] == '|') {
            RENode rENode2 = rENode;
            if ((rENode = new RENode(compilerState, 1, rENode2)) == null) {
                return null;
            }
            rENode.flags = (byte)(rENode2.flags & 5);
            RENode rENode3 = rENode;
            do {
                compilerState.index = ++n;
                if (n < cArray.length && (cArray[n] == '|' || cArray[n] == ')')) {
                    rENode2 = new RENode(compilerState, 0, null);
                } else {
                    rENode2 = this.parseAltern(compilerState);
                    n = compilerState.index;
                }
                if (rENode2 == null) {
                    return null;
                }
                RENode rENode4 = new RENode(compilerState, 1, rENode2);
                if (rENode4 == null) {
                    return null;
                }
                rENode3.next = rENode4;
                rENode3.flags = (byte)(rENode3.flags | 0x10);
                rENode4.flags = (byte)(rENode2.flags & 5 | 8);
                rENode3 = rENode4;
            } while (n < cArray.length && cArray[n] == '|');
        }
        return rENode;
    }

    private void reportError(String string, String string2, CompilerState compilerState) {
        Object[] objectArray = new Object[]{string2};
        throw NativeGlobal.constructError(compilerState.cx, "SyntaxError", ScriptRuntime.getMessage(string, objectArray), compilerState.scope);
    }

    public void setLastIndex(int n) {
        this.lastIndex = n;
    }

    private void setNext(CompilerState compilerState, RENode rENode, RENode rENode2) {
        this.fixNext(compilerState, rENode, rENode2, null);
    }

    private String tail(char[] cArray, int n) {
        return new String(cArray, n, cArray.length - n);
    }

    public static Object test(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Object object = NativeRegExp.execSub(context, scriptable, objectArray, function, true, function);
        if (object == null || !object.equals(Boolean.TRUE)) {
            object = Boolean.FALSE;
        }
        return object;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('/');
        stringBuffer.append(this.source);
        stringBuffer.append('/');
        if ((this.flags & 1) != 0) {
            stringBuffer.append('g');
        }
        if ((this.flags & 2) != 0) {
            stringBuffer.append('i');
        }
        if ((this.flags & 4) != 0) {
            stringBuffer.append('m');
        }
        return stringBuffer.toString();
    }

    static int unDigit(char c) {
        return c - 48;
    }

    static int unHex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        return 10 + Character.toLowerCase(c) - 97;
    }
}

