/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.Obj;
import java.util.EventObject;
import java.util.Vector;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.ldap.UnsolicitedNotificationEvent;
import javax.naming.ldap.UnsolicitedNotificationListener;

final class EventQueue
implements Runnable {
    private static final boolean debug = false;
    private QueueElement head = null;
    private QueueElement tail = null;
    private Thread qThread = Obj.helper.createThread(this);

    EventQueue() {
        this.qThread.setDaemon(true);
        this.qThread.start();
    }

    synchronized void enqueue(EventObject eventObject, Vector vector) {
        QueueElement queueElement = new QueueElement(eventObject, vector);
        if (this.head == null) {
            this.head = queueElement;
            this.tail = queueElement;
        } else {
            queueElement.next = this.head;
            this.head.prev = queueElement;
            this.head = queueElement;
        }
        this.notify();
    }

    private synchronized QueueElement dequeue() throws InterruptedException {
        while (this.tail == null) {
            this.wait();
        }
        QueueElement queueElement = this.tail;
        this.tail = queueElement.prev;
        if (this.tail == null) {
            this.head = null;
        } else {
            this.tail.next = null;
        }
        queueElement.next = null;
        queueElement.prev = null;
        return queueElement;
    }

    public void run() {
        try {
            QueueElement queueElement;
            while ((queueElement = this.dequeue()) != null) {
                EventObject eventObject = queueElement.event;
                Vector vector = queueElement.vector;
                int n = 0;
                while (n < vector.size()) {
                    if (eventObject instanceof NamingEvent) {
                        ((NamingEvent)eventObject).dispatch((NamingListener)vector.elementAt(n));
                    } else if (eventObject instanceof NamingExceptionEvent) {
                        ((NamingExceptionEvent)eventObject).dispatch((NamingListener)vector.elementAt(n));
                    } else if (eventObject instanceof UnsolicitedNotificationEvent) {
                        ((UnsolicitedNotificationEvent)eventObject).dispatch((UnsolicitedNotificationListener)vector.elementAt(n));
                    }
                    ++n;
                }
                queueElement = null;
                eventObject = null;
                vector = null;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void stop() {
        if (this.qThread != null) {
            this.qThread.interrupt();
            this.qThread = null;
        }
    }

    private class QueueElement {
        QueueElement next = null;
        QueueElement prev = null;
        EventObject event = null;
        Vector vector = null;

        QueueElement(EventObject eventObject, Vector vector) {
            this.event = eventObject;
            this.vector = vector;
        }
    }
}

