/*
 * Decompiled with CFR 0.152.
 */
package GenCns.GenJava;

import GenCns.GenJava.GenericException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class PalmStorage {
    public static boolean m_bDebug = false;
    public static final int eNone = 0;
    public static final int eInteger = 1;
    public static final int eFloat = 2;
    public static final int eDate = 3;
    public static final int eAlpha = 4;
    public static final int eString = 5;
    public static final int eBool = 6;
    public static final int eBitFlag = 7;
    public static final int eRepeateEvt = 8;

    public static void writeByte(FileOutputStream fileOutputStream, int n) throws IOException {
        fileOutputStream.write(n);
    }

    public static void writeWord(FileOutputStream fileOutputStream, int n) throws IOException {
        fileOutputStream.write(n >> 0 & 0xFF);
        fileOutputStream.write(n >> 8 & 0xFF);
    }

    public static void writeDword(FileOutputStream fileOutputStream, int n) throws IOException {
        fileOutputStream.write(n >> 0 & 0xFF);
        fileOutputStream.write(n >> 8 & 0xFF);
        fileOutputStream.write(n >> 16 & 0xFF);
        fileOutputStream.write(n >> 24 & 0xFF);
    }

    public static int readByte(FileInputStream fileInputStream) throws GenericException {
        try {
            int n = fileInputStream.read();
            return n;
        }
        catch (IOException iOException) {
            throw new GenericException(iOException.getMessage());
        }
    }

    public static int readWord(FileInputStream fileInputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n2 = PalmStorage.readByte(fileInputStream);
        n3 = PalmStorage.readByte(fileInputStream);
        n = n2 + 256 * n3;
        return n;
    }

    public static int readDword(FileInputStream fileInputStream) throws IOException {
        int n = PalmStorage.readWord(fileInputStream);
        int n2 = PalmStorage.readWord(fileInputStream);
        int n3 = n + 65536 * n2;
        return n3;
    }

    public static void writeOutData(FileOutputStream fileOutputStream, byte[] byArray) throws GenericException {
        try {
            fileOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new GenericException(iOException.getMessage());
        }
    }

    public static void writeSerializedDword(FileOutputStream fileOutputStream, int n) throws GenericException {
        try {
            PalmStorage.writeDword(fileOutputStream, n);
        }
        catch (IOException iOException) {
            throw new GenericException(iOException.getMessage());
        }
    }

    public static void writeSerializedWord(FileOutputStream fileOutputStream, int n) throws GenericException {
        try {
            PalmStorage.writeWord(fileOutputStream, n);
        }
        catch (IOException iOException) {
            throw new GenericException(iOException.getMessage());
        }
    }

    public static void writeSerializedByte(FileOutputStream fileOutputStream, int n) throws GenericException {
        try {
            PalmStorage.writeByte(fileOutputStream, n);
        }
        catch (IOException iOException) {
            throw new GenericException(iOException.getMessage());
        }
    }

    public static void writeString(FileOutputStream fileOutputStream, String string) throws GenericException {
        try {
            byte[] byArray = new byte[string.length()];
            try {
                string.getBytes(0, string.length(), byArray, 0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new GenericException("Unable to get value to write");
            }
            fileOutputStream.write(byArray, 0, byArray.length);
        }
        catch (Throwable throwable) {
            throw new GenericException("Unable to write string");
        }
    }

    public static void writeSerializedString(FileOutputStream fileOutputStream, String string) throws GenericException {
        int n = string == null ? 0 : string.length();
        try {
            if (n >= 255) {
                PalmStorage.writeSerializedByte(fileOutputStream, 255);
                PalmStorage.writeSerializedWord(fileOutputStream, n);
            } else {
                PalmStorage.writeSerializedByte(fileOutputStream, n);
            }
            if (n != 0) {
                PalmStorage.writeString(fileOutputStream, string);
            }
        }
        catch (IOException iOException) {
            throw new GenericException(iOException.getMessage());
        }
    }

    public static void writeSerializedBoolField(FileOutputStream fileOutputStream, int n) throws GenericException {
        int n2 = 6;
        try {
            PalmStorage.writeSerializedDword(fileOutputStream, n2);
            PalmStorage.writeSerializedDword(fileOutputStream, n);
        }
        catch (IOException iOException) {
            throw new GenericException(iOException.getMessage());
        }
    }

    public static void writeSerializedIntegerField(FileOutputStream fileOutputStream, int n) throws GenericException {
        int n2 = 1;
        try {
            PalmStorage.writeSerializedDword(fileOutputStream, n2);
            PalmStorage.writeSerializedDword(fileOutputStream, n);
        }
        catch (IOException iOException) {
            throw new GenericException(iOException.getMessage());
        }
    }

    public static void writeSerializedStringField(FileOutputStream fileOutputStream, String string, boolean bl) throws GenericException {
        int n = 5;
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        try {
            PalmStorage.writeSerializedDword(fileOutputStream, n);
            PalmStorage.writeSerializedDword(fileOutputStream, n2);
            PalmStorage.writeSerializedString(fileOutputStream, string);
        }
        catch (IOException iOException) {
            throw new GenericException(iOException.getMessage());
        }
    }

    public static void writeSerializedDateField(FileOutputStream fileOutputStream, int n) throws GenericException {
        int n2 = 3;
        try {
            PalmStorage.writeSerializedDword(fileOutputStream, n2);
            PalmStorage.writeSerializedDword(fileOutputStream, n);
        }
        catch (IOException iOException) {
            throw new GenericException(iOException.getMessage());
        }
    }

    public static String readSerializedString(FileInputStream fileInputStream) throws GenericException {
        int n = 0;
        String string = "";
        try {
            n = PalmStorage.readByte(fileInputStream);
            if (n == 255) {
                n = PalmStorage.readSerializedWord(fileInputStream);
            }
            int n2 = 0;
            while (n2 < n) {
                string = string + (char)PalmStorage.readByte(fileInputStream);
                ++n2;
            }
            return string;
        }
        catch (IOException iOException) {
            throw new GenericException(iOException.getMessage());
        }
    }

    public static int readSerializedByte(FileInputStream fileInputStream) throws GenericException {
        try {
            return PalmStorage.readByte(fileInputStream);
        }
        catch (IOException iOException) {
            throw new GenericException(iOException.getMessage());
        }
    }

    public static int readSerializedWord(FileInputStream fileInputStream) throws GenericException {
        try {
            return PalmStorage.readWord(fileInputStream);
        }
        catch (IOException iOException) {
            throw new GenericException(iOException.getMessage());
        }
    }

    public static int readSerializedDword(FileInputStream fileInputStream) throws GenericException {
        try {
            return PalmStorage.readDword(fileInputStream);
        }
        catch (IOException iOException) {
            throw new GenericException(iOException.getMessage());
        }
    }

    public static int FlipSerialDword(int n) throws GenericException {
        int n2 = 0;
        int n3 = 0x1000000;
        int n4 = 1;
        while (n4 < 4) {
            n2 += n % 256 * n3;
            n /= 256;
            n3 /= 256;
            ++n4;
        }
        n2 += n;
        n = n2;
        return n2;
    }

    public static int FlipSerialWord(int n) throws GenericException {
        int n2;
        n = n2 = n % 256 * 256 + n / 256;
        return n2;
    }

    public static String StripCRs(String string) throws GenericException {
        String string2 = "";
        int n = string.indexOf("\r");
        while (n != -1) {
            if (n != 0) {
                string2 = string2 + string.substring(0, n);
            }
            string = string.substring(n + 1);
            n = string.indexOf("\r");
        }
        string2 = string2 + string;
        return string2;
    }

    public static String AddCRs(String string) throws GenericException {
        String string2 = "";
        int n = string.indexOf("\n");
        while (n != -1) {
            string2 = string2 + string.substring(0, n);
            string2 = string2 + "\r\n";
            string = string.substring(n + 1);
            n = string.indexOf("\n");
        }
        if (!string.equals("")) {
            string2 = string2 + string;
        }
        return string2;
    }

    public static void writeCString(DataOutputStream dataOutputStream, String string) throws IOException {
        dataOutputStream.write(string.getBytes());
        dataOutputStream.write(0);
    }

    public static String readCString(DataInputStream dataInputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        do {
            if ((n = dataInputStream.read()) <= 0) continue;
            stringBuffer.append((char)n);
        } while (n > 0);
        return stringBuffer.toString();
    }
}

