use perlchartdir;

######################################
#	Draw a pie chart where the label is on top of the pie
######################################
sub innerlabelpie
{
	#The data for the pie chart
	my $data = [ 25, 18, 15, 12, 30, 35 ];

	#The labels for the pie chart
	my $labels = [ "Labor", "Licenses", "Taxes", "Legal", 
		"Facilities", "Production" ];

	#First, create a PieChart of size 300 pixels x 300 pixels
	my $c = new PieChart(300, 300);

	#Set the center of the pie at (150, 150) and the radius to 120 pixels
	$c->setPieSize(150, 150, 120);

	#Set the label position to -40 pixels from the perimeter of the pie.
	#A negative number means the label is inside the pie.
	$c->setLabelPos(-40);
	
	#Modify the label format to contain three lines showing the sector name,
	#sector value, and the sector percentage. The sector value 99 is shown 
	#as US$99K.
	$c->setLabelFormat("&label&\nUS\$&value&K\n(&percent&%)");

	#Set the pie data and the pie labels
	$c->setData($data, $labels);
	
	#Explode the 1st sector
	$c->sector(0)->setExplode();

	#output the chart as a PNG file
	$c->makeChart("innerlabelpie.png");
}

######################################
#	Draw a pie chart where the label is outside the pie
######################################
sub outerlabelpie
{
	#The data for the pie chart
	my $data = [ 25, 18, 15, 12, 30, 35 ];

	#The labels for the pie chart
	my $labels = [ "Labor", "Licenses", "Taxes", "Legal", 
		"Facilities", "Production" ];

	#First, create a PieChart of size 300 pixels x 300 pixels
	my $c = new PieChart(300, 300);
	
	#Set the center of the pie at (150, 150) and the radius to 80 pixels
	$c->setPieSize(150, 150, 80);

	#Set the label position to be 25 pixels from the pie. A positive value
	#indicates the label is outside the pie. Furthermore, include a join line
	#to link the sector label with the pie.
	$c->setLabelPos(25, $perlchartdir::LineColor);

	#Modify the label format to contain three lines showing the sector name,
	#sector value, and the sector percentage. The sector value 99 is shown 
	#as US$99K.
	$c->setLabelFormat("&label&\nUS\$&value&K\n(&percent&%)");

	#Set the pie data and the pie labels
	$c->setData($data, $labels);
	
	#Explode the 1st sector
	$c->sector(0)->setExplode();

	#output the chart as a PNG file
	$c->makeChart("outerlabelpie.png");
}


innerlabelpie();
outerlabelpie();
