<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="xml" omit-xml-declaration="yes" />
    <xsl:template match="*">
        <Mail><xsl:attribute name="priority"><xsl:value-of select="/Mail/Priority"/></xsl:attribute>
            <Connection>
                <Server><xsl:value-of select="/Mail/Server"/></Server>
                <Port><xsl:value-of select="/Mail/Port"/></Port>
            </Connection>
            <Sender/>
            <Reply-To/>
            <Return-Path/>
            <Rr/>
            <Return-Receipt-To/>
            <Apparently-To/>
            <Received/>
            <Message-ID/>
            <X-Mailer/>
            <Encoding/>
            <Encrypted/>
            <Comment/>
            <MIME-Version/>
            <Newsgroups/>
            <Path/>
            <Followup-To/>
            <Expires/>
            <References/>
            <Control/>
            <Distribution/>
            <Keywords/>
            <Summary/>
            <Approved/>
            <Lines/>
            <Xref/>
            <Organization/>
            <X-Newsreader/>
            <X-Offsets/>
            <X-Unsent/>
            <X-ArticleId/>
            <X-Newsgroup/>
            <X-VoiceMail/>
            <From>
                <Person>
                    <Name>
                        <xsl:value-of select="/Mail/From/Person/Name"/>
                    </Name>
                    <Email>
                        <xsl:value-of select="/Mail/From/Person/Email"/>
                    </Email>
                </Person>
            </From>
            <To>
            	<xsl:for-each select="/Mail/To/*">
                <Person>
                    <Name><xsl:value-of select="Name"/></Name>
                    <Email><xsl:value-of select="Email"/></Email>
                </Person>
                </xsl:for-each>
            </To>
            <Cc>
            	<xsl:for-each select="/Mail/Cc/*">
                <Person>
                    <Name><xsl:value-of select="Name"/></Name>
                    <Email><xsl:value-of select="Email"/></Email>
                </Person>
                </xsl:for-each>
            </Cc>
            <Bcc>
            	<xsl:for-each select="/Mail/Bcc/*">
                <Person>
                    <Name><xsl:value-of select="Name"/></Name>
                    <Email><xsl:value-of select="Email"/></Email>
                </Person>
                </xsl:for-each>
            </Bcc>            
            <Subject><xsl:value-of select="/Mail/Subject"/></Subject>
            <MailBody content-transfer-encoding="default"><xsl:value-of select="/Mail/MailBody"/></MailBody>
            <MailBodyAlt content-transfer-encoding="default"/>
            <Attachments>               
            	<xsl:for-each select="/Mail/AttUrl">
            	    <Attachment content-transfer-encoding="default">
            	        <xsl:attribute name="location"><xsl:value-of select="base"/></xsl:attribute>
            	        <xsl:attribute name="filename"><xsl:value-of select="page"/></xsl:attribute>
            	    </Attachment>
                </xsl:for-each>                
            	<xsl:for-each select="/Mail/AttFile">
            	    <Attachment content-transfer-encoding="default">
            	        <xsl:attribute name="location"><xsl:value-of select="base"/></xsl:attribute>
            	        <xsl:attribute name="filename"><xsl:value-of select="page"/></xsl:attribute>
            	    </Attachment>
                </xsl:for-each>                
            </Attachments>
        </Mail>
    </xsl:template>
</xsl:stylesheet>
