// imgs.h : main header file for the IMGS DLL
//

#if !defined IMAGES_H
#define IMAGES_H 

HBITMAP imgs_rotateByLine(HBITMAP hBmp,int pixelPerMeter, 
		int xBeg, int yBeg, int xEnd, int yEnd);
BOOL imgs_mirrorVertically(HBITMAP hBmp);
HBITMAP imgs_rotateLeft(HBITMAP hBmp,int pixelPerMeter);
HBITMAP imgs_rotateRight(HBITMAP hBmp,int pixelPerMeter);
BOOL imgs_negate(HBITMAP hBmp);
HBITMAP imgs_crop(HBITMAP hBmp,int pixelPerMeter,int xTopLeft, int yTopLeft, 
			   int xBottomRight, int yBottomRight);
BOOL imgs_fillSmallHoles(HBITMAP hBmp);
BOOL imgs_fillHoles(HBITMAP hBmp);
BOOL imgs_connect(HBITMAP hBmp);
BOOL imgs_clean(HBITMAP hBmp);
BOOL imgs_thin(HBITMAP hBmp);
BOOL imgs_thicken(HBITMAP hBmp);

/*	Comments

  These functions implement raster editor operations of
  Algolab Raster to Vector Conversion Toolkit. Install
  Toolkit to see what each of these fuctions does.

  Here hBmp is a DIB - device independent bitmap

  The above functions which return BOOL do not change the
  value of hBmp, they may only change the colors of pixels.
  The functions that return HBITMAP return a new value of hBmp.

  The above functions do not delete the original bitmap.

 */


#endif // IMAGES_H
