#ifndef ANIMICON.H
#include "animicon.h"
#endif

#include <string.h>

animicon::animicon(char * filename, icon::flagType flags, yakLib * myYakLib)
{
  firstFrame = lastFrame = thisFrame = NULL;
  numberOfFrames=0;
  addAll(filename, flags, myYakLib);
}

animicon::~animicon()
{
  animiconNode * nodeCounter, * nextNodeCounter;
  if (firstFrame != lastFrame)
  {
    for (nodeCounter = firstFrame; nodeCounter != lastFrame; nodeCounter = nextNodeCounter)
    {
      nextNodeCounter = nodeCounter->nextFrame;
      delete nodeCounter;
    }
    delete lastFrame;
  }
  if ((firstFrame == lastFrame) && (firstFrame != NULL))
    removeTail();
  firstFrame = lastFrame = thisFrame = NULL;
  numberOfFrames = 0;
}


char far * animicon::add(animiconNode * thisNode)
{
  numberOfFrames++;
  if (firstFrame != NULL)
  {
    lastFrame->nextFrame = thisNode; // make the new node
    lastFrame->nextFrame->prevFrame = lastFrame; //make new node point back
    firstFrame->prevFrame = lastFrame;
    lastFrame = lastFrame->nextFrame;
  }
  else
  {
    firstFrame = thisNode; // make the new node
    lastFrame = firstFrame;
    lastFrame->prevFrame = firstFrame; //make new node point back
    firstFrame->prevFrame = lastFrame; //so it wraps backwards too.
    thisFrame = firstFrame; // look at the first frame for anim purposes.
  }
  if (lastFrame->nextFrame)
    add(lastFrame->nextFrame);
  else
    lastFrame->nextFrame = firstFrame;
  return lastFrame->picture.unrolledPic;
}

char far * animicon::add(char far * filename, icon::flagType flags, yakLib * myYakLib)
{
  numberOfFrames++;
  if (firstFrame != NULL)
  {
    lastFrame->nextFrame = new animiconNode; // make the new node
    lastFrame->nextFrame->prevFrame = lastFrame; //make new node point back
    lastFrame = lastFrame->nextFrame; //make tail point to new node
    lastFrame->nextFrame = firstFrame; // make last frame point to head
    lastFrame->picture.load(filename, flags, myYakLib); //make last frame's icon point to the arg
    firstFrame->prevFrame = lastFrame;
  }
  else
  {
    firstFrame = new animiconNode; // make the new node
    lastFrame = firstFrame;
    lastFrame->prevFrame = firstFrame; //make new node point back
    lastFrame->nextFrame = firstFrame; // make last frame point to head
    lastFrame->picture.load(filename, flags, myYakLib); //make last frame's icon point to the arg
    firstFrame->prevFrame = lastFrame; //so it wraps backwards too.
    thisFrame = firstFrame; // look at the first frame for anim purposes.
  }
  return lastFrame->picture.unrolledPic;
}

void animicon::removeTail(void)
{
  if (firstFrame != lastFrame)
  {
    lastFrame = lastFrame->prevFrame;
    delete (lastFrame->nextFrame);
    lastFrame->nextFrame = firstFrame;
    firstFrame->prevFrame = lastFrame;
  }
  else if (firstFrame == lastFrame)
  {
    delete firstFrame;
    firstFrame = lastFrame = thisFrame = NULL;
  }
  numberOfFrames--;
}


void animicon::addAll(char far * filename, icon::flagType flags, yakLib * myYakLib)
{
  char dummyfile[13], counter[2];
  strcpy(counter, "2");
  strcpy(dummyfile, filename);
  strcat(dummyfile, ".yak");
  while((add(dummyfile, flags, myYakLib) != NULL))  // while there are still files to add
    {
    strcpy(dummyfile, filename);
    if (strlen(dummyfile) < 8)
    {
      strcat(dummyfile, counter);
    }
    else
      dummyfile[strlen(dummyfile) -1] = counter[0];
    strcat(dummyfile, ".yak");
    ++counter[0];
    }
  removeTail();
  if (lastFrame->picture.unrolledPic == NULL)
    firstFrame = NULL;

}


void animicon::advance()
{
  if (thisFrame != NULL)
    thisFrame = thisFrame->nextFrame;
}

void animicon::show(int x, int y, word pagebase)
{
  thisFrame->picture.show(x, y, pagebase);
  advance();
}

void animicon::draw(int x, int y, word pagebase)
{
  thisFrame->picture.showMasked(x, y, pagebase);
}

void animicon::hide(int x, int y, word toOffset, word fromOffset)
{
  thisFrame->prevFrame->picture.hide(x, y, toOffset, fromOffset);
}

void animicon::showZoomed(int x, int y, word offset, int newWidth)
{
  thisFrame->picture.showZoomed(x, y, offset, newWidth);
  advance();
}

void animicon::drawZoomed(int x, int y, word offset, int newWidth)
{
  thisFrame->picture.showZoomed(x, y, offset, newWidth);
}

void animslave::draw(int x, int y, word pagebase)
{
  thisFrame->picture.showMasked(x, y, pagebase);
}

void animslave::show(int x, int y, word pagebase)
{
  thisFrame->picture.showMasked(x, y, pagebase);
  advance();
}

void animslave::showZoomed(int x, int y, word offset, int newWidth)
{
  thisFrame->picture.showZoomed(x, y, offset, newWidth);
  advance();
}

void animslave::drawZoomed(int x, int y, word offset, int newWidth)
{
  thisFrame->picture.showZoomed(x, y, offset, newWidth);
}

void animslave::advance()
{
  if (thisFrame != NULL)
    thisFrame = thisFrame->nextFrame;
}


void animslave::advance(int numFrames)
{
  for (int counter = 0; counter < numFrames; ++counter)
    advance();
}
