//Based on Pascal program created in 2003, rewritten in 2013
//by MCbx
//GPL v. 2 (all soure code)


#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "QColorDialog"
#include "QFileDialog"
#include "QTimer"
#include "QSettings"
#include "QMessageBox"

bool textWasChecked;
QTimer *timer;
QColor gColA, gColB;

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    ui->lbScreener->setMinimumHeight(150);
    ui->lbScreener->setAutoFillBackground(1);
    QPalette palette = ui->lbScreener->palette();
    palette.setColor(ui->lbScreener->backgroundRole(), Qt::black);
    palette.setColor(ui->lbScreener->foregroundRole(), Qt::white);
    ui->lbScreener->setPalette(palette);
    this->setWindowTitle("Burst mode v. 1.0 (MCbx 2014)");

    timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(proceedBurst()));
    ui->splitter->setStretchFactor(0,100);
    ui->tabWidget->setCurrentIndex(0);

    LoadSettings();

    QPushButton  * clearTextButton  = new QPushButton(ui->tabWidget);
    clearTextButton->setText("Clear text");
    connect(clearTextButton,SIGNAL(clicked()),this,SLOT(on_btnClearClick()));
    ui->tabWidget->setCornerWidget(clearTextButton,Qt::BottomRightCorner);


    QStringList params = QApplication::arguments();
    if (params.count()==2)
    {
        QFile f(params[1]);
        if (!f.open(QFile::ReadOnly | QFile::Text))
        {
            QMessageBox mesg;
            mesg.setText("File not read properly!");
            mesg.show();
            this->close();
        }
        ui->txInput->clear();
        ui->txInput->appendPlainText(QString(f.readAll()));
        textWasChecked=false;
        QTextCursor cu(ui->txInput->textCursor());
        cu.movePosition(QTextCursor::Start);
        ui->txInput->setTextCursor(cu);

    }
}


MainWindow::~MainWindow()
{
    SaveSettings();
    delete ui;
}

void MainWindow::on_fontComboBox_currentIndexChanged(const QString &arg1)
{
    QFont f(ui->lbScreener->font());
    f.setFamily(arg1);
    ui->lbScreener->setFont(f);
}

void MainWindow::on_btnBold_clicked()
{
    QFont f(ui->lbScreener->font());
    f.setBold(!f.bold());
    if (f.bold()==1) ui->btnBold->setDown(1); else ui->btnBold->setDown(0);
    ui->lbScreener->setFont(f);
}

void MainWindow::on_btnItalic_clicked()
{
    QFont f(ui->lbScreener->font());
    f.setItalic(!f.italic());
    if (f.italic()==1) ui->btnItalic->setDown(1); else ui->btnItalic->setDown(0);
    ui->lbScreener->setFont(f);
}

void MainWindow::on_btnUnderline_clicked()
{
    QFont f(ui->lbScreener->font());
    f.setUnderline(!f.underline());
    if (f.underline()==1) ui->btnUnderline->setDown(1); else ui->btnUnderline->setDown(0);
    ui->lbScreener->setFont(f);
}

void MainWindow::on_btnForeColor_clicked()
{
    QPalette pal = ui->lbScreener->palette();
    QColor fc = QColorDialog::getColor(pal.color(ui->lbScreener->foregroundRole()),this);
    if (fc.isValid())
    {
        gColB = fc;
        if (ui->cbTexture->isChecked())
        {
           this->on_cbTexture_clicked(1);
        }
        else this->on_cbTexture_clicked(0);
    }
}

void MainWindow::on_btnBackColor_clicked()
{
    QPalette pal = ui->btnBackColor->palette();
    QColor fc = QColorDialog::getColor(pal.color(ui->btnBackColor->backgroundRole()),this);
    if (fc.isValid())
    {
        gColA = fc;
        if (ui->cbTexture->isChecked())
        {
           this->on_cbTexture_clicked(1);
        }
        else this->on_cbTexture_clicked(0);
    }
}

QString prepareForProcessing(QString input)
{
    //This function condenses one-character words from text to prepare it for burst
    //All burst should be made by text from this function.
    QString a = input.simplified();
    a = input.replace("- ","-",Qt::CaseInsensitive); //dialogues
    a = a.replace('\x0a',"\n",Qt::CaseInsensitive);
    a = a.replace(" \x0a","/n",Qt::CaseInsensitive);
    a = a.replace(" \x0d","\n",Qt::CaseInsensitive);
    a = a.replace('\x0d',"\n",Qt::CaseInsensitive);
    a = a.replace(" , ",", ",Qt::CaseInsensitive);  //mismatch in ocr
    a = a.replace(" . ",". ",Qt::CaseInsensitive);  //as above
    a = a.replace(" ? ","? ",Qt::CaseInsensitive);  //crazy writer
    a = a.replace(" ! ","! ",Qt::CaseInsensitive);  //Professor W. Wajs
    a = a.replace("  "," ",Qt::CaseInsensitive);    //Moron-formatted
    a = a.replace("\n\n","\n",Qt::CaseInsensitive); //dual spacing
    a = a.replace("\n\t","\n",Qt::CaseInsensitive); //dual spacing
    a = a.replace("\n ","\n",Qt::CaseInsensitive); //dual spacing
    a = a.replace(" \n ","\n",Qt::CaseInsensitive); //dual spacing
    a = a.replace("\t"," ",Qt::CaseInsensitive);    //Reading err... table?
    a = a.replace("\n\n","\n",Qt::CaseInsensitive); //dual spacing
    a = a.replace(",",", ",Qt::CaseInsensitive);
    a = a.replace("   "," ",Qt::CaseInsensitive);
    a = a.replace("  "," ",Qt::CaseInsensitive);    //Moron-formatted
    a = a.replace("  "," ",Qt::CaseInsensitive);
    a = a.trimmed();
    return a;
}

void MainWindow::on_btnLoadText_clicked()
{
    QString fileName = QFileDialog::getOpenFileName(this, tr("Open File"),
                                                     "",
                                                     tr("Text Files (*.txt)"));
    QFile f(fileName);
    if (!f.open(QFile::ReadOnly | QFile::Text)) return;
    ui->txInput->clear();
    ui->txInput->appendPlainText(QString(f.readAll()));
    if (!textWasChecked)
    {
        ui->txInput->setPlainText(prepareForProcessing(ui->txInput->toPlainText()));
        textWasChecked=true;
    }
}

void MainWindow::on_txInput_textChanged()
{
    if (prepareForProcessing(ui->txInput->toPlainText()).length()==0)
    {
        ui->hsSlider->setValue(1);
        ui->hsSlider->setMaximum(1);
        ui->statusBar->showMessage("Word cound: 0 Chunk count: 0 Approx burst time (s): 0");
        ui->lbScreener->setText("testing");
        return;
    }
    int wordCount = prepareForProcessing(ui->txInput->toPlainText()).split(QRegExp("(\\s|\\n|\\r)+")).count();
    int chunkCount = (wordCount % ui->sbChunkSize->value()) ? wordCount / ui->sbChunkSize->value() + 1 : (wordCount / ui->sbChunkSize->value());
    //using WordCound and WPM we can compute Emit Beranu:
    double eber = ui->sbWPM->value()/(double)60;
    eber = chunkCount / eber;
    ui->statusBar->showMessage("Word cound: "+QString::number(wordCount)+" Chunk count: "+QString::number(chunkCount)+" Approx burst time (s): "+QString::number(eber));
    ui->hsSlider->setValue(1);
    ui->lbScreener->setText( prepareForProcessing(ui->txInput->toPlainText()).split(QRegExp("(\\s|\\n|\\r)+")
                                                                                    , QString::SkipEmptyParts)[0]);
    ui->hsSlider->setMaximum(chunkCount);
    textWasChecked=false;
}

void MainWindow::on_sbChunkSize_valueChanged(int arg1)
{
    if (!textWasChecked)
    {
        ui->txInput->setPlainText(prepareForProcessing(ui->txInput->toPlainText()));
        textWasChecked=true;
    }
    MainWindow::on_txInput_textChanged();
}

void MainWindow::on_sbWPM_valueChanged(int arg1)
{
    if (!textWasChecked)
    {
        ui->txInput->setPlainText(prepareForProcessing(ui->txInput->toPlainText()));
        textWasChecked=true;
    }
    MainWindow::on_txInput_textChanged();
}

QString getMeChunk(QString wholeText, int chunkNo, int chunkSize, int &index)
{
    //ASSUME text is ready for processing.
    chunkNo = chunkNo-1;
    int wordPos = chunkNo*chunkSize;
    QString result="";
    QStringList words=wholeText.split(QRegExp("(\\s|\\n|\\r)+"));
                //                      , QString::SkipEmptyParts);
    int WCount = words.count();
    index=0;
    for (int i=0;i<wordPos;i++)
    {
        index=index+words[i].length()+1;
    }
    for (int i=0;i<chunkSize;i++)
    {
        result+=" ";
        result += words[wordPos];
        wordPos++;
        if (wordPos==WCount)
            break;
    }
    return (result.simplified());
}

void MainWindow::on_btnStart_clicked()
{
    //Pepare text for running
    if (!timer->isActive())
    {
    if (!textWasChecked)
    {
        ui->txInput->setPlainText(prepareForProcessing(ui->txInput->toPlainText()));
        textWasChecked=true;
    }

    if (ui->hsSlider->value()==ui->hsSlider->maximum()) ui->hsSlider->setValue(1);
    timer->setInterval(((double)60/ui->sbWPM->value())*1000);
    timer->start();
    ui->btnStart->setText("||");
    ui->btnBackColor->setEnabled(0);
    ui->btnBold->setEnabled(0);
    ui->btnItalic->setEnabled(0);
    ui->btnForeColor->setEnabled(0);
    ui->btnLoadText->setEnabled(0);
    ui->btnUnderline->setEnabled(0);
    ui->fontComboBox->setEnabled(0);
    ui->sbChunkSize->setEnabled(0);
    ui->sbWPM->setEnabled(0);
    ui->txInput->setReadOnly(1);
    ui->sbFontSize->setEnabled(0);
    }
    else
    {
            timer->stop();
            ui->btnStart->setText("|>");

            ui->btnBackColor->setEnabled(1);
            ui->btnBold->setEnabled(1);
            ui->btnItalic->setEnabled(1);
            ui->btnForeColor->setEnabled(1);
            ui->btnLoadText->setEnabled(1);
            ui->btnUnderline->setEnabled(1);
            ui->fontComboBox->setEnabled(1);
            ui->sbChunkSize->setEnabled(1);
            ui->sbWPM->setEnabled(1);
            ui->txInput->setReadOnly(0);
            ui->sbFontSize->setEnabled(1);
    }

}

void MainWindow::on_btnRev_clicked()
{
    QTextCursor cu(ui->txInput->textCursor());
    cu.movePosition(QTextCursor::Start);
    ui->txInput->setTextCursor(cu);
    ui->hsSlider->setValue(1);
}

void MainWindow::on_hsSlider_valueChanged(int value)
{
    if (!textWasChecked)
    {
        ui->txInput->setPlainText(prepareForProcessing(ui->txInput->toPlainText()));
        textWasChecked=true;
    }
    timer->setInterval(((double)60/ui->sbWPM->value())*1000);
    int q;
    QString s=getMeChunk(ui->txInput->toPlainText(),value,ui->sbChunkSize->value(),q);
    ui->lbScreener->setText(s);
    QTextCursor c = ui->txInput->textCursor();
    c.setPosition(q);
    c.setPosition(q+s.length(),QTextCursor::KeepAnchor);
    ui->txInput->setTextCursor(c);

    //Advanced settings - add some time if longer chunk found
    if (ui->cbIfLonger->isChecked())
    {
        if (s.length()>ui->sbChunkDelLength->value())
        {
            if (ui->cbForEachChar->isChecked())
            {
                timer->setInterval(timer->interval()+( (ui->sbAddTime->value()) * (s.length()-ui->sbChunkDelLength->value()) ));
            }
            else
            {
                timer->setInterval(timer->interval()+( ui->sbAddTime->value() ));
            }
        }
    }
}

void MainWindow::proceedBurst()
{
    if (ui->hsSlider->value()<ui->hsSlider->maximum())
    {
        ui->hsSlider->setValue(ui->hsSlider->value()+1);
    } else
    {
        timer->stop();
        ui->btnStart->setText("|>");
        ui->btnBackColor->setEnabled(1);
        ui->btnBold->setEnabled(1);
        ui->btnItalic->setEnabled(1);
        ui->btnForeColor->setEnabled(1);
        ui->btnLoadText->setEnabled(1);
        ui->btnUnderline->setEnabled(1);
        ui->fontComboBox->setEnabled(1);
        ui->sbChunkSize->setEnabled(1);
        ui->sbWPM->setEnabled(1);
        ui->txInput->setReadOnly(0);
        ui->sbFontSize->setEnabled(1);
    }
}

void MainWindow::on_sbFontSize_valueChanged(int arg1)
{
        QFont f(ui->lbScreener->font());
        f.setPointSize(arg1);
        ui->lbScreener->setFont(f);
}

void MainWindow::SaveSettings()
{
    QString iniPath = "srrc.ini";
    #ifndef Q_OS_WIN32
    iniPath = QDir::homePath()+"/.srrc.ini";
    #endif

    QSettings setting(iniPath,QSettings::IniFormat);

    setting.beginGroup("MainSettings");
    setting.setValue("position",this->geometry());
    setting.setValue("splitHeight",ui->txInput->height());
    setting.setValue("chunkSize",ui->sbChunkSize->value());
    setting.setValue("wpm",ui->sbWPM->value());
    setting.endGroup();

    //colors
    setting.beginGroup("Colors");
    setting.setValue("background",gColA.rgba());
    setting.setValue("foreground",gColB.rgba());
    setting.endGroup();
    //font
    setting.beginGroup("font");
    setting.setValue("family",ui->lbScreener->font().family());
    setting.setValue("size",ui->sbFontSize->value());
    setting.setValue("bold",ui->lbScreener->font().bold());
    setting.setValue("italic",ui->lbScreener->font().italic());
    setting.setValue("underline",ui->lbScreener->font().underline());
    setting.endGroup();

    //advanced
    setting.beginGroup("Advanced");
    setting.setValue("AdditionalDelay",ui->cbIfLonger->isChecked());
    setting.setValue("DelayThreshold",ui->sbChunkDelLength->value());
    setting.setValue("DelayValue",ui->sbAddTime->value());
    setting.setValue("ForEachChar",ui->cbForEachChar->isChecked());

    setting.setValue("TextureUsed",ui->cbTexture->isChecked());
    setting.setValue("TexturePath",ui->leTexture->text());
    setting.setValue("TextureCenter",ui->cbTexCenter->isChecked());
    setting.setValue("TextureTile",ui->cbTexTile->isChecked());
    setting.endGroup();
}

void MainWindow::LoadSettings()
{
    QString iniPath = "srrc.ini";
    #ifndef Q_OS_WIN32
    iniPath = QDir::homePath()+"/.srrc.ini";
    #endif

    QSettings setting(iniPath,QSettings::IniFormat);

    setting.beginGroup("MainSettings");
    QRect winRect = setting.value("position",QRect(25,25,582,330)).toRect();
    QList<int> s=ui->splitter->sizes();
    s[1]=setting.value("splitHeight",70).toInt();
    ui->splitter->setSizes(s);

    ui->sbChunkSize->setValue(setting.value("chunkSize",1).toInt());
    ui->sbWPM->setValue(setting.value("wpm",300).toInt());
    setGeometry(winRect);
    setting.endGroup();

    setting.beginGroup("Colors");
    QPalette pal = ui->lbScreener->palette();
    QColor bc = setting.value("background",Qt::black).toUInt();
    QColor fc = setting.value("foreground",Qt::white).toUInt();
    gColA = QColor(bc);
    gColB = QColor(fc);
    setting.endGroup();
//    if ((gColA==gColB) && (gColA.rgba()==4278190080))
 //   {
  //      gColB.setRed(255); gColB.setGreen(255); gColB.setBlue(255);
   // }

    setting.beginGroup("font");
    QFont a(setting.value("family","Arial").toString(),setting.value("size",12).toInt(),setting.value("italic",0).toBool());
    a.setItalic(setting.value("italic",0).toBool());
    a.setBold(setting.value("bold",0).toBool());
    a.setUnderline(setting.value("underline",0).toBool());
    ui->sbFontSize->setValue(a.pointSize());
    ui->fontComboBox->setCurrentFont(a);
    ui->lbScreener->setFont(a);
    setting.endGroup();

    setting.beginGroup("Advanced");
    ui->cbIfLonger->setChecked(setting.value("AdditionalDelay",0).toBool());
    ui->sbChunkDelLength->setValue(setting.value("DelayThreshold",5).toInt());
    ui->sbAddTime->setValue(setting.value("DelayValue",50).toInt());
    ui->cbForEachChar->setChecked(setting.value("ForEachChar",1).toBool());

    //texture
    ui->cbTexture->setChecked(setting.value("TextureUsed",0).toBool());
    ui->leTexture->setText(setting.value("TexturePath","").toString());
    ui->cbTexCenter->setChecked(setting.value("TextureCenter",0).toBool());
    ui->cbTexTile->setChecked(setting.value("TextureTile",0).toBool());
    if (ui->cbTexture->isChecked())
    {
        this->on_cbTexture_clicked(1);
    } else this->on_cbTexture_clicked(0);
    setting.endGroup();
}

void MainWindow::on_splitter_splitterMoved(int pos, int index)
{
    QFont f=ui->lbScreener->font();
    f.setPixelSize(ui->lbScreener->height()*0.5);
    ui->lbScreener->setFont(f);
    QFontInfo* p=new QFontInfo(f);
    ui->sbFontSize->setValue(p->pointSize());
}

void MainWindow::on_btnOpenTex_clicked()
{
   QString fileName = QFileDialog::getOpenFileName(this,"Open Image", "", "Image Files (*.png *.bmp)");
   ui->leTexture->setText(fileName);
   if (ui->cbTexture->isChecked())
   {
      this->on_cbTexture_clicked(1);
   }
}

void MainWindow::on_cbTexture_clicked(bool checked)
{
    QString ss="";
   // QColor fc = ui->btnBackColor->palette().color(ui->btnBackColor->palette().NoRole);
    QColor fc=gColA;
    ss="background-color: rgb("+QString::number(fc.red())+","+QString::number(fc.green())+","+QString::number(fc.blue())+"); ";

    ss=ss+"color: rgb("+QString::number(gColB.red())+","+QString::number(gColB.green())+","+QString::number(gColB.blue())+"); ";

    if (checked)
    {
            ss=ss+"background-image: url("+ui->leTexture->text()+"); ";
    if (ui->cbTexTile->isChecked())
    {
        ss=ss+"background-repeat: repeat-xy; ";
    }
    else
    {
        ss=ss+"background-repeat: none; ";
    }
    if (ui->cbTexCenter->isChecked())
    {
        ss=ss+"background-position: center; ";
    }
    else
    {
        ss=ss+"";
    }
 }
    ui->lbScreener->setStyleSheet(ss);
  //  ui->txInput->setPlainText(ss);
}

void MainWindow::on_cbTexCenter_clicked()
{
    if (ui->cbTexture->isChecked())
    {
       this->on_cbTexture_clicked(1);
    }
}

void MainWindow::on_cbTexTile_clicked()
{
    if (ui->cbTexture->isChecked())
    {
       this->on_cbTexture_clicked(1);
    }
}

void MainWindow::on_btnClearClick()
{
    //crude to check is reading now.
    if (ui->btnLoadText->isEnabled())
    {
        ui->txInput->clear();
        textWasChecked=false;
    }
}
