#ifndef MODELSELECTOR_H
#define MODELSELECTOR_H

#include <QDialog>
#include <QModelIndex>
#include <QFileSystemModel>
#include <QString>
#include <QListView>
#include <QMessageBox>
#include <QDir>
#include <QTextStream>
#include <QPushButton>
#include "../testsheet.h"
#include "icvisualizer.h"

namespace Ui {
class ModelSelector;
}

class ModelSelector : public QDialog
{
    Q_OBJECT

public:
    explicit ModelSelector(QWidget *parent = 0, QString initPath="",QString settingsPath="");
    ~ModelSelector();
    QString getFileName();

private slots:
    void on_dirView_clicked(const QModelIndex &index);

    void on_edFilter_textChanged();

    void on_buttonBox_clicked(QAbstractButton *button);

//    void on_twFiles_clicked();

    void on_dirView_expanded(const QModelIndex &index);

    void on_twFiles_doubleClicked();

    void on_twFiles_itemSelectionChanged();

private:
    Ui::ModelSelector *ui;
    QFileSystemModel *dirmodel;
 //   QFileSystemModel *filemodel;
    QString iniPath;
    QListView *fileview;
    QString fileName;
    QString directory;
    ICVisualizer *previewVisualizer;
    void saveIni();
};

#endif // MODELSELECTOR_H
