//MCbx 2014, GPL
#include "configwindow.h"
#include "ui_configwindow.h"
#include <QtSerialPort/QSerialPortInfo>
#include <QColor>
#include <QColorDialog>
#include <QPalette>
#include <../powertable.h>
#include <QMessageBox>

ConfigWindow::ConfigWindow(QString cfgFileName, QString powerFileName, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::ConfigWindow)
{
    ui->setupUi(this);
    ConfigWindow::setWindowTitle("Configuration");

    //get list ov available serial ports
    QSerialPortInfo port;
    for (int i=0;i<port.availablePorts().count();i++)
    {
        ui->cbSerialPort->addItem(port.availablePorts()[i].portName());
    }

    //fill baud rates
    ui->cbBaudRate->addItem("600");
    ui->cbBaudRate->addItem("1200");
    ui->cbBaudRate->addItem("2400");
    ui->cbBaudRate->addItem("4800");
    ui->cbBaudRate->addItem("9600");
    ui->cbBaudRate->addItem("19200");
    ui->cbBaudRate->addItem("38400");
    ui->cbBaudRate->addItem("19200");
    ui->cbBaudRate->addItem("38400");
    ui->cbBaudRate->addItem("57600");

    //load settings
    this->cfgFileName=cfgFileName;
    QSettings settings(this->cfgFileName,QSettings::IniFormat);
    settings.beginGroup("Device");
    QString readSet=settings.value("Port","COM1").toString();
    #ifndef Q_OS_WIN32
    readSet=settings.value("Port","/dev/ttyS0").toString();
    #endif

    if (ui->cbSerialPort->findText(readSet)>-1)
    {
        ui->cbSerialPort->setCurrentIndex(ui->cbSerialPort->findText(readSet));
    }
    else
    {
        ui->cbSerialPort->addItem(readSet);
        ui->cbSerialPort->setCurrentIndex(ui->cbSerialPort->count()-1);
    }

   readSet=settings.value("Rate","19200").toString();
   if (ui->cbBaudRate->findText(readSet)>-1)
   {
       ui->cbBaudRate->setCurrentIndex(ui->cbBaudRate->findText(readSet));
   }
   else
   {
       ui->cbBaudRate->addItem(readSet);
       ui->cbBaudRate->setCurrentIndex(ui->cbBaudRate->count()-1);
   }


    int intRead=settings.value("TimeOut","1000").toInt();
    ui->sbTimeout->setValue(intRead);
    settings.endGroup();

    settings.beginGroup("Test");
    intRead=settings.value("StepDelay","2").toInt();
    ui->sbStepDelay->setValue(intRead);
    settings.endGroup();

    //change background function deprecated to make programmers use style sheets.
    //Style sheets don't work. Bug unfixed since 2012.
    //This temporary hack will be fixed if Qt team will fix stylesheets for such widgets
    //See you in A.D. 2096 :)
    QPalette pal=palette();

    settings.beginGroup("ICColors");
    int r,g,b;
    r=settings.value("BkgR","230").toInt();
    g=settings.value("BkgG","230").toInt();
    b=settings.value("BkgB","230").toInt();
    pal.setBrush(QPalette::Button,QColor::fromRgb(r,g,b));
    ui->btnBkgr->setPalette(pal);

    r=settings.value("HiR","255").toInt();
    g=settings.value("HiG","65").toInt();
    b=settings.value("HiB","65").toInt();
    pal.setBrush(QPalette::Button,QColor::fromRgb(r,g,b));
    ui->btnHi->setPalette(pal);

    r=settings.value("LowR","0").toInt();
    g=settings.value("LowG","240").toInt();
    b=settings.value("LowB","0").toInt();
    pal.setBrush(QPalette::Button,QColor::fromRgb(r,g,b));
    ui->btnLo->setPalette(pal);

    r=settings.value("NoR","200").toInt();
    g=settings.value("NoG","200").toInt();
    b=settings.value("NoB","200").toInt();
    pal.setBrush(QPalette::Button,QColor::fromRgb(r,g,b));
    ui->btnNC->setPalette(pal);

    r=settings.value("DrawR","0").toInt();
    g=settings.value("DrawG","0").toInt();
    b=settings.value("DrawB","0").toInt();
    pal.setBrush(QPalette::Button,QColor::fromRgb(r,g,b));
    ui->btnDraw->setPalette(pal);

    settings.endGroup();


    //prepare power table
    QString powerFile=powerFileName;
    pLUT = new PowerTable(powerFile);

    ui->sbSwitchesCount->setValue(pLUT->getCount());

    ui->twPower->setColumnCount(2);
    QStringList labels;
    labels<<"Function"<<"Pin";
    ui->twPower->setHorizontalHeaderLabels(labels);

    this->repaintPower(pLUT);
}

int ConfigWindow::PowerRoleToCode(QString role)
{
    if (role=="Vcc") return 1;
    if (role=="GND") return 0;
    return 2;
}

QString ConfigWindow::PowerCodeToRole(int code)
{
    if (code==0) return "GND";
    if (code==1) return "Vcc";
    return "NC";
}

ConfigWindow::~ConfigWindow()
{
    delete ui;
}

void ConfigWindow::on_btnBkgr_clicked()
{
    QColorDialog qc(ui->btnBkgr->palette().button().color());
    if (qc.exec())
    {
            QPalette pal=palette();
            pal.setBrush(QPalette::Button,qc.selectedColor());
            ui->btnBkgr->setPalette(pal);
    }
}

void ConfigWindow::on_btnDraw_clicked()
{
    QColorDialog qc(ui->btnDraw->palette().button().color());
    if (qc.exec())
    {
            QPalette pal=palette();
            pal.setBrush(QPalette::Button,qc.selectedColor());
            ui->btnDraw->setPalette(pal);
    }
}

void ConfigWindow::on_btnHi_clicked()
{
    QColorDialog qc(ui->btnHi->palette().button().color());
    if (qc.exec())
    {
            QPalette pal=palette();
            pal.setBrush(QPalette::Button,qc.selectedColor());
            ui->btnHi->setPalette(pal);
    }
}

void ConfigWindow::on_btnLo_clicked()
{
    QColorDialog qc(ui->btnLo->palette().button().color());
    if (qc.exec())
    {
            QPalette pal=palette();
            pal.setBrush(QPalette::Button,qc.selectedColor());
            ui->btnLo->setPalette(pal);
    }
}

void ConfigWindow::on_btnNC_clicked()
{
    QColorDialog qc(ui->btnNC->palette().button().color());
    if (qc.exec())
    {
            QPalette pal=palette();
            pal.setBrush(QPalette::Button,qc.selectedColor());
            ui->btnNC->setPalette(pal);
    }
}

void ConfigWindow::on_twPower_cellDoubleClicked(int row, int column)
{
    if (column==0)
    {
        PowerTable::powerEntry ent;
        ent.number=row+1;
        QSpinBox * pinSpinner = qobject_cast<QSpinBox*>(ui->twPower->cellWidget(row,1));
        ent.pin=pinSpinner->value();
        ent.type=(PowerRoleToCode(ui->twPower->item(row,column)->text())+1)%3;

        pLUT->setEntry(ent,row);
        //this->repaintPower(this->pLUT);
        ui->twPower->item(row,column)->setText(PowerCodeToRole(ent.type));
    }
}

void ConfigWindow::repaintPower(PowerTable *pLUT)
{
    QSignalMapper * spinMapper = new QSignalMapper(this);
    ui->sbSwitchesCount->setValue(pLUT->getCount());
    ui->twPower->setUpdatesEnabled(0);
    while(ui->twPower->rowCount()>0)
    ui->twPower->removeRow(0);

    for (int i=0;i<pLUT->getCount();i++)
    {
            ui->twPower->insertRow(ui->twPower->rowCount());
            QTableWidgetItem * junk= new QTableWidgetItem(PowerCodeToRole(pLUT->getEntryFunc(i)));
            junk->setFlags(junk->flags() & ~Qt::ItemIsEditable);
            ui->twPower->setItem(i,0,junk);

            QSpinBox * pinCounter= new QSpinBox(NULL);
            pinCounter->setMinimum(1);
            pinCounter->setMaximum(24);

            QObject::connect(pinCounter,SIGNAL(valueChanged(int)),spinMapper,SLOT(map()));
            spinMapper->setMapping(pinCounter,i);

            pinCounter->setValue(pLUT->getEntryPin(i));
            ui->twPower->setCellWidget(i,1,pinCounter);
    }
    QObject::connect(spinMapper,SIGNAL(mapped(int)),this,SLOT(on_pin_changed(int)));
    ui->twPower->resizeRowsToContents();

    ui->twPower->setUpdatesEnabled(1);
}

void ConfigWindow::on_pin_changed(int row)
{
    PowerTable::powerEntry ent;
    ent.number=row+1;
    QSpinBox * pinSpinner = qobject_cast<QSpinBox*>(ui->twPower->cellWidget(row,1));
    ent.pin=pinSpinner->value();
    ent.type=PowerRoleToCode(ui->twPower->item(row,0)->text());
    pLUT->setEntry(ent,row);
}

void ConfigWindow::on_buttonBox_accepted()
{
    //write configuration
    QSettings settings(this->cfgFileName,QSettings::IniFormat);
    settings.beginGroup("Device");
    settings.setValue("Port",ui->cbSerialPort->currentText());
    settings.setValue("Rate",ui->cbBaudRate->currentText());
    settings.setValue("TimeOut",QString::number(ui->sbTimeout->value()));
    settings.endGroup();

    settings.beginGroup("Test");
    settings.setValue("StepDelay",QString::number(ui->sbStepDelay->value()));
    settings.endGroup();

    settings.beginGroup("ICColors");
    settings.setValue("BkgR",QString::number(ui->btnBkgr->palette().button().color().red()));
    settings.setValue("BkgG",QString::number(ui->btnBkgr->palette().button().color().green()));
    settings.setValue("BkgB",QString::number(ui->btnBkgr->palette().button().color().blue()));
    settings.setValue("HiR",QString::number(ui->btnHi->palette().button().color().red()));
    settings.setValue("HiG",QString::number(ui->btnHi->palette().button().color().green()));
    settings.setValue("HiB",QString::number(ui->btnHi->palette().button().color().blue()));
    settings.setValue("LowR",QString::number(ui->btnLo->palette().button().color().red()));
    settings.setValue("LowG",QString::number(ui->btnLo->palette().button().color().green()));
    settings.setValue("LowB",QString::number(ui->btnLo->palette().button().color().blue()));
    settings.setValue("NoR",QString::number(ui->btnNC->palette().button().color().red()));
    settings.setValue("NoG",QString::number(ui->btnNC->palette().button().color().green()));
    settings.setValue("NoB",QString::number(ui->btnNC->palette().button().color().blue()));
    settings.setValue("DrawR",QString::number(ui->btnDraw->palette().button().color().red()));
    settings.setValue("DrawG",QString::number(ui->btnDraw->palette().button().color().green()));
    settings.setValue("DrawB",QString::number(ui->btnDraw->palette().button().color().blue()));
    settings.endGroup();

    //save power config
    this->pLUT->saveTable();

}

void ConfigWindow::on_sbSwitchesCount_valueChanged(int arg1)
{
    this->pLUT->resize(arg1);
    this->repaintPower(this->pLUT);
}

void ConfigWindow::on_btnDefaultPower_clicked()
{
    this->pLUT->revertToDefault();
    this->repaintPower(this->pLUT);
}
