#ifndef ICVISUALIZER_H
#define ICVISUALIZER_H

#include <QGraphicsView>
#include <QGraphicsScene>
#include <QGraphicsItem>
#include <QString>
#include <QStringList>

class ICVisualizer
{
public:
    ICVisualizer(QObject* parent, QGraphicsView *canvas, int numOfPins, QString modelName="");

    void setIO(QString IO);
    int getNumOfPins() const;
    void setNumOfPins(int value);
    void setPinDescriptions(QStringList pinsDescr);

    void setPins(QString pinStatus);
    void setBkgColor(QColor color);
    void setHiColor(QColor color);
    void setLoColor(QColor color);
    void setDrwColor(QColor color);
    void setNoColor(QColor color);
    QString getModelName() const;
    void setModelName(const QString &value);

    void setErrorMap(QString errors);
    void clearErrorMap();
    //position: 0-left, 1-centre, 2-right, 3 - vertical
    void setSummary(QString summary,int position=1);
private:
    QGraphicsScene * scene;
    QGraphicsView* canvas;
    int numOfPins;
    QStringList pinsDescription;
    QString pinsIO;
    QString pinsStatus;
    void paintModel();
    QString ModelName;
    QColor BkgColor;
    QColor HiColor;
    QColor LoColor;
    QColor NoColor;
    QColor DrwColor;
    QString ErrorMap;
    QString Summary;
    int summaryPosition;
};

#endif // ICVISUALIZER_H
