/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.registry;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.Target;

public class RegistryImpl
extends RemoteServer
implements Registry {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private Hashtable bindings = new Hashtable(101);
    private static Hashtable allowedAccessCache = new Hashtable(3);
    private static RegistryImpl registry;
    private static ObjID id;

    public RegistryImpl() throws RemoteException {
        this.setup(new LiveRef());
    }

    public RegistryImpl(int n) throws RemoteException {
        LiveRef liveRef = new LiveRef(id, n);
        this.setup(liveRef);
    }

    private void setup(LiveRef liveRef) throws RemoteException {
        UnicastServerRef unicastServerRef = new UnicastServerRef(liveRef);
        this.ref = unicastServerRef;
        unicastServerRef.exportObject(this, null);
        Target target = ObjectTable.getTarget(this);
        target.setPermanent(true);
    }

    public Remote lookup(String string) throws RemoteException, NotBoundException {
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            Remote remote = (Remote)this.bindings.get(string);
            if (remote == null) {
                throw new NotBoundException(string);
            }
            Remote remote2 = remote;
            Object var4_5 = null;
            return remote2;
        }
    }

    public void bind(String string, Remote remote) throws RemoteException, AlreadyBoundException, AccessException {
        RegistryImpl.checkAccess("bind");
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            Remote remote2 = (Remote)this.bindings.get(string);
            if (remote2 != null) {
                throw new AlreadyBoundException(string);
            }
            this.bindings.put(string, remote);
            return;
        }
    }

    public void unbind(String string) throws RemoteException, NotBoundException, AccessException {
        RegistryImpl.checkAccess("unbind");
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            Remote remote = (Remote)this.bindings.get(string);
            if (remote == null) {
                throw new NotBoundException(string);
            }
            this.bindings.remove(string);
            return;
        }
    }

    public void rebind(String string, Remote remote) throws RemoteException, AccessException {
        RegistryImpl.checkAccess("rebind");
        this.bindings.put(string, remote);
    }

    public String[] list() throws RemoteException {
        String[] stringArray;
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            int n = this.bindings.size();
            stringArray = new String[n];
            Enumeration enumeration = this.bindings.keys();
            while (--n >= 0) {
                stringArray[n] = (String)enumeration.nextElement();
            }
        }
        return stringArray;
    }

    public static void checkAccess(String string) throws AccessException {
        try {
            InetAddress inetAddress = InetAddress.getByName(RemoteServer.getClientHost());
            if (allowedAccessCache.get(inetAddress) == null) {
                try {
                    new ServerSocket(0, 10, inetAddress).close();
                    allowedAccessCache.put(inetAddress, inetAddress);
                    return;
                }
                catch (IOException iOException) {
                    throw new AccessException("Registry." + string + " " + inetAddress + " is not a local address");
                }
            }
        }
        catch (ServerNotActiveException serverNotActiveException) {
            return;
        }
        catch (UnknownHostException unknownHostException) {
            throw new AccessException("Registry." + string + ": unknown host: " + unknownHostException);
        }
    }

    public static ObjID getID() {
        return id;
    }

    public static void main(String[] stringArray) {
        System.setSecurityManager(new RMISecurityManager());
        try {
            int n = 1099;
            if (stringArray.length >= 1) {
                n = Integer.parseInt(stringArray[0]);
            }
            registry = new RegistryImpl(n);
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(0x7FFFFFFEL);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Port is not a number.");
        }
        catch (Exception exception) {
            System.out.println("RegistryImpl.main: an exception occurred: " + exception.getMessage());
            exception.printStackTrace();
        }
        System.exit(1);
    }

    static {
        id = new ObjID(0);
    }
}

