/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* format an OS/2 2.1 The Global InfoSeg directly from the SAS or    */
/* explicitely a supplied linear or selector:offset address.         */
/*                                                                   */
/* Change Log:                                                       */
/* 15/09/93 Version 1 created.                                       */
/* 10/09/96 Version 1.2 updated for Merlin new PMDF                  */
/*                                                                   */

signal on halt name haltexit
trace 'o'
numeric digits 12

arg iseg t
if t='' then t='o'
trace(t)
if iseg='' then do
   segoff=getstor("#70:14","W")
   iseg=getstor("#70:"segoff,"W")
   iseg="#"iseg":0"
end  /* Do */
say ' '
say 'Formatting Global InfoSeg at' iseg
say ' '
say "Time section"
call format  SIS_BigTime,"+00",iseg,  "D",    "Time from 1-1-1970 in seconds"
call format  SIS_MsCount,"+04",iseg,  "D",    "Freerunning milliseconds counter"
call format  SIS_HrsTime,"+08",iseg,  "B",    "Hours"
call format  SIS_MinTime,"+09",iseg,  "B",    "Minutes"
call format  SIS_SecTime,"+0a",iseg,  "B",    "Seconds"
call format  SIS_HunTime,"+0b",iseg,  "B",    "Hundredths of seconds"
call format  SIS_TimeZone,"+0c",iseg, "W",   "Timezone in min from GMT (Set to EST)"
call format  SIS_ClkIntrvl,"+0e",iseg,"W",   "Timer interval (units=0.0001 secs)"
say ' '
say "Date section"
call format   SIS_DayDate,"+10",iseg,"B",     "Day-of-month (1-31)"
call format   SIS_MonDate,"+11",iseg,"B",     "Month (1-12)"
call format   SIS_YrsDate,"+12",iseg,"W",    "Year (>= 1980)"
call format   SIS_DOWDate,"+14",iseg,"B",     "Day-of-week (e.g 1-1-80 = Tues = 2)"
say ' '
say "Version section"
call format    SIS_VerMajor,"+15",iseg,"B",   "Major version number"
call format    SIS_VerMinor,"+16",iseg,"B",   "Minor version number"
call format    SIS_RevLettr,"+17",iseg,"B",   "Revision letter"
say ' '
say "System Status"
call format   SIS_CurScrnGrp,"+18",iseg,"B",  "Fgnd screen group #"
call format   SIS_MaxScrnGrp,"+19",iseg,"B",  "Maximum number of screen groups"
call format   SIS_HugeShfCnt,"+1a",iseg,"B",  "Shift count for huge segments"
call format   SIS_ProtMdOnly,"+1b",iseg,"B",  "Protect-mode-only indicator"
call format   SIS_FgndPID,"+1c",iseg,   "W", "Foreground process ID"
say ' '
say "Scheduler Parms"
call format   SIS_Dynamic,"+1e",iseg, "B",    "Dynamic variation flag (1=enabled)"
call format   SIS_MaxWait,"+1f",iseg, "B",    "Maxwait (seconds)"
call format   SIS_MinSlice,"+20",iseg,"W",   "Minimum timeslice (milliseconds)"
call format   SIS_MaxSlice,"+22",iseg,"W",   "Maximum timeslice (milliseconds)"
say ' '
call format   SIS_BootDrv,"+24",iseg,"W",    "Drive from which system was booted"
say ' '
say "+26 SIS_mec_table, Table of RAS Major Event Codes (MECs)"
SIS_mec_table=getbytes(iseg"+26",32)
say SIS_mec_table
say ' '
say "Additional Session Data"
call format    SIS_MaxVioWinSG,"+46",iseg, "B", "Max. no. of VIO windowable SG's"
call format    SIS_MaxPresMgrSG,"+47",iseg,"B", "Max. no. of Presentation Manager SG's"
say ' '
say 'Error Logging information'
call format    SIS_SysLog,"+48",iseg,"W","Error Logging Status"
value=x2c(result)
if bitand(value,'0001'x)='0001'x then say "    Error Logging Enabled"
else say "    Error Logging Disabled"
if bitand(value,'0002'x)='0002'x then say "    Error Logging available"
else say "    Error Logging not available"
say ' '
say "Additional RAS Information"
call format   SIS_MMIOBase,"+4a",iseg,"W","Memory mapped I/O selector"
call format   SIS_MMIOAddr,"+4c",iseg,"D","Memory mapped I/O address"
say ' '
say "Additional 2.0 Data"
call format    SIS_MaxVDMs,"+50",iseg,"B","Max. no. of Virtual DOS machines"
call format    SIS_Reserved,"+51",iseg,"B"," "
say " "

haltexit: say'#'

exit 0

format: procedure
parse arg name,offset,base,type,desc,linesz .
value=getstor(base||offset,type)
desc=strip(desc,"B"," ")
name=strip(name,"B"," ")
if desc='' then text=offset name":"
else text=offset name"," desc":"
tl=length(text)
vl=length(value)
if linesz='' then linesz=70
pad=linesz-tl-vl
if pad>0 then text=left(text,pad+tl," ")
say text value
return value

getstor: procedure
arg address,size,format
select
   when size='B' then cmd="DB" address "L1"
   when size='W' then cmd="DW" address "L1"
   when size="D" then cmd="DD" address "L1"
otherwise cmd="DB" address "L1"
end  /* select */
address df "cmd output" cmd
o=output.0-1
if rc<>0 then return 'df error' rc
else do
    parse var output.o . stor .
    select
       when format="C" then return x2c(stor)
       when format="N" then return x2d(stor)
       when format="X" then return stor
    otherwise return stor
    end  /* select */
end


getbytes: procedure
arg address,length
address df "cmd output DB" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DB "address"+"i"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor
