/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Format VDM arean records */
/* 9/5/97 fixed possible acidental exponential comparison */

signal on halt name haltexit

arg maddr .

if maddr='?' then do
   call helpmsg
   exit 0
end /* do */

maddr=strip(maddr,'l','&')
if maddr='' then maddr='cs:ip'
address df 'cmd output ? &'maddr
o=output.0-1
dmaddr=x2d(substr(word(output.o,2),2))

if IsVdm('Current Process is not a VDM') then exit 0

address df 'cmd output ln arena_head'
o=output.0-1
if left(output.o,1)='&' then do
   address df 'cmd output dw arena_head l2'
   o=output.0-1
   arena=word(output.o,2)
   address df 'cmd output dw UMB_HEAD L1'
   o=output.0-1
   umb=word(output.o,2)
end /* do */
else do
   v86seg=getwords('_Segv86kernel',1)
   if datatype(v86seg,'x') then do
      say 'Unable to locate DOSKRNL - please load kernel symbols'
      exit 0
   end /* do */
   v86seg='&'v86seg':0000'
   say ''
   say 'Warning: DOSKRNL symbols not loaded'
   say 'Assuming ARENA_HEAD at V86GROUP:24'
   say 'Assuming UMB_HEAD   at V86GROUP:8c'
   say ''
   address df 'cmd output dw' v86seg'+24 l2'
   o=output.0-1
   arena=word(output.o,2)
   address df 'cmd output dw' v86seg'+8c l1'
   o=output.0-1
   umb=x2d(word(output.o,2))
end /* do */

quit=0=1

do until quit
   address df 'cmd output db &'arena':0 l10'
   o=output.0-1
   parse var output.o . b0 b1 b2 b3 b4 . . . . . . . . . . text .
   sig=b0
   own=b2||b1
   size=b4||b3
   name=substr(text,9,8)
   ard=x2d(arena)
   nextar=lower(right(d2x(ard+x2d(size)+1),4,'0'))
   start=ard*16
   if sig='5a' then quit=0=0
   else if sig<>'4d' then quit=0=0
   end=x2d(nextar)*16
   if dmaddr<start then quit=0=0
   if dmaddr>=start & dmaddr<end then do
      if '#'own='#0000' then flag='free'
      else if '#'own='#0008' then flag='System Owned'
      else flag='Process Owned'
      if sig='5a' then flag=flag', last block'
      else if sig<>'4d' then flag=flag', invalid block'
      if ard>=umb then flag=flag', UMB'
      say 'seg  size own  name'
      say arena size own name flag
      quit=0=0
   end /* do */
   arena=nextar
end /* do */



haltexit: exit 0


helpmsg: procedure

say "Locate the owner of a VDM Segment Allocation"
say " "
say "Syntax: %VM <segment:offset>"
say ""
say "Where:"
say ""
say "           <segment:offset> specifies the address whose owner"
say "           is to be located. If omited then &cs:ip is assumed."


return

getwords: procedure
arg address,length
address df "cmd output DW" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DW "address"+"i*2"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor

lower: procedure expose nothing
parse arg str
return translate(str,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')

IsVDM: procedure
parse arg msgtxt

address df 'cmd output .p#'
o=output.0-1
if pos('*vdm',output.o)>0 then return 0=0
if msgtxt<>'' then say msgtxt
return 0=1
