/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.record.terminal;

import com.ibm.ivj.eab.record.terminal.IPaddedTerminalType;
import com.ibm.ivj.eab.record.terminal.ITerminalFieldType;
import com.ibm.ivj.eab.record.terminal.TerminalRecordConverterManager;
import com.ibm.record.AnyType;
import com.ibm.record.FixedLengthType;
import com.ibm.record.IRecord;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;

public class FixedLengthTerminalFieldType
extends FixedLengthType
implements ITerminalFieldType,
IPaddedTerminalType {
    static final String copyright = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 2.0\n(C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Class preferredType;
    private boolean doubleByteEncoded;
    private String trueString;
    private String falseString;
    private int mantissaLength;
    private int size;
    private int paddingPolicy;
    private byte paddingByte;
    static Class class$java$lang$Long;
    static Class class$java$lang$Short;
    static Class class$java$lang$Integer;
    static Class class$java$lang$Character;
    static Class class$java$lang$String;
    static Class class$java$lang$Byte;
    static Class class$java$lang$Boolean;
    static Class class$java$lang$Double;
    static Class class$java$lang$Float;

    public FixedLengthTerminalFieldType() {
        this(1, false, 1, 32);
    }

    public FixedLengthTerminalFieldType(int size, boolean doubleByteEncoded, int paddingPolicy, byte paddingByte) {
        Class<?> clazz = class$java$lang$String;
        if (clazz == null) {
            try {
                clazz = class$java$lang$String = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this(clazz, doubleByteEncoded, "", "", 2, size, paddingPolicy, paddingByte);
    }

    public FixedLengthTerminalFieldType(Class preferredType, boolean doubleByteEncoded, String trueString, String falseString, int mantissaLength, int size, int paddingPolicy, byte paddingByte) {
        this.preferredType = preferredType;
        this.doubleByteEncoded = doubleByteEncoded;
        this.trueString = trueString;
        this.falseString = falseString;
        this.mantissaLength = mantissaLength;
        this.size = size;
        this.paddingByte = paddingByte;
        this.paddingPolicy = paddingPolicy;
    }

    public boolean canConvertFromBoolean() {
        return true;
    }

    public boolean canConvertFromByte() {
        return true;
    }

    public boolean canConvertFromChar() {
        return true;
    }

    public boolean canConvertFromDouble() {
        return true;
    }

    public boolean canConvertFromFloat() {
        return true;
    }

    public boolean canConvertFromInt() {
        return true;
    }

    public boolean canConvertFromLong() {
        return true;
    }

    public boolean canConvertFromObject() {
        return true;
    }

    public boolean canConvertFromShort() {
        return true;
    }

    public boolean canConvertFromString() {
        return true;
    }

    public boolean canConvertToBoolean() {
        return true;
    }

    public boolean canConvertToByte() {
        return true;
    }

    public boolean canConvertToChar() {
        return true;
    }

    public boolean canConvertToDouble() {
        return true;
    }

    public boolean canConvertToFloat() {
        return true;
    }

    public boolean canConvertToInt() {
        return true;
    }

    public boolean canConvertToLong() {
        return true;
    }

    public boolean canConvertToObject() {
        return true;
    }

    public boolean canConvertToShort() {
        return true;
    }

    public boolean canConvertToString() {
        return true;
    }

    public boolean checkConstantValue(IRecord record, int offset, Object constantValue) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        return FixedLengthTerminalFieldType.testConstantValue(record, offset, constantValue, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded(), this.getTrueString(), this.getFalseString(), this.getMantissaLength());
    }

    public static void fromBoolean(IRecord record, int offset, boolean value, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded, String trueString, String falseString) throws RecordConversionFailureException {
        String stringValue = TerminalRecordConverterManager.convertBooleanToString(value, trueString, falseString);
        FixedLengthTerminalFieldType.fromString(record, offset, stringValue, length, paddingPolicy, paddingByte, doubleByteEncoded);
    }

    public static void fromByte(IRecord record, int offset, byte value, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded) throws RecordConversionFailureException {
        String stringValue = TerminalRecordConverterManager.convertByteToString(value);
        FixedLengthTerminalFieldType.fromString(record, offset, stringValue, length, paddingPolicy, paddingByte, doubleByteEncoded);
    }

    public static void fromChar(IRecord record, int offset, char value, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded) throws RecordConversionFailureException {
        String stringValue = TerminalRecordConverterManager.convertCharToString(value);
        FixedLengthTerminalFieldType.fromString(record, offset, stringValue, length, paddingPolicy, paddingByte, doubleByteEncoded);
    }

    public static void fromDouble(IRecord record, int offset, double value, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded, int mantissaLength) throws RecordConversionFailureException {
        String stringValue = TerminalRecordConverterManager.convertDoubleToString(value, mantissaLength);
        FixedLengthTerminalFieldType.fromString(record, offset, stringValue, length, paddingPolicy, paddingByte, doubleByteEncoded);
    }

    public static void fromFloat(IRecord record, int offset, float value, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded, int mantissaLength) throws RecordConversionFailureException {
        String stringValue = TerminalRecordConverterManager.convertFloatToString(value, mantissaLength);
        FixedLengthTerminalFieldType.fromString(record, offset, stringValue, length, paddingPolicy, paddingByte, doubleByteEncoded);
    }

    public static void fromInitialValue(IRecord record, int offset, Object initialValue, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded, String trueString, String falseString, int mantissaLength) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        try {
            FixedLengthTerminalFieldType.fromObject(record, offset, initialValue, length, paddingPolicy, paddingByte, doubleByteEncoded, trueString, falseString, mantissaLength, initialValue.getClass());
        }
        catch (NullPointerException nullPointerException) {
            throw new RecordConversionUnsupportedException();
        }
    }

    public static void fromInt(IRecord record, int offset, int value, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded) throws RecordConversionFailureException {
        String stringValue = TerminalRecordConverterManager.convertIntToString(value);
        FixedLengthTerminalFieldType.fromString(record, offset, stringValue, length, paddingPolicy, paddingByte, doubleByteEncoded);
    }

    public static void fromLong(IRecord record, int offset, long value, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded) throws RecordConversionFailureException {
        String stringValue = TerminalRecordConverterManager.convertLongToString(value);
        FixedLengthTerminalFieldType.fromString(record, offset, stringValue, length, paddingPolicy, paddingByte, doubleByteEncoded);
    }

    public static void fromObject(IRecord record, int offset, Object value, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded, String trueString, String falseString, int mantissaLength, Class valueClass) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        if (value == null || value.getClass() != valueClass) {
            throw new RecordConversionUnsupportedException();
        }
        Class<?> clazz = class$java$lang$String;
        if (clazz == null) {
            try {
                clazz = class$java$lang$String = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz) {
            String stringValue = (String)value;
            FixedLengthTerminalFieldType.fromString(record, offset, stringValue, length, paddingPolicy, paddingByte, doubleByteEncoded);
        } else {
            Class<?> clazz2 = class$java$lang$Long;
            if (clazz2 == null) {
                try {
                    clazz2 = class$java$lang$Long = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (valueClass == clazz2) {
                long longValue = (Long)value;
                FixedLengthTerminalFieldType.fromLong(record, offset, longValue, length, paddingPolicy, paddingByte, doubleByteEncoded);
            } else {
                Class<?> clazz3 = class$java$lang$Integer;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$java$lang$Integer = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (valueClass == clazz3) {
                    int intValue = (Integer)value;
                    FixedLengthTerminalFieldType.fromInt(record, offset, intValue, length, paddingPolicy, paddingByte, doubleByteEncoded);
                } else {
                    Class<?> clazz4 = class$java$lang$Short;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$java$lang$Short = Class.forName("java.lang.Short");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (valueClass == clazz4) {
                        short shortValue = (Short)value;
                        FixedLengthTerminalFieldType.fromShort(record, offset, shortValue, length, paddingPolicy, paddingByte, doubleByteEncoded);
                    } else {
                        Class<?> clazz5 = class$java$lang$Byte;
                        if (clazz5 == null) {
                            try {
                                clazz5 = class$java$lang$Byte = Class.forName("java.lang.Byte");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (valueClass == clazz5) {
                            byte byteValue = (Byte)value;
                            FixedLengthTerminalFieldType.fromByte(record, offset, byteValue, length, paddingPolicy, paddingByte, doubleByteEncoded);
                        } else {
                            Class<?> clazz6 = class$java$lang$Character;
                            if (clazz6 == null) {
                                try {
                                    clazz6 = class$java$lang$Character = Class.forName("java.lang.Character");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (valueClass == clazz6) {
                                char charValue = ((Character)value).charValue();
                                FixedLengthTerminalFieldType.fromChar(record, offset, charValue, length, paddingPolicy, paddingByte, doubleByteEncoded);
                            } else {
                                Class<?> clazz7 = class$java$lang$Boolean;
                                if (clazz7 == null) {
                                    try {
                                        clazz7 = class$java$lang$Boolean = Class.forName("java.lang.Boolean");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (valueClass == clazz7) {
                                    boolean booleanValue = (Boolean)value;
                                    FixedLengthTerminalFieldType.fromBoolean(record, offset, booleanValue, length, paddingPolicy, paddingByte, doubleByteEncoded, trueString, falseString);
                                } else {
                                    Class<?> clazz8 = class$java$lang$Double;
                                    if (clazz8 == null) {
                                        try {
                                            clazz8 = class$java$lang$Double = Class.forName("java.lang.Double");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (valueClass == clazz8) {
                                        double doubleValue = (Double)value;
                                        FixedLengthTerminalFieldType.fromDouble(record, offset, doubleValue, length, paddingPolicy, paddingByte, doubleByteEncoded, mantissaLength);
                                    } else {
                                        Class<?> clazz9 = class$java$lang$Float;
                                        if (clazz9 == null) {
                                            try {
                                                clazz9 = class$java$lang$Float = Class.forName("java.lang.Float");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (valueClass == clazz9) {
                                            float floatValue = ((Float)value).floatValue();
                                            FixedLengthTerminalFieldType.fromFloat(record, offset, floatValue, length, paddingPolicy, paddingByte, doubleByteEncoded, mantissaLength);
                                        } else {
                                            throw new RecordConversionUnsupportedException();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static void fromShort(IRecord record, int offset, short value, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded) throws RecordConversionFailureException {
        String stringValue = TerminalRecordConverterManager.convertShortToString(value);
        FixedLengthTerminalFieldType.fromString(record, offset, stringValue, length, paddingPolicy, paddingByte, doubleByteEncoded);
    }

    public static void fromString(IRecord record, int offset, String value, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded) throws RecordConversionFailureException {
        if (value == null || record == null) {
            throw new RecordConversionFailureException();
        }
        byte[] valueBytes = TerminalRecordConverterManager.convertStringToByteArray(value, doubleByteEncoded);
        TerminalRecordConverterManager.injectByteArray(valueBytes, record.getRawBytes(), offset, length, paddingPolicy, paddingByte);
    }

    public int getAlignmentHint() {
        return 1;
    }

    public boolean getBoolean(IRecord record, int offset) throws RecordConversionFailureException {
        return FixedLengthTerminalFieldType.toBoolean(record, offset, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded(), this.getTrueString(), this.getFalseString());
    }

    public byte getByte(IRecord record, int offset) throws RecordConversionFailureException {
        return FixedLengthTerminalFieldType.toByte(record, offset, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded());
    }

    public char getChar(IRecord record, int offset) throws RecordConversionFailureException {
        return FixedLengthTerminalFieldType.toChar(record, offset, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded());
    }

    public double getDouble(IRecord record, int offset) throws RecordConversionFailureException {
        return FixedLengthTerminalFieldType.toDouble(record, offset, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded(), this.getMantissaLength());
    }

    public boolean getDoubleByteEncoded() {
        return this.doubleByteEncoded;
    }

    public String getFalseString() {
        return this.falseString;
    }

    public float getFloat(IRecord record, int offset) throws RecordConversionFailureException {
        return FixedLengthTerminalFieldType.toFloat(record, offset, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded(), this.getMantissaLength());
    }

    public int getInt(IRecord record, int offset) throws RecordConversionFailureException {
        return FixedLengthTerminalFieldType.toInt(record, offset, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded());
    }

    public long getLong(IRecord record, int offset) throws RecordConversionFailureException {
        return FixedLengthTerminalFieldType.toLong(record, offset, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded());
    }

    public int getMantissaLength() {
        return this.mantissaLength;
    }

    public Object getObject(IRecord record, int offset) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        return FixedLengthTerminalFieldType.toObject(record, offset, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded(), this.getTrueString(), this.getFalseString(), this.getMantissaLength(), this.getPreferredType());
    }

    public byte getPaddingByte() {
        return this.paddingByte;
    }

    public int getPaddingPolicy() {
        return this.paddingPolicy;
    }

    public Class getPreferredType() {
        return this.preferredType;
    }

    public short getShort(IRecord record, int offset) throws RecordConversionFailureException {
        return FixedLengthTerminalFieldType.toShort(record, offset, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded());
    }

    public int getSize() {
        return this.size;
    }

    public String getString(IRecord record, int offset) throws RecordConversionFailureException {
        return FixedLengthTerminalFieldType.toString(record, offset, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded());
    }

    public String getTrueString() {
        return this.trueString;
    }

    public void setBoolean(IRecord record, int offset, boolean value) throws RecordConversionFailureException {
        FixedLengthTerminalFieldType.fromBoolean(record, offset, value, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded(), this.getTrueString(), this.getFalseString());
    }

    public void setByte(IRecord record, int offset, byte value) throws RecordConversionFailureException {
        FixedLengthTerminalFieldType.fromByte(record, offset, value, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded());
    }

    public void setChar(IRecord record, int offset, char value) throws RecordConversionFailureException {
        FixedLengthTerminalFieldType.fromChar(record, offset, value, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded());
    }

    public void setDouble(IRecord record, int offset, double value) throws RecordConversionFailureException {
        FixedLengthTerminalFieldType.fromDouble(record, offset, value, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded(), this.getMantissaLength());
    }

    public void setDoubleByteEncoded(boolean doubleByteEncoded) {
        this.doubleByteEncoded = doubleByteEncoded;
    }

    public void setFalseString(String falseString) {
        this.falseString = falseString;
    }

    public void setFloat(IRecord record, int offset, float value) throws RecordConversionFailureException {
        FixedLengthTerminalFieldType.fromFloat(record, offset, value, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded(), this.getMantissaLength());
    }

    public void setInitialValue(IRecord record, int offset, Object initialValue) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        FixedLengthTerminalFieldType.fromInitialValue(record, offset, initialValue, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded(), this.getTrueString(), this.getFalseString(), this.getMantissaLength());
    }

    public void setInt(IRecord record, int offset, int value) throws RecordConversionFailureException {
        FixedLengthTerminalFieldType.fromInt(record, offset, value, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded());
    }

    public void setLong(IRecord record, int offset, long value) throws RecordConversionFailureException {
        FixedLengthTerminalFieldType.fromLong(record, offset, value, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded());
    }

    public void setMantissaLength(int mantissaLength) {
        this.mantissaLength = mantissaLength;
    }

    public void setObject(IRecord record, int offset, Object value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        FixedLengthTerminalFieldType.fromObject(record, offset, value, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded(), this.getTrueString(), this.getFalseString(), this.getMantissaLength(), this.getPreferredType());
    }

    public void setPaddingByte(byte paddingByte) {
        this.paddingByte = paddingByte;
    }

    public void setPaddingPolicy(int paddingPolicy) {
        this.paddingPolicy = paddingPolicy;
    }

    public void setPreferredType(Class preferredType) {
        Class oldValue = this.preferredType;
        this.preferredType = preferredType;
        if (((AnyType)this).changes_ != null) {
            ((AnyType)this).changes_.firePropertyChange("preferredType", oldValue, preferredType);
        }
    }

    public void setShort(IRecord record, int offset, short value) throws RecordConversionFailureException {
        FixedLengthTerminalFieldType.fromShort(record, offset, value, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded());
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setString(IRecord record, int offset, String value) throws RecordConversionFailureException {
        FixedLengthTerminalFieldType.fromString(record, offset, value, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte(), this.getDoubleByteEncoded());
    }

    public void setTrueString(String trueString) {
        this.trueString = trueString;
    }

    public static boolean testConstantValue(IRecord record, int offset, Object constantValue, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded, String trueString, String falseString, int mantissaLength) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        try {
            Object value2;
            Object value1 = FixedLengthTerminalFieldType.toObject(record, offset, length, paddingPolicy, paddingByte, doubleByteEncoded, trueString, falseString, mantissaLength, constantValue.getClass());
            if (constantValue instanceof String) {
                String stringValue = (String)constantValue;
                byte[] stringBytes = stringValue.getBytes();
                int[] pads = TerminalRecordConverterManager.numberOfPadsToBeRemoved(stringBytes, 0, stringBytes.length, paddingPolicy, paddingByte);
                byte[] tmpBytes = new byte[stringBytes.length - pads[1] - pads[0]];
                System.arraycopy(stringBytes, pads[0], tmpBytes, 0, tmpBytes.length);
                value2 = new String(tmpBytes);
            } else {
                value2 = constantValue;
            }
            return value1.getClass() == value2.getClass() && value1.equals(value2);
        }
        catch (Throwable throwable) {
            throw new RecordConversionFailureException();
        }
    }

    public static boolean toBoolean(IRecord record, int offset, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded, String trueString, String falseString) throws RecordConversionFailureException {
        String stringValue = FixedLengthTerminalFieldType.toString(record, offset, length, paddingPolicy, paddingByte, doubleByteEncoded);
        return TerminalRecordConverterManager.convertStringToBoolean(stringValue, trueString, falseString);
    }

    public static byte toByte(IRecord record, int offset, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded) throws RecordConversionFailureException {
        String stringValue = FixedLengthTerminalFieldType.toString(record, offset, length, paddingPolicy, paddingByte, doubleByteEncoded);
        return TerminalRecordConverterManager.convertStringToByte(stringValue);
    }

    public static char toChar(IRecord record, int offset, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded) throws RecordConversionFailureException {
        String stringValue = FixedLengthTerminalFieldType.toString(record, offset, length, paddingPolicy, paddingByte, doubleByteEncoded);
        return TerminalRecordConverterManager.convertStringToChar(stringValue);
    }

    public static double toDouble(IRecord record, int offset, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded, int mantissaLength) throws RecordConversionFailureException {
        String stringValue = FixedLengthTerminalFieldType.toString(record, offset, length, paddingPolicy, paddingByte, doubleByteEncoded);
        return TerminalRecordConverterManager.convertStringToDouble(stringValue, mantissaLength);
    }

    public static float toFloat(IRecord record, int offset, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded, int mantissaLength) throws RecordConversionFailureException {
        String stringValue = FixedLengthTerminalFieldType.toString(record, offset, length, paddingPolicy, paddingByte, doubleByteEncoded);
        return TerminalRecordConverterManager.convertStringToFloat(stringValue, mantissaLength);
    }

    public static int toInt(IRecord record, int offset, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded) throws RecordConversionFailureException {
        String stringValue = FixedLengthTerminalFieldType.toString(record, offset, length, paddingPolicy, paddingByte, doubleByteEncoded);
        return TerminalRecordConverterManager.convertStringToInt(stringValue);
    }

    public static long toLong(IRecord record, int offset, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded) throws RecordConversionFailureException {
        String stringValue = FixedLengthTerminalFieldType.toString(record, offset, length, paddingPolicy, paddingByte, doubleByteEncoded);
        return TerminalRecordConverterManager.convertStringToLong(stringValue);
    }

    public static Object toObject(IRecord record, int offset, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded, String trueString, String falseString, int mantissaLength, Class valueClass) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        Class<?> clazz = class$java$lang$String;
        if (clazz == null) {
            try {
                clazz = class$java$lang$String = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz) {
            String stringValue = FixedLengthTerminalFieldType.toString(record, offset, length, paddingPolicy, paddingByte, doubleByteEncoded);
            return stringValue;
        }
        Class<?> clazz2 = class$java$lang$Long;
        if (clazz2 == null) {
            try {
                clazz2 = class$java$lang$Long = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz2) {
            long longValue = FixedLengthTerminalFieldType.toLong(record, offset, length, paddingPolicy, paddingByte, doubleByteEncoded);
            return new Long(longValue);
        }
        Class<?> clazz3 = class$java$lang$Integer;
        if (clazz3 == null) {
            try {
                clazz3 = class$java$lang$Integer = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz3) {
            int intValue = FixedLengthTerminalFieldType.toInt(record, offset, length, paddingPolicy, paddingByte, doubleByteEncoded);
            return new Integer(intValue);
        }
        Class<?> clazz4 = class$java$lang$Short;
        if (clazz4 == null) {
            try {
                clazz4 = class$java$lang$Short = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz4) {
            short shortValue = FixedLengthTerminalFieldType.toShort(record, offset, length, paddingPolicy, paddingByte, doubleByteEncoded);
            return new Short(shortValue);
        }
        Class<?> clazz5 = class$java$lang$Byte;
        if (clazz5 == null) {
            try {
                clazz5 = class$java$lang$Byte = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz5) {
            byte byteValue = FixedLengthTerminalFieldType.toByte(record, offset, length, paddingPolicy, paddingByte, doubleByteEncoded);
            return new Byte(byteValue);
        }
        Class<?> clazz6 = class$java$lang$Character;
        if (clazz6 == null) {
            try {
                clazz6 = class$java$lang$Character = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz6) {
            char charValue = FixedLengthTerminalFieldType.toChar(record, offset, length, paddingPolicy, paddingByte, doubleByteEncoded);
            return new Character(charValue);
        }
        Class<?> clazz7 = class$java$lang$Boolean;
        if (clazz7 == null) {
            try {
                clazz7 = class$java$lang$Boolean = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz7) {
            boolean booleanValue = FixedLengthTerminalFieldType.toBoolean(record, offset, length, paddingPolicy, paddingByte, doubleByteEncoded, trueString, falseString);
            return new Boolean(booleanValue);
        }
        Class<?> clazz8 = class$java$lang$Double;
        if (clazz8 == null) {
            try {
                clazz8 = class$java$lang$Double = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz8) {
            double doubleValue = FixedLengthTerminalFieldType.toDouble(record, offset, length, paddingPolicy, paddingByte, doubleByteEncoded, mantissaLength);
            return new Double(doubleValue);
        }
        Class<?> clazz9 = class$java$lang$Float;
        if (clazz9 == null) {
            try {
                clazz9 = class$java$lang$Float = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz9) {
            float floatValue = FixedLengthTerminalFieldType.toFloat(record, offset, length, paddingPolicy, paddingByte, doubleByteEncoded, mantissaLength);
            return new Float(floatValue);
        }
        throw new RecordConversionUnsupportedException();
    }

    public static short toShort(IRecord record, int offset, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded) throws RecordConversionFailureException {
        String stringValue = FixedLengthTerminalFieldType.toString(record, offset, length, paddingPolicy, paddingByte, doubleByteEncoded);
        return TerminalRecordConverterManager.convertStringToShort(stringValue);
    }

    public static String toString(IRecord record, int offset, int length, int paddingPolicy, byte paddingByte, boolean doubleByteEncoded) throws RecordConversionFailureException {
        if (record == null) {
            throw new RecordConversionFailureException();
        }
        byte[] value = TerminalRecordConverterManager.extractByteArray(record.getRawBytes(), offset, length, paddingPolicy, paddingByte);
        return TerminalRecordConverterManager.convertByteArrayToString(value, doubleByteEncoded);
    }
}

