package com.ibm.abt.web.servlet;

/**
 * This interface contains the constants used by the
 * VastWsiRouterServlet.
 */
public interface WsiConstants {
	
	public static final int WSI_MAJOR_VERSION = 2;
	public static final int WSI_MINOR_VERSION = 0;
	// Magic cookie is represented in hexadecimal bytes
	public static final String[] WSI_MAGIC_COOKIE = {"04", "28", "19", "53"} ;
	public static final int WSI_REQUEST_TYPE_SERVICE = 1 ;
	public static final int WSI_DEFAULT_SOCKET_TIMEOUT = 5000 ;
	
	public static final String CONFIG_FILE_EXT = ".cnf" ;
	public static final String ERROR_FILE_EXT = ".htm" ;
	public static final String LOG_FILE_EXT = ".log" ;
	public static final String PROPERTY_FILE_EXT = ".pro" ;
	public static final String DEFAULT_NAME = "abtwsi" ;
	public static final String DEFAULT_CONTENT_TYPE = "text/html" ;
	public static final String ABTWSI_BASENAME = "ABTWSI_BASENAME" ;
	public static final String SOCKET_TIMEOUT = "SOCKET_TIMEOUT" ;

	public static final String MSG_STRING_LOG = "LOG" ;
	public static final String MSG_STRING_VERBOSE = "VERBOSE" ;
	public static final String MSG_STRING_LINK = "LINK" ;
	public static final String MSG_STRING_TRANSPORT = "TRANSPORT";
	public static final String MSG_STRING_CODEPAGE = "CODEPAGE";
	public static final String MSG_STRING_CONTENT_DATA = "XWSI_CONTENT_DATA";
	public static final String MSG_STRING_ERRORFILE = "ERRORFILE";
	public static final String MSG_STRING_DEBUG = "DEBUG";
	public static final String MSG_STRING_ON = "ON";
	public static final String MSG_STRING_OFF = "OFF";
	public static final String MSG_STRING_WILDCARD = "*" ;
	public static final char MSG_COMMENT_CHAR = '#' ;
	public static final String MSG_STRING_CONTENT_TYPE = "CONTENT_TYPE" ;
	public static final String MSG_STRING_QUERY_STRING = "QUERY_STRING" ;
	public static final String MSG_STRING_REQUEST_METHOD = "REQUEST_METHOD" ;
	public static final String MSG_STRING_PATH_INFO = "PATH_INFO" ;
	public static final String MSG_STRING_WSI_LOCATION = "_X_ABTWSI_LOCATION" ;
	public static final String MSG_STRING_HTTP_LOCATION = "Location" ;
	public static final String MSG_STRING_WSI_CONTENT_TYPE = "_X_ABTWSI_CONTENT_TYPE" ;
	public static final String MSG_STRING_WSI_STATUS_CODE = "_X_ABTWSI_STATUS_CODE" ;
	public static final String MSG_STRING_HTTP_CONTENT_TYPE = "Content-Type" ;
	public static final String MSG_STRING_WSI_COOKIE_COUNT = "WSI_COOKIE_COUNT" ;
	
		


	public static final String ERR_STRING_NOCONFIGFILE =
	"The configuration file '%s' could not be found or was unreadable." ;
	public static final String ERR_STRING_READCONFIGFILE =
	"An error occurred reading the configuration file %s.";
	public static final String ERR_STRING_PATHINFONOTSET =
	"The 'PATH_INFO' environment variable was not set by the calling program.";
	public static final String ERR_STRING_INVALIDKEYWORD =
	"An invalid keyword '%s' was found in the configuration file.";
	public static final String ERR_STRING_INVALIDKEYDATA =
	"Invalid data '%s' was defined for the keyword '%s' in the configuration file.";
	public static final String ERR_STRING_NOTENOUGHPARMS =
	"Not enough parameters for the keyword '%s' were defined in the configuration file.";
	public static final String ERR_STRING_NOPARMS =
	"No parameters for the keyword '%s' were defined in the configuration file.";
	public static final String ERR_STRING_INVALIDLINKTRANSPORT = 
	"An invalid link transport '%s' was specified in the configuration file.";
	public static final String ERR_STRING_INVALIDSOCKETTIMEOUT = 
	"The value for the 'SOCKET_TIMEOUT' property must be an integer.  Using default";
	public static final String ERR_STRING_GETINPUTSTREAM =
	"An exception occured while opening the input stream for the HTTP request" ;
	public static final String ERR_STRING_READINPUTSTREAM =
	"An exception occured while reading the input stream for the HTTP request" ;
	public static final String ERR_STRING_MISSINGLINK =
	"No valid link entries for this request were found in the configuration file" ;


	public static final String DEBUG = "Debug: " ;
	public static final String DEBUG_BUILDREQUEST = 
	"Building request data structure to be passed to Smalltalk.";
	public static final String DEBUG_HOSTLOOKUP = 
	"Looking for transport to be used.";
	public static final String DEBUG_HOSTNAME = 
	"Host name of target transport: ";
	public static final String DEBUG_SOCKET_NEW = 
	"Creating new socket.";
	public static final String DEBUG_SOCKET_TIMEOUT = 
	"Setting socket timeout value.";
	public static final String DEBUG_SOCKET_WRITE = 
	"Writing to socket.";
	public static final String DEBUG_SOCKET_READHEADER = 
	"Reading header bytes from socket.";
	public static final String DEBUG_SOCKET_READBODY = 
	"Reading HTML bytes from socket.";
	public static final String DEBUG_HTML_WRITE =
	"Writing HTML to the HttpServletResponse stream. Number of bytes: " ;
	public static final String DEBUG_SOCKET_CLOSE =
	"Closing socket. " ;
	public static final String DEBUG_HTML_CLOSE =
	"Closing HTML stream. " ;
	public static final String DEBUG_CONTENT_LENGTH =
	"Content length: " ;
	public static final String DEBUG_CONTENTS =
	"Buffer contents: " ;
	public static final String DEBUG_READ_INPUTSTREAM =
	"Reading from input stream" ;
	public static final String DEBUG_CLOSE_INPUTSTREAM =
	"Closing input stream" ;
	
}
