/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is OS/2 specific turbo mode
 *
 * The Initial Developer of the Original Code is IBM Corporation. 
 * Portions created by IBM Corporation are Copyright (C) 2002
 * IBM Corporation. All Rights Reserved.
 *
 * Contributor(s): Sam Emrick
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or 
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/*******************************************************************************
This program implements a module preloader for the OS/2 version of the Mozilla
Web Browser.

The program operates by way of DosLoadModule of a pre-defined list of modules.
In addition to DosLoadModule, the program then queries the ordinal entry points
of the modules and then accesses the address of each entry point in order to
cause the memory page of that entry point to become paged-in and resident in
memory. In this way the program preloads much of the modules used in MOZILLA
execution. After preloading the modules, then the program suspends execution
by infinite wait on a named semaphore. In this manner, the OS2TURBO holds the
MOZILLA modules in memory before and after the execution of MOZILLA.

The UNLOAD option is provided to allow a second invocation of this program to
communicate with, and signal termination of, the first instance of the program.
This allows DETACH OS2TURBO -LOAD to be used to load, then as required,
OS2TURBO -UNLOAD will cause the detached instance of OS2TURBO to unload and
exit. Both -UNLOAD and -LOAD may be specified, to allow a concurrent unload
and reload of modules. This might be used to, for example, reload MOZILLA
modules from a different path.

Notes: As currently implemented, OS2TURBO loads modules from LIBPATH. This
may not be the module location loading as used by MOZILLA. Need to check this.

The list of module names to be loaded is 'hardcoded' in the file os2turbo.h
and specified to the program by means of #include <os2turbo.h>. This list of
files need to be reviewed. Perhaps a less hardcoded list should be implemented.
*******************************************************************************/

#define INCL_DOS
#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <sys\timeb.h>
#include "os2turbo.h"
#define ERREXIT(msg) {printf(msg);return -1;}

int main(int argc, char *argv[]) {

/* The list of supported command line parameters */
 char *parms[6] = { "-D", "-L", "-U", "-H", "-?", "-P" };
/* Flags to indicate options */
 int debug=0; int doload=0; int dounload=0; int dohelp=0; int dopath=0;

/* Vars for EventSem usage */
 char *semname = "\\SEM32\\OS2TURBO\\OS2TURBO";
 unsigned long mysem = 0;
/* Vars for DosLoadModule usage */
 unsigned long handle=0;
 unsigned long rc=0;
 char *basepath = "";
 char *filepath = "";
/* Vars for DosQueryProcAddr usage */
 PFN modaddr;
/* Vars for DosQueryMem usage */
 unsigned long memsize=0;
 unsigned long memend=0;
 unsigned long memflags=0;
 unsigned char buffer[512];
 volatile unsigned char cpybuf;
 unsigned int bas1, bas2, bas3, bas4, bas5;
/* Help file vars */
 char *pchar;
/* Loop control vars */
 unsigned int i=0;
 unsigned int j=0;
 unsigned int base=0;
 unsigned char* baseptr=0;

/* Parse command line args, set flags */
 if (argc==1) dohelp=1;
 for (i=1; i < argc; i++) {
    argv[i] = strupr(argv[i]);
    if (0==strcmp(argv[i],parms[0])) debug=1;
    else if (0==strcmp(argv[i],parms[1])) doload=1;
    else if (0==strcmp(argv[i],parms[2])) dounload=1;
    else if (0==strcmp(argv[i],parms[3])) dohelp=1;
    else if (0==strcmp(argv[i],parms[4])) dohelp=1;
    else if (0==strcmp(argv[i],parms[5])) dopath=i;
    } // end for

/* If requested, process -HELP or -? */
 if (dohelp) {
    printf("Usage: os2turbo [-h] [-l | -u] [-p path] [-d]                \n"\ 
           "       -h display this help                                  \n"\ 
           "       -l load IBM Web Browser modules                       \n"\ 
           "       -u unload IBM Web Browser modules                     \n"\ 
           "       -p specify fully qualified path to OS2WEB.EXE        \n"\ 
           "       -d display debug messages                             \n"\ 
           "                                                             \n"\ 
           "       Example: DETACH x:\\path\\os2turbo -l -p C:\\OS2WEB\n");
    } // end if dohelp

/* If requested, process -UNLOAD */
 if (dounload) {
   /* If already loaded, sem create will fail */
   if (0 == DosCreateEventSem(semname, &mysem, 1, 0))
      ERREXIT("OS2TURBO Not loaded, so cannot unload.\n");

   /* Open the sem and post, other instance is waiting for it */
   if (0 != DosOpenEventSem(semname, &mysem))
      ERREXIT("OS2TURBO UNLOAD DosOpenEventSem error.\n");

   if (0 != DosPostEventSem(mysem))
      ERREXIT("OS2TURBO UNLOAD DosPostEventSem error.\n");

   /* Close sem (because we might want to reload) */
   if (0 != DosCloseEventSem(mysem))
      ERREXIT("OS2TURBO UNLOAD DosCloseEventSem error.\n");

   /* Give other instance time to execute, exit, and destroy the sem */
   DosSleep(100L);
   } // end if dounload

/* If requested, process -PATH */
 if (dopath) {
  basepath = argv[dopath+1];
  i=strlen(basepath);
  if (basepath[i-4]=='.' && basepath[i-3]=='E' && basepath[i-2]=='X' && basepath[i-1]=='E') {
    /* path parm ends with .exe or .EXE so strip back to previous backslash */
     pchar = strrchr(basepath, '\\');
     pchar++;
     *pchar = '\0';
     }
   else if (basepath[i-1]!='\\') {
    /* path parm ends with neither .EXE nor backslash so add a backslash */
     basepath = strcat(basepath,"\\");
     }
  } // end if dopath

/* If requested, process -LOAD */
 if (doload) {
   DosSetMaxFH(120L); /* insure sufficient file handles */
   /* create the shared interprocess sem used to signal quit */
   if (0 != DosCreateEventSem(semname, &mysem, 1, 0))
      ERREXIT("OS2TURBO Cannot load, already loaded.\n");

/* Set up extended libpath, form is "path;path\COMPONENTS;.\;" */
   filepath = strcpy(buffer,basepath);
   filepath = strcat(filepath,";");
   filepath = strcat(filepath,basepath);
   filepath = strcat(filepath,"COMPONENTS;.\\;\0");
   rc = DosSetExtLIBPATH(filepath,1);
   if (debug) printf("DosSetExtLIBPATH %s rc=%u \n", filepath,rc);

   /* loop through list loading named modules */
   for (i=0; i<nummods; i++) {
      bas1=0; bas2=0; bas3=0; bas4=0; bas5=0;
      buffer[0]='\0';
      filepath = strcpy(buffer,basepath);
      filepath = strcat(filepath,mods[i]);
      filepath = strcat(filepath,".DLL\0");

      rc = DosLoadModule(buffer,sizeof(buffer),filepath,&handle);
        if (debug) printf("DosLoadModule[%u] %s rc= %u\n",i,filepath,rc);
      if (rc!=0) {
        buffer[0]='\0'; /* clear buf, easier way? */
        filepath = strcpy(buffer,basepath);
        filepath = strcat(filepath,"COMPONENTS\\");
        filepath = strcat(filepath,mods[i]);
        filepath = strcat(filepath,".DLL\0");
        rc = DosLoadModule(buffer,sizeof(buffer),filepath,&handle);
        if (debug) printf("DosLoadModule[%u] %s rc= %u\n",i,filepath,rc);
        }
      if (rc==0) {
        /* Loop through module ordinal entry points */
        for (j=1; (0==DosQueryProcAddr(handle,j,0,&modaddr) && j<512); j++) {
//        if (debug) printf("DosQueryProcAddr %u %x\n",j, modaddr);

          /* calc 64K aligned addr previous to entry point */
          base=(( (unsigned long)modaddr) & 0xFFFF0000);
          /* filter previously loaded base addresses */
          if (base!=bas1 && base!=bas2 && base!=bas3 && base!=bas4 && base!=bas5) {

            /* get size and flags for this memory area */
            memsize=0x0fffffff;
            DosQueryMem((void*)base,&memsize,&memflags);
//          if (debug) printf("DosQueryMem %u %u %u\n",base, memsize, memflags);

            /* if not first page of object, back off addr and retry */
            while (memflags < 0x10000) {
              base=base-65536;
              memsize=0x0fffffff;
              DosQueryMem((void*)base,&memsize,&memflags);
              } // end while

            /* again filter previously loaded base addresses */
            /* also filter any readwrite pages (usually not shared) */
//          if (memflags&0x02 && base!=bas1 && base!=bas2 && base!=bas3 && base!=bas4 && base!=bas5) {
            if (base!=bas1 && base!=bas2 && base!=bas3 && base!=bas4 && base!=bas5) {
            /* not previously loaded, so cache the base address (first 5) */
              if (bas1==0) bas1=base;
              else if (bas2==0) bas2=base;
              else if (bas3==0) bas3=base;
              else if (bas4==0) bas4=base;
              else if (bas5==0) bas5=base;

              /* finally, now loop through object pages, force page-in */
              memend=base+memsize;
              while(base<memend) {
//              if (debug) printf("end= %X base= %X \n",memend, base);
                baseptr=(unsigned char*)base;
                cpybuf=*baseptr;
                base+=4096;
                }
              if (debug) {
                char tbuf[9]; struct timeb tb; ftime(&tb);
                printf("%s.%03d file[%u] %s hnd %u ord %d addr %X bytes %X flags %X\n",\
                   _strtime(tbuf),tb.millitm,i,filepath,handle,j,base,memsize,memflags);
                } // end if debug
              } // end if base (inner)
            } // end if base (outer)
          } // end for j (ordinals)
        } // end if rc==0
      else if (debug) printf("ERROR=%u Loading module[%d] %s\n",rc,i,mods[i]);
      } // end for i

   /* Go into infinite wait for the post signaling us to quit */
   if (debug) printf("\nDone Loading, going into wait.\n");
   if (0 != DosWaitEventSem(mysem, (unsigned long) -1L))
      ERREXIT("OS2TURBO LOAD DosWaitEventSem error.\n");

   /* Another instance of us must have posted it. Close the sem */
   if (0 != DosCloseEventSem(mysem))
      ERREXIT("OS2TURBO LOAD DosCloseEventSem error.\n");
   } // end if doload

/* When the program exits, any loaded modules will unload automaticly */
 return 0;
}
