#!c:\perl\bin\perl
#
# The contents of this file are subject to the Netscape Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/NPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is Mozilla Communicator client code, released
# March 31, 1998.
#
# The Initial Developer of the Original Code is Netscape
# Communications Corporation. Portions created by Netscape are
# Copyright (C) 1998-1999 Netscape Communications Corporation. All
# Rights Reserved.
#
# Contributor(s):
# Sean Su <ssu@netscape.com>
#

#
# This perl script builds the xpi, config.ini, and js files.
#

use File::Copy;
use Cwd;

# Make sure MOZ_SRC is set.
if($ENV{MOZ_SRC} eq "")
{
  print "Error: MOZ_SRC not set!";
  exit(1);
}

# Make sure there are at least three arguments
if($#ARGV < 2)
{
  PrintUsage();
}

$inDefaultVersion     = $ARGV[0];
# $ARGV[0] has the form maj.min.release.bld where maj, min, release
#   and bld are numerics representing version information.
# Other variables need to use parts of the version info also so we'll
#   split out the dot separated values into the array @versionParts
#   such that:
#
#   $versionParts[0] = maj
#   $versionParts[1] = min
#   $versionParts[2] = release
#   $versionParts[3] = bld
@versionParts = split /\./, $inDefaultVersion;

# We allow non-numeric characters to be included as the last
#   characters in fields of $ARG[0] for display purposes (mostly to
#   show that we have moved past a certain version by adding a '+'
#   character).  Non-numerics must be stripped out of $inDefaultVersion,
#   however, since this variable is used to identify the the product
#   for comparison with other installations, so the values in each field
#   must be numeric only:
$inDefaultVersion =~ s/[^0-9.][^.]*//g;
print "The raw version id is:  $inDefaultVersion\n";

$inStagePath          = $ARGV[1];
$inDistPath           = $ARGV[2];

$inXpiURL = "";
$inRedirIniURL = "";

ParseArgv(@ARGV);
if($inXpiURL eq "")
{
  # archive url not supplied, set it to default values
  $inXpiURL      = "ftp://not.supplied.invalid";
}
if($inRedirIniURL eq "")
{
  # redirect url not supplied, set it to default value.
  $inRedirIniURL = $inXpiURL;
}



# set environment vars for use by other .pl scripts called from this script.
if($versionParts[2] eq "0")
{
   $versionMain = "$versionParts[0]\.$versionParts[1]";
}
else
{
   $versionMain = "$versionParts[0]\.$versionParts[1]\.$versionParts[2]";
}
print "The display version is: $versionMain\n";
$versionLanguage               = "en";
$ENV{WIZ_nameCompany}          = "IBM";
$ENV{WIZ_nameProduct}          = "IBM Web Browser";
$ENV{WIZ_nameProductNoVersion} = "IBM Web Browser";
$ENV{WIZ_fileMainExe}          = "os2web.exe";
$ENV{WIZ_fileMainIco}          = "os2web.ico";
$ENV{WIZ_fileUninstall}        = "IWBUninstall.exe";
$ENV{WIZ_fileUninstallZip}     = "IWBUninstall.zip";
# The following variables are for displaying version info in the
# the installer.
$ENV{WIZ_userAgent}            = "$versionMain ($versionLanguage)";
$ENV{WIZ_userAgentShort}       = "$versionMain";
$ENV{WIZ_xpinstallVersion}     = "$versionMain";

# Set the location of the local tmp stage directory
$gLocalTmpStage = $inStagePath;

# Check for existence of staging path
if(!(-d "$inStagePath"))
{
  die "\n Invalid path: $inStagePath\n";
}

# List of components for to create xpi files from
@gComponentList = ("xpcom",
                   "browser",
                   "mail",
                   "spellcheck",
                   "psm",
                   "deflenus",
                   "langenus",
                   "iwbuinst",
                   "regus");

if(VerifyComponents()) # return value of 0 means no errors encountered
{
  exit(1);
}

# Make sure inDistPath exists
if(!(-d "$inDistPath"))
{
  mkdir ("$inDistPath",0775);
}
if(MakeXpiFile())
{
  exit(1);
}
if(MakeUninstall())
{
  exit(1);
}
if(MakeConfigFile())
{
  exit(1);
}

#IWB Uninst
if(MakeJsFile("iwbuinst"))
{
  return(1);
}

# Copy the setup files to the dist setup directory.
if(system("cp install.ini $inDistPath"))
{
  die "\n Error: copy install.ini $inDistPath\n";
}
if(system("cp config.ini $inDistPath"))
{
  die "\n Error: copy config.ini $inDistPath\n";
}


unlink <*.js>;
unlink <*.ini>;
unlink <*.template>;

print " done!\n\n";

# end of script
exit(0);



sub PrintUsage
{
  die "usage: $0 <default version> <staging path> <dist install path> [options]

       default version   : y2k compliant based date version.
                           ie: 5.0.0.2000040413

       staging path      : full path to where the components are staged at

       dist install path : full path to where the dist install dir is at.
                           ie: d:/builds/mozilla/dist/win32_o.obj/install

       options include:
           -aurl <archive url>      : either ftp:// or http:// url to where the
                                      archives (.xpi, .exe, .zip, etc...) reside

           -rurl <redirect.ini url> : either ftp:// or http:// url to where the
                                      redirec.ini resides.  If not supplied, it
                                      will be assumed to be the same as archive
                                      url.
       \n";
}

sub ParseArgv
{
  my(@myArgv) = @_;
  my($counter);

  # The first 3 arguments are required, so start on the 4th.
  for($counter = 3; $counter <= $#myArgv; $counter++)
  {
    if($myArgv[$counter] =~ /^[-,\/]h$/i)
    {
      PrintUsage();
    }
    elsif($myArgv[$counter] =~ /^[-,\/]aurl$/i)
    {
      if($#myArgv >= ($counter + 1))
      {
        ++$counter;
        $inXpiURL = $myArgv[$counter];
        $inRedirIniURL = $inXpiURL;
      }
    }
    elsif($myArgv[$counter] =~ /^[-,\/]rurl$/i)
    {
      if($#myArgv >= ($counter + 1))
      {
        ++$counter;
        $inRedirIniURL = $myArgv[$counter];
      }
    }
  }
}

sub MakeConfigFile
{
  # Make config.ini file
  if(system("perl makecfgini.pl config.it $inDefaultVersion $gLocalTmpStage $inDistPath $inRedirIniURL $inXpiURL"))
  {
    print "\n Error: perl makecfgini.pl config.it $inDefaultVersion $gLocalTmpStage $inDistPath $inRedirIniURL $inXpiURL\n";
    return(1);
  }

  # Make install.ini file
   if(system("perl makecfgini.pl install.it $inDefaultVersion $gLocalTmpStage $inDistPath $inRedirIniURL $inXpiURL"))
  {
    print "\n Error: perl makecfgini.pl install.it $inDefaultVersion $gLocalTmpStage $inDistPath $inRedirIniURL $inXpiURL\n";
    return(1);
  }
  return(0);
}

sub MakeUninstall
{
  if(MakeUninstallIniFile())
  {
    return(1);
  }

  # Copy the uninstall files to the dist uninstall directory.
  if(system("cp uninstall.ini $inDistPath"))
  {
    print "\n Error: copy uninstall.ini $inDistPath\n";
    return(1);
  }
  return(0);
}

sub MakeUninstallIniFile
{
  # Make config.ini file
  if(system("perl makeuninstallini.pl uninstall.it $inDefaultVersion"))
  {
    print "\n Error: perl makeuninstallini.pl uninstall.it $inDefaultVersion\n";
    return(1);
  }
  return(0);
}

sub MakeJsFile
{
  my($mComponent) = @_;

  # Make .js file
  if(system("perl makejs.pl $mComponent.jst $inDefaultVersion $gLocalTmpStage/$mComponent"))
  {
    print "\n Error: perl makejs.pl $mComponent.jst $inDefaultVersion $gLocalTmpStage/$mComponent\n";
    return(1);
  }
  return(0);
}

sub MakeXpiFile
{
  my($mComponent);

  foreach $mComponent (@gComponentList)
  {
    # Make .js files
    if(MakeJsFile($mComponent))
    {
      return(1);
    }

    # Make .xpi file
     if(system("perl makexpi.pl $mComponent $gLocalTmpStage $inDistPath"))
    {
      print "\n Error: perl makexpi.pl $mComponent $gLocalTmpStage $inDistPath\n";
      return(1);
    }
  }
  return(0);
}

sub RemoveLocalTmpStage()
{
  # Remove tmpstage area
  if(-d "$gLocalTmpStage")
  {
    system("perl rdir.pl $gLocalTmpStage");
  }
  return(0);
}

sub CreateTmpStage()
{
  my($mComponent);

  # Remove previous tmpstage area if one was left around
  if(-d "$gLocalTmpStage")
  {
    system("perl rdir.pl $gLocalTmpStage");
  }

  print "\n Creating the local TmpStage directory:\n";
  print "   $gLocalTmpStage\n";

  # Copy the component's staging dir locally so that the chrome packages, locales, and skins dirs can be
  # removed prior to creating the .xpi file.
  mkdir("$gLocalTmpStage", 775);

  foreach $mComponent (@gComponentList)
  {
    print "\n Copying $mComponent:\n";
    print " From: $inStagePath/$mComponent\n";
    print "   To: $gLocalTmpStage/$mComponent\n\n";
    mkdir("$gLocalTmpStage/$mComponent", 775);

    # If it's not talkback then copy the component over to the local tmp stage.
    # If it is, then skip the copy because there will be nothing at the source.
    # Talkback is a dummy place holder .xpi right now.  Mozilla release team
    # replaces this place holder .xpi with a real talkback when delivering the
    # build to mozilla.org.
    if(!($mComponent =~ /talkback/i))
    {
      if(system("xcopy /s/e $inStagePath/$mComponent $gLocalTmpStage/$mComponent/"))
      {
        print "\n Error: xcopy /s/e $inStagePath/$mComponent $gLocalTmpStage/$mComponent/\n";
        return(1);
      }
    }

    if(-d "$gLocalTmpStage/$mComponent/bin/chrome")
    {
      # Make chrome archive files
      if(&ZipChrome("win32", "noupdate", "$gLocalTmpStage/$mComponent/bin/chrome", "$gLocalTmpStage/$mComponent/bin/chrome"))
      {
        return(1);
      }

      # Remove the locales, packages, and skins dirs if they exist.
      my @dirs = <$gLocalTmpStage/$mComponent/bin/chrome/*>;
      foreach $d (@dirs) {
          if(-d "$d")
          {
              system("perl rdir.pl $d");
          }
      }
    }
  }
  return(0);
}

sub VerifyComponents()
{
  my($mComponent);
  my($mError) = 0;

  print "\n Verifying existence of required components...\n";
  foreach $mComponent (@gComponentList)
  {
    if($mComponent =~ /talkback/i)
    {
      print " place holder: $inStagePath/$mComponent\n";
      mkdir("$inStagePath/$mComponent", 775);
    }
    elsif(-d "$inStagePath/$mComponent")
    {
      print "           ok: $inStagePath/$mComponent\n";
    }
    else
    {
      print "        Error: $inStagePath/$mComponent does not exist!\n";
      $mError = 1;
    }
  }
  return($mError);
}

