/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive.index;

import com.installshield.archive.index.ArchiveIndexEntry;
import com.installshield.util.FileAttributes;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.InflaterInputStream;

class ArchiveIndexEntryReader {
    private int currentPacket = -1;
    private int packetSize;
    private Vector compressed;
    private Vector currentEntries;

    ArchiveIndexEntryReader(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.packetSize = dataInputStream.readInt();
        this.currentEntries = new Vector(this.packetSize);
        int n = dataInputStream.readInt();
        this.compressed = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            byte[] byArray = new byte[dataInputStream.readInt()];
            dataInputStream.readFully(byArray);
            this.compressed.addElement(byArray);
            ++n2;
        }
    }

    ArchiveIndexEntry getEntry(int n) throws IOException {
        int n2 = n / this.packetSize;
        if (n2 != this.currentPacket) {
            this.setCurrentPacket(n2);
        }
        int n3 = n % this.packetSize;
        return (ArchiveIndexEntry)this.currentEntries.elementAt(n3);
    }

    private void setCurrentPacket(int n) throws IOException {
        this.currentEntries.removeAllElements();
        System.gc();
        byte[] byArray = (byte[])this.compressed.elementAt(n);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray));
        DataInputStream dataInputStream = new DataInputStream(inflaterInputStream);
        int n2 = dataInputStream.readInt();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = dataInputStream.readInt();
            byte[] byArray2 = new byte[16];
            dataInputStream.readFully(byArray2);
            String string = dataInputStream.readUTF();
            int n5 = dataInputStream.readInt();
            long l = dataInputStream.readLong();
            int n6 = dataInputStream.readInt();
            int n7 = dataInputStream.readInt();
            boolean bl = dataInputStream.readBoolean();
            FileAttributes fileAttributes = null;
            if (dataInputStream.readBoolean()) {
                fileAttributes = new FileAttributes();
                fileAttributes.read(dataInputStream);
            }
            long l2 = dataInputStream.readLong();
            byte by = dataInputStream.readByte();
            String string2 = dataInputStream.readUTF();
            byte[] byArray3 = new byte[dataInputStream.readInt()];
            dataInputStream.readFully(byArray3);
            this.currentEntries.addElement(new ArchiveIndexEntry(n4, byArray2, string, n5, l, n6, n7, bl, fileAttributes, l2, by, string2, byArray3));
            ++n3;
        }
        this.currentPacket = n;
    }
}

