/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product;

import com.installshield.qjml.PropertyAccessible;

public class SoftwareVersion
implements PropertyAccessible,
Cloneable {
    private String major = "";
    private String minor = "";
    private String maintenance = "";
    private String update = "";
    private String formatted = "";
    public static int COMPARISON_DEPTH_MAJOR = 0;
    public static int COMPARISON_DEPTH_MINOR = 1;
    public static int COMPARISON_DEPTH_MAINTENANCE = 2;
    public static int COMPARISON_DEPTH_UPDATE = 3;

    public Object clone() {
        SoftwareVersion softwareVersion = new SoftwareVersion();
        softwareVersion.setMajor(this.major);
        softwareVersion.setMinor(this.minor);
        softwareVersion.setMaintenance(this.maintenance);
        softwareVersion.setUpdate(this.update);
        softwareVersion.setFormatted(this.formatted);
        return softwareVersion;
    }

    public int compareTo(SoftwareVersion softwareVersion) {
        return this.compareTo(softwareVersion, COMPARISON_DEPTH_UPDATE);
    }

    public int compareTo(SoftwareVersion softwareVersion, int n) {
        int n2 = this.compareVersionLevel(this.major, softwareVersion.major);
        if (n2 == 0 && n > COMPARISON_DEPTH_MAJOR && (n2 = this.compareVersionLevel(this.minor, softwareVersion.minor)) == 0 && n > COMPARISON_DEPTH_MINOR && (n2 = this.compareVersionLevel(this.maintenance, softwareVersion.maintenance)) == 0 && n > COMPARISON_DEPTH_MAINTENANCE) {
            n2 = this.compareVersionLevel(this.update, softwareVersion.update);
        }
        return n2;
    }

    private int compareVersionLevel(String string, String string2) {
        int n;
        try {
            int n2 = string == null || string.trim().length() == 0 ? 0 : Integer.parseInt(string);
            int n3 = string2 == null || string2.trim().length() == 0 ? 0 : Integer.parseInt(string2);
            n = n2 - n3;
            if (n != 0) {
                n = n > 0 ? 1 : -1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = string.compareTo(string2);
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SoftwareVersion) {
            SoftwareVersion softwareVersion = (SoftwareVersion)object;
            if (this.major.equals(softwareVersion.major) && this.minor.equals(softwareVersion.minor) && this.maintenance.equals(softwareVersion.maintenance) && this.update.equals(softwareVersion.update)) {
                bl = true;
            }
        }
        return bl;
    }

    public String getFormatted() {
        return this.formatted;
    }

    public String getMaintenance() {
        return this.maintenance;
    }

    public String getMajor() {
        return this.major;
    }

    public String getMinor() {
        return this.minor;
    }

    public String getUpdate() {
        return this.update;
    }

    public int hashCode() {
        String string = String.valueOf(this.major) + this.minor + this.maintenance + this.update;
        return string.hashCode();
    }

    public void setFormatted(String string) {
        if (string == null) {
            throw new IllegalArgumentException("version cannot be null");
        }
        this.formatted = string;
    }

    public void setMaintenance(String string) {
        this.setMaintenance(string, false);
    }

    public void setMaintenance(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("maintenance cannot be null");
        }
        if (bl) {
            try {
                this.maintenance = new Integer(string).toString();
            }
            catch (NumberFormatException numberFormatException) {
                this.maintenance = string;
            }
        } else {
            this.maintenance = string;
        }
    }

    public void setMajor(String string) {
        this.setMajor(string, false);
    }

    public void setMajor(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("major cannot be null");
        }
        if (bl) {
            try {
                this.major = new Integer(string).toString();
            }
            catch (NumberFormatException numberFormatException) {
                this.major = string;
            }
        } else {
            this.major = string;
        }
    }

    public void setMinor(String string) {
        this.setMinor(string, false);
    }

    public void setMinor(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("minor cannot be null");
        }
        if (bl) {
            try {
                this.minor = new Integer(string).toString();
            }
            catch (NumberFormatException numberFormatException) {
                this.minor = string;
            }
        } else {
            this.minor = string;
        }
    }

    public void setUpdate(String string) {
        this.setUpdate(string, false);
    }

    public void setUpdate(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("update cannot be null");
        }
        if (bl) {
            try {
                this.update = new Integer(string).toString();
            }
            catch (NumberFormatException numberFormatException) {
                this.update = string;
            }
        } else {
            this.update = string;
        }
    }

    public String toString() {
        return this.getFormatted();
    }
}

