/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.iterators;

import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductTreeIterator;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectReference;

public class RequiresTreeIterator
implements ProductTreeIterator {
    private ProductTreeIterator iter;
    private GenericSoftwareObject requiredObj;

    public RequiresTreeIterator(ProductTreeIterator productTreeIterator, GenericSoftwareObject genericSoftwareObject) {
        this.iter = productTreeIterator;
        this.requiredObj = genericSoftwareObject;
    }

    public ProductBean begin() {
        return this.iter.begin();
    }

    public ProductBean end() {
        return this.iter.end();
    }

    public ProductBean getNext(ProductBean productBean) {
        ProductBean productBean2 = this.iter.getNext(productBean);
        while (productBean2 != this.end() && !this.requiresObj(productBean2)) {
            productBean2 = this.iter.getNext(productBean2);
        }
        return productBean2;
    }

    public ProductBean getPrevious(ProductBean productBean) {
        ProductBean productBean2 = this.iter.getPrevious(productBean);
        while (productBean2 != this.begin() && !this.requiresObj(productBean2)) {
            productBean2 = this.iter.getPrevious(productBean2);
        }
        return productBean2;
    }

    private boolean requiresObj(ProductBean productBean) {
        boolean bl;
        block4: {
            block3: {
                bl = false;
                if (!(productBean instanceof GenericSoftwareObject)) break block3;
                GenericSoftwareObject genericSoftwareObject = (GenericSoftwareObject)productBean;
                int n = 0;
                while (!bl && n < genericSoftwareObject.getRequired().length) {
                    bl = genericSoftwareObject.getRequired()[n].getKey().equals(this.requiredObj.getKey());
                    ++n;
                }
                break block4;
            }
            if (!(productBean instanceof SoftwareObjectReference)) break block4;
            SoftwareObjectReference softwareObjectReference = (SoftwareObjectReference)productBean;
            SoftwareObject softwareObject = productBean.getProductTree().resolveKey(softwareObjectReference.getKey());
            if (softwareObject != null && softwareObject instanceof GenericSoftwareObject) {
                GenericSoftwareObject genericSoftwareObject = (GenericSoftwareObject)softwareObject;
                int n = 0;
                while (!bl && n < genericSoftwareObject.getRequired().length) {
                    bl = genericSoftwareObject.getRequired()[n].getKey().equals(this.requiredObj.getKey());
                    ++n;
                }
            }
        }
        return bl;
    }
}

