/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.qjml.PropertyAccessible;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class FileAttributes
implements PropertyAccessible,
Cloneable {
    private int attributes = 0;
    private Hashtable extendedAttributes = null;
    public static final int OS2 = 1;
    public static final int OWNER_READABLE = 1;
    public static final int OWNER_WRITEABLE = 2;
    public static final int OWNER_EXECUTABLE = 4;
    public static final int GROUP_READABLE = 8;
    public static final int GROUP_WRITEABLE = 16;
    public static final int GROUP_EXECUTABLE = 32;
    public static final int WORLD_READABLE = 64;
    public static final int WORLD_WRITEABLE = 128;
    public static final int WORLD_EXECUTABLE = 256;
    public static final int HIDDEN = 512;
    public static final int ARCHIVE = 1024;
    public static final int SYSTEM = 2048;
    public static final int DIRECTORY = 4096;

    public Object clone() {
        FileAttributes fileAttributes = new FileAttributes();
        fileAttributes.attributes = this.attributes;
        fileAttributes.extendedAttributes = this.extendedAttributes;
        return fileAttributes;
    }

    public boolean getAttributeState(int n) {
        return (this.attributes & n) == n;
    }

    public int getAttributes() {
        return this.attributes;
    }

    public byte[] getExtended(short s) {
        if (this.extendedAttributes != null) {
            return (byte[])this.extendedAttributes.get(new Short(s));
        }
        return null;
    }

    public void read(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.setAttributes(dataInputStream.readInt());
        int n = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            short s = dataInputStream.readShort();
            int n3 = dataInputStream.readInt();
            byte[] byArray = new byte[n3];
            int n4 = 0;
            while (n4 < byArray.length) {
                byArray[n4] = dataInputStream.readByte();
                ++n4;
            }
            this.setExtended(s, byArray);
            ++n2;
        }
    }

    public void setAttributeState(int n, boolean bl) {
        this.attributes = bl ? (this.attributes |= n) : (this.attributes &= ~n);
    }

    public void setAttributes(int n) {
        this.attributes = n;
    }

    public void setExtended(short s, byte[] byArray) {
        if (this.extendedAttributes == null) {
            this.extendedAttributes = new Hashtable();
        }
        this.extendedAttributes.put(new Short(s), byArray);
    }

    public String toString() {
        String string = new String(String.valueOf(this.getAttributeState(1) ? "r" : "") + (this.getAttributeState(2) ? "w" : "") + (this.getAttributeState(4) ? "x" : ""));
        String string2 = new String(String.valueOf(this.getAttributeState(8) ? "r" : "") + (this.getAttributeState(16) ? "w" : "") + (this.getAttributeState(32) ? "x" : ""));
        String string3 = new String(String.valueOf(this.getAttributeState(64) ? "r" : "") + (this.getAttributeState(128) ? "w" : "") + (this.getAttributeState(256) ? "x" : ""));
        String string4 = new String(this.getAttributeState(512) ? " hidden" : "");
        String string5 = new String(this.getAttributeState(1024) ? " archive" : "");
        String string6 = new String(this.getAttributeState(2048) ? " system" : "");
        return new String("owner (" + string + ")  group (" + string2 + ")  world (" + string3 + ")" + string4 + string5 + string6);
    }

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(this.attributes);
        int n = this.extendedAttributes == null ? 0 : this.extendedAttributes.size();
        dataOutputStream.writeInt(n);
        if (n > 0) {
            Enumeration enumeration = this.extendedAttributes.keys();
            while (enumeration.hasMoreElements()) {
                Short s = (Short)enumeration.nextElement();
                dataOutputStream.writeShort(s.shortValue());
                byte[] byArray = (byte[])this.extendedAttributes.get(s);
                dataOutputStream.writeInt(byArray.length);
                int n2 = 0;
                while (n2 < byArray.length) {
                    dataOutputStream.writeByte(byArray[n2]);
                    ++n2;
                }
            }
        }
        dataOutputStream.flush();
    }
}

