/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.PlainTextToken;
import com.installshield.util.StringResolutionToken;
import com.installshield.util.StringResolver;
import com.installshield.util.StringResolverException;
import com.installshield.util.StringResolverMethod;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Vector;

class FunctionToken
extends StringResolutionToken {
    private StringResolver resolver;
    private String name;
    private String[] arguments = new String[0];
    private String errorMsg = null;
    private boolean escaped = false;

    FunctionToken(StringResolver stringResolver, StreamTokenizer streamTokenizer) {
        this.resolver = stringResolver;
        try {
            int n = streamTokenizer.nextToken();
            String string = streamTokenizer.sval;
            if (n != -3 || string.length() == 0 || !Character.isJavaIdentifierStart(string.charAt(0)) || stringResolver.getMethod(string) == null) {
                streamTokenizer.pushBack();
                this.escaped = true;
                return;
            }
            this.name = string;
            if (streamTokenizer.nextToken() != 40) {
                streamTokenizer.pushBack();
                this.escaped = true;
                return;
            }
            Vector<String> vector = new Vector<String>();
            Vector<StringResolutionToken> vector2 = new Vector<StringResolutionToken>();
            n = streamTokenizer.nextToken();
            string = streamTokenizer.sval;
            while (n != 41) {
                switch (n) {
                    case -1: 
                    case 10: {
                        this.errorMsg = "(!ERROR unexpected EOF!)";
                        return;
                    }
                    case 36: {
                        if (streamTokenizer.nextToken() == 36) {
                            vector2.addElement(new PlainTextToken("$"));
                            break;
                        }
                        streamTokenizer.pushBack();
                        vector2.addElement(new FunctionToken(stringResolver, streamTokenizer));
                        break;
                    }
                    case 44: {
                        vector.addElement(stringResolver.mergeTokens(vector2));
                        vector2.removeAllElements();
                        break;
                    }
                    case 40: {
                        vector2.addElement(new PlainTextToken("("));
                        break;
                    }
                    default: {
                        vector2.addElement(new PlainTextToken(string.trim()));
                    }
                }
                n = streamTokenizer.nextToken();
                string = streamTokenizer.sval;
            }
            vector.addElement(stringResolver.mergeTokens(vector2));
            this.arguments = new String[vector.size()];
            vector.copyInto(this.arguments);
        }
        catch (IOException iOException) {
            throw new Error();
        }
    }

    String getValue() {
        if (this.escaped) {
            return this.name == null ? "$" : "$" + this.name;
        }
        if (this.errorMsg != null) {
            return this.errorMsg;
        }
        StringResolverMethod stringResolverMethod = this.resolver.getMethod(this.name);
        if (stringResolverMethod == null) {
            return "(!ERROR invalid method: \"" + this.name + "\"!)";
        }
        return this.resolver.resolve(stringResolverMethod.invoke(this.arguments));
    }

    String getValueWithValidation() throws StringResolverException {
        if (this.escaped) {
            return this.name == null ? "$" : "$" + this.name;
        }
        if (this.errorMsg != null) {
            throw new StringResolverException(this.errorMsg);
        }
        StringResolverMethod stringResolverMethod = this.resolver.getMethod(this.name);
        if (stringResolverMethod == null) {
            throw new StringResolverException("(!ERROR invalid method: \"" + this.name + "\"!)");
        }
        return this.resolver.resolveWithValidation(stringResolverMethod.invokeWithValidation(this.arguments));
    }
}

