/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.RunnableWizardBean;
import com.installshield.wizard.RunnableWizardBeanContext;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardEvent;
import com.installshield.wizard.WizardListener;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.WizardUICursorManager;

public class StandardWizardListener
implements WizardListener {
    private WizardUI ui = null;
    private boolean uiInitialized = false;

    public void currentBeanChanged(WizardEvent wizardEvent) {
        if (this.ui == null || !this.ui.currentBeanChanged(wizardEvent)) {
            this.setWaitCursor();
            if (wizardEvent.getWizard().getCurrentBean() instanceof RunnableWizardBean) {
                if (((RunnableWizardBean)((Object)wizardEvent.getWizard().getCurrentBean())).isCancelable()) {
                    this.setDefaultCursor();
                }
                this.execute((RunnableWizardBean)((Object)wizardEvent.getWizard().getCurrentBean()), wizardEvent);
            } else {
                this.execute(wizardEvent.getWizard().getCurrentBean(), new WizardBeanEvent(wizardEvent, this.ui));
            }
            this.setDefaultCursor();
        }
    }

    private void execute(RunnableWizardBean runnableWizardBean, WizardEvent wizardEvent) {
        WizardBeanEvent wizardBeanEvent = new WizardBeanEvent(wizardEvent, this.ui);
        if (runnableWizardBean.isSynchronous()) {
            runnableWizardBean.execute(wizardBeanEvent);
        } else {
            RunnableWizardBeanContext runnableWizardBeanContext = new RunnableWizardBeanContext(runnableWizardBean, wizardBeanEvent);
            if (this.ui != null) {
                this.ui.runnableBeanStarted(runnableWizardBean);
            }
            runnableWizardBeanContext.start();
            RunnableWizardBeanContext runnableWizardBeanContext2 = runnableWizardBeanContext;
            synchronized (runnableWizardBeanContext2) {
                try {
                    runnableWizardBeanContext.join();
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("ERROR: runnable context interrupted");
                }
            }
            if (this.ui != null) {
                this.ui.runnableBeanStopped(runnableWizardBean);
            }
        }
    }

    private void execute(WizardBean wizardBean, WizardBeanEvent wizardBeanEvent) {
        wizardBean.execute(wizardBeanEvent);
    }

    private WizardUI getWizardUI(Wizard wizard) {
        if (wizard.getInterfaceName() == null || wizard.getInterfaceName().equals("none")) {
            return null;
        }
        int n = 0;
        while (n < wizard.getInterfaces().length) {
            WizardUI wizardUI = wizard.getInterfaces()[n];
            if (wizardUI.getName().equals(wizard.getInterfaceName())) {
                return wizardUI;
            }
            ++n;
        }
        System.out.println("WARNING: interface " + wizard.getInterfaceName() + " not found in wizard definition");
        return null;
    }

    public synchronized boolean isUiInitialized() {
        return this.uiInitialized;
    }

    private void setDefaultCursor() {
        if (this.ui != null && this.ui instanceof WizardUICursorManager) {
            ((WizardUICursorManager)((Object)this.ui)).setDefaultCursor();
        }
    }

    private synchronized void setUiInitialized(boolean bl) {
        this.uiInitialized = bl;
        this.notify();
    }

    private void setWaitCursor() {
        if (this.ui != null && this.ui instanceof WizardUICursorManager) {
            ((WizardUICursorManager)((Object)this.ui)).setWaitCursor();
        }
    }

    private synchronized void waitUntilUiInitialized() {
        while (!this.isUiInitialized()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void wizardFinished(WizardEvent wizardEvent) {
        if (this.ui != null) {
            this.ui.destroy();
        }
    }

    public void wizardInitializing(WizardEvent wizardEvent) {
        Wizard wizard = wizardEvent.getWizard();
        this.ui = this.getWizardUI(wizard);
        while (this.ui != null) {
            try {
                this.ui.initialize(wizard);
                wizard.setUI(this.ui);
            }
            catch (Throwable throwable) {
                wizard.getServices().logEvent(this, "dbg", throwable);
                WizardUI wizardUI = this.ui.getNextUI(wizard);
                if (wizardUI != null) {
                    wizard.getServices().logEvent(this, "wrn", "could not initialize interface " + this.ui.getName() + " - trying " + wizardUI.getName());
                    this.ui = wizardUI;
                    continue;
                }
                System.err.println(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AWTWizardUI.guiInstallError"));
                wizard.getServices().logEvent(this, "err", "could not initialize interface " + this.ui.getName());
                wizard.setExitCode(1004);
            }
            break;
        }
        this.setUiInitialized(true);
    }

    public void wizardStarted(WizardEvent wizardEvent) {
        this.setWaitCursor();
        this.waitUntilUiInitialized();
        this.setDefaultCursor();
    }
}

