/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.Log;
import com.installshield.util.LogUtils;
import com.installshield.wizard.service.Service;
import com.installshield.wizard.service.ServiceException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class WizardLog
implements Log,
PropertyAccessible {
    public static final String DEBUG_FLAG = "is.debug";
    public static final String TEMP_FILE_NAME = "$TEMPFILE";
    private String logOutput = null;
    private String optionalLogOutput = null;
    private boolean outputEnabled = false;
    private boolean stdoutEnabled = true;
    private Hashtable eventsToLog = new Hashtable();
    private boolean logAllEvents = true;
    private boolean logExceptionStackTraces = true;
    private String loggingContext = null;
    private boolean optionalOutputEnabled = false;
    private PrintStream stdout = System.out;
    private PrintStream stderr = System.err;
    private Service logService = null;
    private Method writeToOutput = null;
    private Method writeToOptionalOutput = null;
    private Method setLogOutput = null;
    private Method getLogOutput = null;
    private Method setOptionalLogOutput = null;
    private Method getOptionalLogOutput = null;
    private Method copyLogOutput = null;
    private Method copyOptionalLogOutput = null;
    static /* synthetic */ Class class$java$lang$String;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void clearAllEventsLogged() {
        this.eventsToLog.clear();
    }

    public void copyLogOutput(String string, boolean bl) {
        if (this.logService != null && this.getLogOutput != null) {
            try {
                this.copyLogOutput.invoke((Object)this.logService, string, new Boolean(bl));
            }
            catch (InvocationTargetException invocationTargetException) {
                this.stderr.println("WARNING: could not copy log output " + invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                this.stderr.println("WARNING: could not copy log output " + exception);
            }
        } else {
            if (string == null) {
                throw new IllegalArgumentException("log file cannot be null");
            }
            try {
                LogUtils.copyLogContents(this.getLogOutput(), string, bl);
            }
            catch (IOException iOException) {
                this.stderr.println("WARNING: could not copy log output " + iOException.getMessage());
            }
        }
    }

    public void copyOptionalLogOutput(String string, boolean bl) {
        if (this.logService != null && this.getLogOutput != null) {
            try {
                this.copyOptionalLogOutput.invoke((Object)this.logService, string, new Boolean(bl));
            }
            catch (InvocationTargetException invocationTargetException) {
                this.stderr.println("WARNING: could not copy optional log output " + invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                this.stderr.println("WARNING: could not copy optional log output " + exception);
            }
        } else {
            if (string == null) {
                throw new IllegalArgumentException("optional log file cannot be null");
            }
            try {
                LogUtils.copyLogContents(this.getOptionalLogOutput(), string, bl);
            }
            catch (IOException iOException) {
                this.stderr.println("WARNING: could not copy optional log output " + iOException.getMessage());
            }
        }
    }

    private String formatEvent(Object object, String string, Object object2) {
        String string2 = "";
        string2 = object != null ? "(" + DateFormat.getDateTimeInstance().format(new Date()) + ")" + ", " + this.getLoggingContext() + ", " + object.getClass().getName() + ", " + string + ", " + object2 : "(" + DateFormat.getDateTimeInstance().format(new Date()) + ")" + ", " + this.getLoggingContext() + ", null" + ", " + string + ", " + object2;
        return string2;
    }

    private String formatStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        String string = new String(byteArrayOutputStream.toByteArray());
        int n = 1;
        int n2 = 0;
        int n3 = string.length() - 1;
        while (n2 < n3 && (n2 = string.indexOf("\n", n2)) != -1) {
            ++n;
            ++n2;
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.println("STACK_TRACE: " + new Integer(n).toString());
        printWriter.print(string);
        printWriter.flush();
        return new String(byteArrayOutputStream.toByteArray());
    }

    public boolean getAllEventsLogged() {
        return this.logAllEvents;
    }

    public String[] getEventsLogged() {
        String[] stringArray = new String[this.eventsToLog.size()];
        int n = 0;
        Enumeration enumeration = this.eventsToLog.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public boolean getLogExceptionStackTraces() {
        return this.logExceptionStackTraces;
    }

    public String getLogOutput() {
        if (this.logService != null && this.getLogOutput != null) {
            try {
                return (String)this.getLogOutput.invoke((Object)this.logService, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.stderr.println("WARNING: could not get log service output: " + invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                this.stderr.println("WARNING: could not get log service output: " + exception);
            }
        }
        return this.logOutput;
    }

    public String getLoggingContext() {
        return this.loggingContext;
    }

    public String getOptionalLogOutput() {
        if (this.logService != null && this.getOptionalLogOutput != null) {
            try {
                return (String)this.getOptionalLogOutput.invoke((Object)this.logService, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.stderr.println("WARNING: could not get log service optional output: " + invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                this.stderr.println("WARNING: could not get log service optional output: " + exception);
            }
        }
        return this.optionalLogOutput;
    }

    public PrintStream getStderr() {
        return this.stderr;
    }

    public PrintStream getStdout() {
        return this.stdout;
    }

    public boolean isEventLogged(String string) {
        if (this.logAllEvents) {
            return true;
        }
        String string2 = string;
        while (string2 != null) {
            if (this.eventsToLog.containsKey(string2)) {
                return true;
            }
            int n = string2.lastIndexOf(46);
            String string3 = string2 = n != -1 ? string2.substring(0, n) : null;
        }
        return false;
    }

    public boolean isLogEchoedToScreen() {
        return this.stdoutEnabled;
    }

    public boolean isLogOutputEnabled() {
        return this.outputEnabled;
    }

    public boolean isOptionalLogOutputEnabled() {
        return this.optionalOutputEnabled;
    }

    public void logEvent(Object object, String string, Object object2) {
        boolean bl;
        ServiceException serviceException;
        if (object2 instanceof ServiceException && (serviceException = (ServiceException)object2).getData() instanceof Throwable) {
            object2 = serviceException.getData();
        }
        boolean bl2 = bl = System.getProperty(DEBUG_FLAG) != null;
        if ((bl || this.isEventLogged(string)) && (bl || this.outputEnabled || this.optionalOutputEnabled || this.stdoutEnabled)) {
            String string2 = this.formatEvent(object, string, object2);
            if (bl || this.outputEnabled) {
                this.writeToOutput(string2);
                if (this.logExceptionStackTraces && object2 instanceof Throwable) {
                    this.writeToOutput(this.formatStackTrace((Throwable)object2));
                }
            }
            if (this.optionalOutputEnabled) {
                this.writeToOptionalOutput(string2);
                if (this.logExceptionStackTraces && object2 instanceof Throwable) {
                    this.writeToOptionalOutput(this.formatStackTrace((Throwable)object2));
                }
            }
            if (bl || this.stdoutEnabled) {
                this.stdout.println(string2);
                if ((bl || this.logExceptionStackTraces) && object2 instanceof Throwable) {
                    ((Throwable)object2).printStackTrace(this.stdout);
                }
            }
        }
    }

    private void logImplError(Exception exception, String string) {
        this.stdout.println("An error occurred logging '" + string + "': " + exception);
    }

    public void logStream(Object object, String string, String string2, InputStream inputStream) {
        Object object2;
        String string3 = String.valueOf(string) + ": ---- BEGIN \"" + string2 + "\" output ---- (" + new Date() + ")";
        this.writeToOutput(string3);
        if (this.stdoutEnabled) {
            this.stdout.println(string3);
        }
        try {
            object2 = new BufferedReader(new InputStreamReader(inputStream));
            String string4 = null;
            while ((string4 = ((BufferedReader)object2).readLine()) != null) {
                String string5 = String.valueOf(String.valueOf(new Date())) + ": " + string4;
                this.writeToOutput(string5);
                if (!this.stdoutEnabled) continue;
                this.stdout.println(string5);
            }
        }
        catch (IOException iOException) {
            this.writeToOutput("An error occurred while reading the stream: " + iOException);
        }
        object2 = String.valueOf(string) + ": ---- END \"" + string2 + "\" output ---- (" + new Date() + ")";
        this.writeToOutput((String)object2);
        if (this.stdoutEnabled) {
            this.stdout.println((String)object2);
        }
    }

    public void setAllEventsLogged(boolean bl) {
        this.logAllEvents = bl;
    }

    public void setEventLogged(String string, boolean bl) {
        if (bl) {
            this.eventsToLog.put(string, "");
        } else {
            this.eventsToLog.remove(string);
        }
    }

    public void setEventsLogged(String[] stringArray) {
        if (stringArray != null) {
            this.clearAllEventsLogged();
            int n = 0;
            while (n < stringArray.length) {
                this.eventsToLog.put(stringArray[n], "");
                ++n;
            }
        }
    }

    public void setLogEchoedToScreen(boolean bl) {
        this.stdoutEnabled = bl;
    }

    public void setLogExceptionStackTraces(boolean bl) {
        this.logExceptionStackTraces = bl;
    }

    public void setLogOutput(String string) {
        block3: {
            this.logOutput = string;
            if (this.logService == null || this.setLogOutput == null) break block3;
            try {
                this.setLogOutput.invoke((Object)this.logService, string);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.stderr.println("WARNING: could not set log service output: " + invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                this.stderr.println("WARNING: could not set log service output: " + exception);
            }
        }
    }

    public void setLogOutputEnabled(boolean bl) {
        this.outputEnabled = bl;
    }

    public void setLogService(Service service) throws ServiceException {
        this.logService = service;
        if (service != null) {
            try {
                this.writeToOutput = service.getClass().getMethod("writeToOutput", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = WizardLog.class$("java.lang.String")));
                this.writeToOptionalOutput = service.getClass().getMethod("writeToOptionalOutput", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = WizardLog.class$("java.lang.String")));
                this.setLogOutput = service.getClass().getMethod("setLogOutput", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = WizardLog.class$("java.lang.String")));
                this.getLogOutput = service.getClass().getMethod("getLogOutput", new Class[0]);
                this.setOptionalLogOutput = service.getClass().getMethod("setOptionalLogOutput", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = WizardLog.class$("java.lang.String")));
                this.getOptionalLogOutput = service.getClass().getMethod("getOptionalLogOutput", new Class[0]);
                this.copyLogOutput = service.getClass().getMethod("copyLogOutput", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = WizardLog.class$("java.lang.String")), Boolean.TYPE);
                this.copyOptionalLogOutput = service.getClass().getMethod("copyOptionalLogOutput", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = WizardLog.class$("java.lang.String")), Boolean.TYPE);
                if (this.logOutput != null) {
                    this.setLogOutput(this.logOutput);
                }
                if (this.optionalLogOutput != null) {
                    this.setOptionalLogOutput(this.optionalLogOutput);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.writeToOutput = null;
                this.writeToOptionalOutput = null;
                this.setLogOutput = null;
                this.getLogOutput = null;
                this.setOptionalLogOutput = null;
                this.getOptionalLogOutput = null;
                this.copyLogOutput = null;
                this.copyOptionalLogOutput = null;
                throw new ServiceException(noSuchMethodException);
            }
        }
    }

    public void setLoggingContext(String string) {
        this.loggingContext = string;
    }

    public void setOptionalLogOutput(String string) {
        block3: {
            this.optionalLogOutput = string;
            if (this.logService == null || this.setOptionalLogOutput == null) break block3;
            try {
                this.setOptionalLogOutput.invoke((Object)this.logService, string);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.stderr.println("WARNING: could not set log service optional output: " + invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                this.stderr.println("WARNING: could not set log service optional output: " + exception);
            }
        }
    }

    public void setOptionalLogOutputEnabled(boolean bl) {
        this.optionalOutputEnabled = bl;
    }

    public void setStreams(PrintStream printStream, PrintStream printStream2) {
        if (printStream == null || printStream2 == null) {
            throw new IllegalArgumentException("streams cannot be null");
        }
        this.stdout = printStream;
        this.stderr = printStream2;
    }

    public static String subclassEvent(String string, String string2) {
        return String.valueOf(string) + "." + string2;
    }

    private void writeToOptionalOutput(String string) {
        block3: {
            if (this.logService == null || this.writeToOptionalOutput == null) break block3;
            try {
                this.writeToOptionalOutput.invoke((Object)this.logService, string);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.stderr.println("WARNING: could not write using log service: " + invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                this.stderr.println("WARNING: could not write using log service: " + exception);
            }
        }
    }

    private void writeToOutput(String string) {
        block4: {
            if (this.logService == null || this.writeToOutput == null) break block4;
            try {
                this.writeToOutput.invoke((Object)this.logService, string);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.stderr.println("WARNING: could not write using log service: " + invocationTargetException.getTargetException());
                if (!this.stdoutEnabled) {
                    this.stdout.println(string);
                }
            }
            catch (Exception exception) {
                this.stderr.println("WARNING: could not write using log service: " + exception);
                if (this.stdoutEnabled) break block4;
                this.stdout.println(string);
            }
        }
    }
}

