/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service.file;

import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.StringResolverException;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServicesDependentStringResolverMethod;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.file.FileService;

public class NormalizeMethod
extends ServicesDependentStringResolverMethod {
    private WizardServices services = null;

    public String getName() {
        return "N";
    }

    public void initialize(WizardServices wizardServices) {
        this.services = wizardServices;
    }

    public String invoke(String[] stringArray) {
        try {
            return this.invokeWithValidation(stringArray);
        }
        catch (StringResolverException stringResolverException) {
            return stringResolverException.getMessage();
        }
    }

    public String invokeWithValidation(String[] stringArray) throws StringResolverException {
        if (this.services == null) {
            throw new StringResolverException("ERROR: services not set");
        }
        if (stringArray.length != 1 && stringArray.length != 2 || stringArray.length == 2 && stringArray[1].length() != 1) {
            throw new StringResolverException(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "NormalizeMethod.error"));
        }
        String string = stringArray[0];
        try {
            FileService fileService = (FileService)this.services.getService("fileService");
            string = FileUtils.canonizePath(string);
            string = stringArray.length == 1 ? fileService.normalizeFileName(string) : fileService.normalizeFileName(string, stringArray[1].toCharArray()[0]);
        }
        catch (ServiceException serviceException) {
            throw new StringResolverException("ERROR: " + serviceException);
        }
        return string;
    }
}

