/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.JPanel;

public class JISBranding
extends JPanel {
    public static int SPACING = 5;
    private String signature = "";
    private Dimension size = null;
    private int height = -1;
    private int ascent = -1;
    private int sigWidth = -1;

    public JISBranding(String string) {
        this.signature = string;
    }

    public Dimension getMinimumSize() {
        if (this.size == null) {
            this.initialize();
        }
        return this.size;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width = Math.max(dimension.width, this.getSize().width);
        return dimension;
    }

    private void initialize() {
        if (this.signature != null) {
            FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
            this.height = fontMetrics.getHeight();
            this.ascent = fontMetrics.getAscent();
            this.sigWidth = fontMetrics.stringWidth(this.signature);
        } else {
            this.sigWidth = 0;
            this.height = 3;
        }
        this.size = new Dimension(this.sigWidth, this.height);
    }

    private void initializeColor(Graphics graphics) {
        Color color = this.getForeground();
        int n = color.getRed() + color.getGreen() + color.getBlue();
        if (n == 0) {
            graphics.setColor(new Color(51, 51, 51));
        } else if (n == 765) {
            graphics.setColor(new Color(204, 204, 204));
        } else {
            graphics.setColor(color);
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.initializeColor(graphics);
        int n = this.height / 2;
        int n2 = this.sigWidth + SPACING;
        int n3 = n;
        graphics.setColor(SystemColor.control);
        graphics.draw3DRect(n2, n3, dimension.width, 1, false);
        graphics.setColor(SystemColor.textHighlightText);
        if (this.signature != null && this.signature.trim().length() > 0) {
            graphics.drawString(this.signature, 1, this.ascent);
        }
        graphics.setColor(SystemColor.controlShadow);
        if (this.signature != null && this.signature.trim().length() > 0) {
            graphics.drawString(this.signature, 0, this.ascent - 1);
        }
    }
}

