/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.dump.editor;

import com.ibm.etools.fa.common.AbendingASIDKeyData;
import com.ibm.etools.fa.common.Address;
import com.ibm.etools.fa.common.MiniDumpRecord;
import com.ibm.etools.fa.common.UserNoteEntry;
import com.ibm.etools.fa.common.UserNotes;
import com.ibm.etools.fa.dump.editor.UserNoteDisplayPage;
import com.ibm.etools.fa.pages.SearchDialog;
import com.ibm.etools.fa.pages.UserNotePage;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.subsystem.FASubSystem;
import com.ibm.etools.fa.util.AddressHandler;
import com.ibm.etools.fa.util.EditorManagement;
import com.ibm.etools.fa.util.MiniDumpFormatter;
import com.ibm.etools.fa.util.MiniDumpRecordReader;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.util.RSESystemManagement;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;

public class DumpBrowser
extends FormEditor {
    public static final String ID = "com.ibm.etools.fa.dump.editor.DumpBrowser";
    private static final String ADDRESS_COMBO_KEY = String.valueOf(DumpBrowser.class.getName()) + ".addressCombo";
    private static final int ESTIMATE_LINE_NO_PER_PAGE = 100;
    private DumpBrowser thisEditor;
    private StyledText dumpText;
    private int currentDumpPagesTopIndex = 0;
    private ArrayList<Address> addresses;
    private AbendingASIDKeyData abendingASID;
    private Combo addressCombo;
    private Button addressGoButton;
    private Button browseReportButton;
    private Address currentStartAddress;
    private MenuItem goToMenuItem;
    private MenuItem userNoteMenuItem;
    private Slider verticalSlider;
    private boolean verticalSliderDragStarted;
    private UserNotes userNotes;
    private final int NUMBER_OF_RECORDS_PER_DISPLAY = 2;
    private MiniDumpRecord[] currentVisiblePages = new MiniDumpRecord[2];
    private Integer[] currentVisiblePageIndex = new Integer[2];
    private UserNoteDisplayPage userNoteDisplayPage;
    boolean initialPageDisplayDone = false;

    public DumpBrowser() {
        this.thisEditor = this;
    }

    public void setFocus() {
        super.setFocus();
        if (!this.initialPageDisplayDone) {
            this.displayCurrentPages();
            this.addStyleRanges();
            this.initialPageDisplayDone = true;
        }
    }

    protected void addPages() {
        try {
            this.abendingASID = MiniDumpRecordReader.getAbendingASID(this.getFile().getLocation().toFile());
            this.addresses = MiniDumpRecordReader.getPageAddresses(this.getFile().getLocation().toFile(), this.abendingASID);
            Composite dumpMainDisplayComposite = new Composite(this.getContainer(), 0);
            dumpMainDisplayComposite.setLayout((Layout)new GridLayout(1, false));
            this.createDumpBrowserPage(dumpMainDisplayComposite);
            int index = this.addPage((Control)dumpMainDisplayComposite);
            this.setPageText(index, NLS.getString("DumpBrowser"));
            this.userNotes = MiniDumpRecordReader.getUserNotes(this.getFile().getLocation().toFile());
            if (this.userNotes == null) {
                this.userNotes = new UserNotes();
            }
            this.userNoteDisplayPage = new UserNoteDisplayPage(this, this.userNotes);
            this.addPage((IFormPage)this.userNoteDisplayPage);
            this.setPartName(this.getFile().getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        File tmpSaveFile = new File(String.valueOf(this.getFile().getLocation().toString()) + ".tmp");
        if (!tmpSaveFile.exists()) {
            return;
        }
        FileInputStream input = null;
        try {
            try {
                input = new FileInputStream(tmpSaveFile);
                IFile currentFile = this.getFile();
                currentFile.setContents((InputStream)input, true, false, monitor);
                currentFile.refreshLocal(1, monitor);
                tmpSaveFile.delete();
            }
            catch (Exception e) {
                FAPlugin.getDefault().log(4, NLS.getString("DumpEditor.SaveFailure"), e, true);
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        File tmpSaveFile = new File(String.valueOf(this.getFile().getLocation().toString()) + ".tmp");
        return tmpSaveFile.exists();
    }

    public IFile getFile() {
        IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
        return file;
    }

    private void createDumpBrowserPage(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        mainComposite.setLayoutData((Object)layoutData);
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        this.dumpText = new StyledText(mainComposite, 768);
        this.dumpText.setEditable(false);
        GridData editorGridData = new GridData();
        editorGridData.horizontalAlignment = 4;
        editorGridData.verticalAlignment = 4;
        editorGridData.grabExcessHorizontalSpace = true;
        editorGridData.grabExcessVerticalSpace = true;
        this.dumpText.setLayoutData((Object)editorGridData);
        this.dumpText.setFont(JFaceResources.getFont((String)"com.ibm.etools.fa.defaultFont"));
        this.dumpText.addMouseTrackListener(this.createMouseTrackListener());
        this.dumpText.addMouseListener(this.createMouseListener());
        this.dumpText.getVerticalBar().addSelectionListener(this.createScrollBarSelectionListener());
        this.dumpText.getVerticalBar().setVisible(false);
        this.createDumpTextVerticalSlider(mainComposite);
        this.setTextAreaListener();
        this.createAddressEntryComposite(mainComposite);
        this.addressCombo.setItems(FAPlugin.getDefault().getDialogValues(ADDRESS_COMBO_KEY));
        this.currentStartAddress = new Address(0L, 0L);
        Menu menu = new Menu((Decorations)mainComposite.getShell(), 8);
        this.createShowMenu(menu);
        this.createUserNoteMenu(menu);
        this.dumpText.setMenu(menu);
    }

    private void createDumpTextVerticalSlider(Composite composite) {
        this.verticalSlider = new Slider(composite, 512);
        GridData verticalSliderGridData = new GridData();
        verticalSliderGridData.verticalAlignment = 4;
        verticalSliderGridData.grabExcessVerticalSpace = true;
        this.verticalSlider.setLayoutData((Object)verticalSliderGridData);
        this.verticalSlider.setMaximum(this.addresses.size() * 100);
        this.verticalSlider.setMinimum(0);
        this.verticalSlider.setThumb(10);
        this.verticalSliderDragStarted = false;
        this.verticalSlider.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                switch (e.detail) {
                    case 1: {
                        System.out.println("#### Drag!1");
                        int incrementPerPage = (DumpBrowser.this.verticalSlider.getMaximum() - DumpBrowser.this.verticalSlider.getMinimum()) / DumpBrowser.this.addresses.size();
                        int pageNo = DumpBrowser.this.verticalSlider.getSelection() / incrementPerPage;
                        DumpBrowser.this.verticalSlider.setToolTipText(((Address)DumpBrowser.this.addresses.get(pageNo)).toString());
                        DumpBrowser.this.verticalSliderDragStarted = true;
                        return;
                    }
                    case 0x1000002: {
                        System.out.println("#### ARROW_DOWN!!");
                        DumpBrowser.this.dumpText.setTopIndex(DumpBrowser.this.dumpText.getTopIndex() + 1);
                        int numberOfVisibleLines = DumpBrowser.this.calculateVisibleLineNumber();
                        DumpBrowser.this.adjustPagesForScrollRequest(1, numberOfVisibleLines);
                        DumpBrowser.this.setDumpTextVerticalSliderPosition();
                        return;
                    }
                    case 0x1000001: {
                        System.out.println("#### ARROW_UP!!");
                        DumpBrowser.this.dumpText.setTopIndex(DumpBrowser.this.dumpText.getTopIndex() - 1);
                        int numberOfVisibleLines = DumpBrowser.this.calculateVisibleLineNumber();
                        DumpBrowser.this.adjustPagesForScrollRequest(-1, numberOfVisibleLines);
                        DumpBrowser.this.setDumpTextVerticalSliderPosition();
                        return;
                    }
                    case 0x1000006: {
                        System.out.println("#### PAGE_DOWN!!");
                        int numberOfVisibleLines = DumpBrowser.this.calculateVisibleLineNumber();
                        DumpBrowser.this.dumpText.setTopIndex(DumpBrowser.this.dumpText.getTopIndex() + numberOfVisibleLines);
                        DumpBrowser.this.adjustPagesForScrollRequest(numberOfVisibleLines, numberOfVisibleLines);
                        DumpBrowser.this.setDumpTextVerticalSliderPosition();
                        return;
                    }
                    case 0x1000005: {
                        System.out.println("#### PAGE_UP!!");
                        int numberOfVisibleLines = DumpBrowser.this.calculateVisibleLineNumber();
                        DumpBrowser.this.dumpText.setTopIndex(DumpBrowser.this.dumpText.getTopIndex() - numberOfVisibleLines);
                        DumpBrowser.this.adjustPagesForScrollRequest(-numberOfVisibleLines, numberOfVisibleLines);
                        DumpBrowser.this.setDumpTextVerticalSliderPosition();
                        return;
                    }
                }
                System.out.println("#### Unknown event!");
                if (DumpBrowser.this.verticalSliderDragStarted) {
                    System.out.println("Handling mouseUp event in response to mouseDragStarted!");
                    DumpBrowser.this.verticalSliderDragStarted = false;
                    int incrementPerPage = (DumpBrowser.this.verticalSlider.getMaximum() - DumpBrowser.this.verticalSlider.getMinimum()) / DumpBrowser.this.addresses.size();
                    int pageNo = DumpBrowser.this.verticalSlider.getSelection() / incrementPerPage;
                    DumpBrowser.this.moveToAddress((Address)DumpBrowser.this.addresses.get(pageNo));
                }
            }
        });
    }

    private void setDumpTextVerticalSliderPosition() {
        int currentLineNo = this.dumpText.getTopIndex();
        int linesSoFar = 0;
        MiniDumpRecord currentRecord = null;
        int linesWithinRecord = 0;
        int i = 0;
        while (i < 2) {
            if (currentLineNo < linesSoFar + this.currentVisiblePages[i].getNumberOfLines()) {
                currentRecord = this.currentVisiblePages[i];
                linesWithinRecord = currentLineNo - linesSoFar;
                System.out.println("Line within record = " + linesWithinRecord);
                break;
            }
            linesSoFar += this.currentVisiblePages[i].getNumberOfLines();
            ++i;
        }
        i = 0;
        while (i < this.addresses.size()) {
            Address currAddr = this.addresses.get(i);
            if (currAddr.getAddress64() == currentRecord.getDDirMdAddr64() && currAddr.getAddress31() == currentRecord.getDDirMdAddr31()) {
                this.verticalSlider.setSelection(100 * i + linesWithinRecord);
                System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ set to " + (100 * i + linesWithinRecord));
                return;
            }
            ++i;
        }
    }

    private void createShowMenu(Menu menu) {
        this.goToMenuItem = new MenuItem(menu, 8);
        this.goToMenuItem.setText(NLS.getString("DumpEditor.ShowAction"));
        this.goToMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String selectedText = DumpBrowser.this.dumpText.getSelectionText().trim();
                System.out.println("Show " + selectedText);
                Address selectedAddr = AddressHandler.verifyAddress(selectedText);
                if (selectedAddr != null) {
                    if (!DumpBrowser.this.moveToAddress(selectedAddr)) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)NLS.getString("DumpEditor.NotInDumpTitle"), (String)(String.valueOf(NLS.getString("DumpEditor.NotInDumpMsg")) + " " + selectedText));
                    }
                    DumpBrowser.this.addressCombo.setText(selectedAddr.toString());
                    DumpBrowser.this.setDumpTextVerticalSliderPosition();
                } else {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)NLS.getString("InvalidAddr"), (String)(String.valueOf(NLS.getString("DumpEditor.InvalidAddrSelMsg")) + " " + selectedText));
                }
            }
        });
    }

    private SelectionListener createScrollBarSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                switch (e.detail) {
                    case 0x1000002: {
                        System.out.println("ARROW_DOWN");
                        int numberOfVisibleLines = DumpBrowser.this.calculateVisibleLineNumber();
                        DumpBrowser.this.adjustPagesForScrollRequest(1, numberOfVisibleLines);
                        DumpBrowser.this.setDumpTextVerticalSliderPosition();
                        return;
                    }
                    case 0x1000001: {
                        System.out.println("ARROW_UP");
                        int numberOfVisibleLines = DumpBrowser.this.calculateVisibleLineNumber();
                        DumpBrowser.this.adjustPagesForScrollRequest(-1, numberOfVisibleLines);
                        DumpBrowser.this.setDumpTextVerticalSliderPosition();
                        return;
                    }
                    case 0x1000006: {
                        System.out.println("PAGE_DOWN");
                        int numberOfVisibleLines = DumpBrowser.this.calculateVisibleLineNumber();
                        DumpBrowser.this.adjustPagesForScrollRequest(numberOfVisibleLines, numberOfVisibleLines);
                        DumpBrowser.this.setDumpTextVerticalSliderPosition();
                        return;
                    }
                    case 0x1000005: {
                        System.out.println("PAGE_UP");
                        int numberOfVisibleLines = DumpBrowser.this.calculateVisibleLineNumber();
                        DumpBrowser.this.adjustPagesForScrollRequest(-numberOfVisibleLines, numberOfVisibleLines);
                        DumpBrowser.this.setDumpTextVerticalSliderPosition();
                        return;
                    }
                }
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    private void adjustPagesForScrollRequest(int numberOfLinesToScroll, int numberOfVisibleLines) {
        int currentTopLine = this.dumpText.getTopIndex();
        int totalLines = this.dumpText.getLineCount();
        int newTopLine = currentTopLine + numberOfLinesToScroll;
        int pageAdjustNo = 0;
        if (newTopLine < 0) {
            System.out.println("Need to load the previous page!!");
            if (this.currentDumpPagesTopIndex == 0) {
                System.out.println("Top page already visible.");
                return;
            }
            System.out.println("Loading the previous page!");
            pageAdjustNo = -1;
        } else {
            if (newTopLine + numberOfVisibleLines <= totalLines) {
                return;
            }
            System.out.println("Need to load the next page!!");
            if (this.currentDumpPagesTopIndex + 2 == this.addresses.size()) {
                System.out.println("Bottom page already visible..");
                return;
            }
            System.out.println("Loading the next page...");
            pageAdjustNo = 1;
        }
        int linesSoFar = 0;
        int lineIndexWithinRecord = 0;
        MiniDumpRecord recordContainingTopLine = null;
        int i = 0;
        while (i < 2) {
            if (currentTopLine < linesSoFar + this.currentVisiblePages[i].getNumberOfLines()) {
                recordContainingTopLine = this.currentVisiblePages[i];
                lineIndexWithinRecord = currentTopLine - linesSoFar;
                System.out.println("Got the record I need...");
                break;
            }
            linesSoFar += this.currentVisiblePages[i].getNumberOfLines();
            ++i;
        }
        System.out.println("line index of current top line is " + lineIndexWithinRecord);
        this.currentDumpPagesTopIndex += pageAdjustNo;
        this.displayCurrentPages();
        linesSoFar = 0;
        i = 0;
        while (i < 2) {
            if (this.currentVisiblePages[i].equals(recordContainingTopLine)) {
                this.dumpText.setTopIndex(linesSoFar += lineIndexWithinRecord);
                System.out.println("Setting the top line to be " + linesSoFar);
                return;
            }
            linesSoFar += this.currentVisiblePages[i].getNumberOfLines();
            ++i;
        }
    }

    private MouseListener createMouseListener() {
        return new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 3 && DumpBrowser.this.dumpText.getSelectionText().length() == 0) {
                    int charOffset = DumpBrowser.this.dumpText.getOffsetAtLocation(new Point(e.x, e.y));
                    DumpBrowser.this.dumpText.setCaretOffset(charOffset);
                    int charSoFar = 0;
                    MiniDumpRecord record = null;
                    int i = 0;
                    while (i < 2) {
                        if (charOffset < DumpBrowser.this.currentVisiblePages[i].getTotalLengthOfFormattedText() + charSoFar) {
                            record = DumpBrowser.this.currentVisiblePages[i];
                            break;
                        }
                        charSoFar += DumpBrowser.this.currentVisiblePages[i].getTotalLengthOfFormattedText();
                        ++i;
                    }
                    Address selectedAddr = record.getSelectedAddress(charOffset - charSoFar);
                    if (selectedAddr != null) {
                        DumpBrowser.this.userNoteMenuItem.setEnabled(true);
                    } else {
                        DumpBrowser.this.userNoteMenuItem.setEnabled(false);
                    }
                    DumpBrowser.this.goToMenuItem.setEnabled(false);
                } else {
                    DumpBrowser.this.goToMenuItem.setEnabled(true);
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        };
    }

    private MouseTrackListener createMouseTrackListener() {
        return new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
            }

            public void mouseHover(MouseEvent e) {
                UserNoteEntry noteEntry;
                int charOffset = DumpBrowser.this.dumpText.getOffsetAtLocation(new Point(e.x, e.y));
                int charSoFar = 0;
                MiniDumpRecord record = null;
                int i = 0;
                while (i < 2) {
                    if (charOffset < DumpBrowser.this.currentVisiblePages[i].getTotalLengthOfFormattedText() + charSoFar) {
                        record = DumpBrowser.this.currentVisiblePages[i];
                        break;
                    }
                    charSoFar += DumpBrowser.this.currentVisiblePages[i].getTotalLengthOfFormattedText();
                    ++i;
                }
                Address selectedAddr = record.getSelectedAddress(charOffset - charSoFar);
                if (selectedAddr != null && (noteEntry = DumpBrowser.this.userNotes.getUserNote(selectedAddr)) != null) {
                    DumpBrowser.this.dumpText.setToolTipText(noteEntry.getNotes());
                }
            }
        };
    }

    private void setTextAreaListener() {
        this.dumpText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 0x1000001: {
                        int numberOfVisibleLines = DumpBrowser.this.calculateVisibleLineNumber();
                        DumpBrowser.this.adjustCurrentVisiblePages(-1, numberOfVisibleLines);
                        DumpBrowser.this.setDumpTextVerticalSliderPosition();
                        return;
                    }
                    case 0x1000002: {
                        int numberOfVisibleLines = DumpBrowser.this.calculateVisibleLineNumber();
                        DumpBrowser.this.adjustCurrentVisiblePages(1, numberOfVisibleLines);
                        DumpBrowser.this.setDumpTextVerticalSliderPosition();
                        return;
                    }
                    case 0x1000005: {
                        int numberOfVisibleLines = DumpBrowser.this.calculateVisibleLineNumber();
                        DumpBrowser.this.adjustCurrentVisiblePages(-numberOfVisibleLines, numberOfVisibleLines);
                        DumpBrowser.this.setDumpTextVerticalSliderPosition();
                        return;
                    }
                    case 0x1000006: {
                        int numberOfVisibleLines = DumpBrowser.this.calculateVisibleLineNumber();
                        DumpBrowser.this.adjustCurrentVisiblePages(numberOfVisibleLines, numberOfVisibleLines);
                        DumpBrowser.this.setDumpTextVerticalSliderPosition();
                        return;
                    }
                }
                if (e.stateMask == 262144 && e.character == '\u0006') {
                    System.out.println("Control was pressed.. and f was pressed..");
                    int charOffset = DumpBrowser.this.dumpText.getCaretOffset();
                    int charSoFar = 0;
                    int offsetWithinRecord = 0;
                    MiniDumpRecord record = null;
                    int i = 0;
                    while (i < 2) {
                        if (charOffset < DumpBrowser.this.currentVisiblePages[i].getTotalLengthOfFormattedText() + charSoFar) {
                            record = DumpBrowser.this.currentVisiblePages[i];
                            offsetWithinRecord = charOffset - charSoFar;
                            break;
                        }
                        charSoFar += DumpBrowser.this.currentVisiblePages[i].getTotalLengthOfFormattedText();
                        ++i;
                    }
                    Address startAddress = record.getClosestAddress(offsetWithinRecord);
                    SearchDialog dialog = new SearchDialog(Display.getCurrent().getActiveShell(), DumpBrowser.this.thisEditor, DumpBrowser.this.addresses, startAddress);
                    dialog.open();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private int calculateVisibleLineNumber() {
        Point dumpTextSize = this.dumpText.getSize();
        int lineHeight = this.dumpText.getLineHeight();
        int lineCount = dumpTextSize.y / lineHeight - 1;
        return lineCount;
    }

    private void adjustCurrentVisiblePages(int pageMovement, int numberOfVisibleLines) {
        int currentCarretOffset = this.dumpText.getCaretOffset();
        System.out.println("### Current caret offset = " + currentCarretOffset);
        int charactersSoFar = 0;
        MiniDumpRecord selectedRecord = null;
        int characterOffsetWithinPage = 0;
        int i = 0;
        while (i < 2) {
            System.out.println("Character so far = " + (charactersSoFar += this.currentVisiblePages[i].getTotalLengthOfFormattedText()));
            if (currentCarretOffset <= charactersSoFar) {
                selectedRecord = this.currentVisiblePages[i];
                characterOffsetWithinPage = currentCarretOffset - (charactersSoFar - this.currentVisiblePages[i].getTotalLengthOfFormattedText());
                System.out.println("Current carret is in page " + i + " visible page... starting at " + this.currentVisiblePages[i].getDDirMdAddr31() + " and offset witin the page is " + characterOffsetWithinPage);
                break;
            }
            ++i;
        }
        System.out.println("Current total line count = " + this.dumpText.getLineCount());
        System.out.println("Moving " + pageMovement + " within page where " + numberOfVisibleLines + " lines are visible and the current top line is " + this.dumpText.getTopIndex());
        if (pageMovement > 0) {
            if (this.dumpText.getTopIndex() + pageMovement > this.dumpText.getLineCount() - numberOfVisibleLines) {
                System.out.println("Moving down for " + pageMovement + "... Page rerefresh is required...");
                ++this.currentDumpPagesTopIndex;
                this.displayCurrentPages(selectedRecord, characterOffsetWithinPage);
            } else {
                System.out.println("Moving down for " + pageMovement + "...  Page rerefresh is not required...");
            }
        } else if (this.getCurrentLineNo() + pageMovement < 0) {
            System.out.println("Moving up for " + pageMovement + "... Page rerefresh is required...");
            --this.currentDumpPagesTopIndex;
            this.displayCurrentPages(selectedRecord, characterOffsetWithinPage);
        } else {
            System.out.println("Moving up for " + pageMovement + "...  Page rerefresh is not required...");
        }
    }

    private int getCurrentLineNo() {
        int newLineCount = 0;
        String text = this.dumpText.getText();
        int i = 0;
        while (i < this.dumpText.getCaretOffset()) {
            if (text.charAt(i) == '\n') {
                ++newLineCount;
            }
            ++i;
        }
        return newLineCount;
    }

    private void createAddressEntryComposite(Composite parent) {
        Composite goComposite = new Composite(parent, 0);
        goComposite.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(goComposite, 16384);
        label.setText(NLS.getString("Address"));
        this.addressCombo = new Combo(goComposite, 0);
        GridData addrEntryData = new GridData();
        addrEntryData.verticalAlignment = 4;
        addrEntryData.horizontalAlignment = 4;
        addrEntryData.grabExcessVerticalSpace = true;
        addrEntryData.grabExcessHorizontalSpace = true;
        addrEntryData.widthHint = 300;
        this.addressCombo.setLayoutData((Object)addrEntryData);
        this.addressCombo.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    String value = DumpBrowser.this.addressCombo.getText().trim();
                    Address enteredAddress = AddressHandler.verifyAddress(value);
                    if (enteredAddress == null) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)NLS.getString("InvalidAddr"), (String)NLS.getString("DumpEditor.InvalidAddrMsg"));
                        return;
                    }
                    if (!DumpBrowser.this.moveToAddress(enteredAddress)) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)NLS.getString("Failed"), (String)NLS.getString("DumpEditor.GoFailMsg"));
                        return;
                    }
                    DumpBrowser.this.setDumpTextVerticalSliderPosition();
                    FAPlugin.getDefault().addNewDialogValueIfNew(ADDRESS_COMBO_KEY, enteredAddress.toString());
                    DumpBrowser.this.addressCombo.setItems(FAPlugin.getDefault().getDialogValues(ADDRESS_COMBO_KEY));
                    DumpBrowser.this.addressCombo.setText(enteredAddress.toString());
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.addressGoButton = new Button(goComposite, 8);
        this.addressGoButton.setText(NLS.getString("Go"));
        GridData goButtonData = new GridData();
        goButtonData.widthHint = 80;
        this.addressGoButton.setLayoutData((Object)goButtonData);
        this.addressGoButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String value = DumpBrowser.this.addressCombo.getText().trim();
                Address enteredAddress = AddressHandler.verifyAddress(value);
                if (enteredAddress == null) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)NLS.getString("InvalidAddr"), (String)NLS.getString("DumpEditor.InvalidAddrMsg"));
                    return;
                }
                if (!DumpBrowser.this.moveToAddress(enteredAddress)) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)NLS.getString("Failed"), (String)NLS.getString("DumpEditor.GoFailMsg"));
                    return;
                }
                DumpBrowser.this.setDumpTextVerticalSliderPosition();
                FAPlugin.getDefault().addNewDialogValueIfNew(ADDRESS_COMBO_KEY, enteredAddress.toString());
                DumpBrowser.this.addressCombo.setItems(FAPlugin.getDefault().getDialogValues(ADDRESS_COMBO_KEY));
                DumpBrowser.this.addressCombo.setText(enteredAddress.toString());
            }
        });
        this.browseReportButton = new Button(goComposite, 8);
        this.browseReportButton.setText(NLS.getString("BrowseReport"));
        GridData browseButtonData = new GridData();
        browseButtonData.widthHint = 80;
        this.browseReportButton.setLayoutData((Object)browseButtonData);
        this.browseReportButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    IFile file = DumpBrowser.this.getFile();
                    String reportFileName = String.valueOf(file.getName().toString().substring(0, file.getName().lastIndexOf(46))) + ".far";
                    IFolder parent = (IFolder)file.getParent();
                    final IFile reportFile = parent.getFile(reportFileName);
                    if (reportFile.exists()) {
                        EditorManagement.openEditor(reportFile);
                    } else {
                        final String faultID = parent.getName();
                        final String histFileName = parent.getParent().getName();
                        final String systemName = parent.getParent().getParent().getName();
                        final String projPath = String.valueOf(systemName) + File.separator + histFileName + File.separator + faultID + File.separator;
                        Job browseReportJob = new Job(String.valueOf(NLS.getString("BrowseReportAction.JobTitle")) + " " + histFileName + "(" + faultID + ")"){

                            private void openErrorThreadSafe(String title, String message) {
                                Display.getDefault().asyncExec(new Runnable(this, title, message){
                                    final /* synthetic */ 1 this$2;
                                    private final /* synthetic */ String val$title;
                                    private final /* synthetic */ String val$message;
                                    {
                                        this.this$2 = var1_1;
                                        this.val$title = string;
                                        this.val$message = string2;
                                    }

                                    public void run() {
                                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)this.val$title, (String)this.val$message);
                                    }
                                });
                            }

                            protected IStatus run(IProgressMonitor monitor) {
                                try {
                                    monitor.beginTask("", 4);
                                    FASubSystem faSubSystem = RSESystemManagement.getFASubSystem(systemName);
                                    if (faSubSystem == null) {
                                        this.openErrorThreadSafe(NLS.getString("HistoryFilesView.NoSystemTitle"), String.valueOf(NLS.getString("HistoryFilesView.NoSystemMsg")) + " " + systemName);
                                        return Status.OK_STATUS;
                                    }
                                    monitor.worked(1);
                                    if (monitor.isCanceled()) {
                                        return Status.CANCEL_STATUS;
                                    }
                                    if (!faSubSystem.readHistoryFileMemberReportOnly(histFileName, faultID, String.valueOf(FAPlugin.getDefault().getConfigProject().getLocation().toString()) + File.separator + projPath, String.valueOf(faultID) + ".far")) {
                                        this.openErrorThreadSafe(NLS.getString("ReadHistMemTitle"), NLS.getString("ReadHistMemMsg"));
                                        return Status.OK_STATUS;
                                    }
                                    reportFile.refreshLocal(1, monitor);
                                    monitor.worked(1);
                                    if (monitor.isCanceled()) {
                                        return Status.CANCEL_STATUS;
                                    }
                                    EditorManagement em = new EditorManagement();
                                    em.openEditorFromWorkerThread(reportFile, monitor);
                                    monitor.worked(1);
                                    if (monitor.isCanceled()) {
                                        return Status.CANCEL_STATUS;
                                    }
                                    return Status.OK_STATUS;
                                }
                                catch (Exception exception) {
                                    this.openErrorThreadSafe(NLS.getString("BrowseReportAction.FailureTitle"), NLS.getString("BrowseReportAction.FailureMsg"));
                                    return Status.OK_STATUS;
                                }
                            }
                        };
                        browseReportJob.setPriority(30);
                        browseReportJob.setRule((ISchedulingRule)FAPlugin.getDefault().getConfigProject());
                        browseReportJob.schedule();
                    }
                }
                catch (Exception e1) {
                    FAPlugin.getDefault().log(4, NLS.getString("DumpEditor.OpenRptEditorErr"), e1, true);
                    return;
                }
            }
        });
    }

    private boolean displayCurrentPages() {
        File file;
        block8: {
            file = this.getFile().getLocation().toFile();
            if (file.exists()) break block8;
            return false;
        }
        try {
            if (this.currentDumpPagesTopIndex + 2 > this.addresses.size()) {
                this.currentDumpPagesTopIndex = this.addresses.size() - 2;
            }
            if (this.currentDumpPagesTopIndex < 0) {
                this.currentDumpPagesTopIndex = 0;
            }
            int i = 0;
            while (i < 2) {
                MiniDumpRecord record;
                this.currentVisiblePages[i] = record = MiniDumpRecordReader.readPage(file, this.addresses.get(this.currentDumpPagesTopIndex + i), this.abendingASID);
                this.currentVisiblePageIndex[i] = this.currentDumpPagesTopIndex + i;
                if (i == 0) {
                    this.dumpText.setText(record.formatPage(this.getPriorPageAddress(new Address(record.getDDirMdAddr64(), record.getDDirMdAddr31())), this.currentStartAddress).toString().trim());
                } else {
                    this.dumpText.append("\n" + record.formatPage(this.getPriorPageAddress(new Address(record.getDDirMdAddr64(), record.getDDirMdAddr31())), this.currentStartAddress).toString().trim());
                }
                ++i;
            }
            this.dumpText.redraw();
            this.addStyleRanges();
            return true;
        }
        catch (Exception e) {
            FAPlugin.getDefault().log(4, NLS.getString("DumpEditor.DispCurrPageErr"), e, true);
            return false;
        }
    }

    private boolean displayCurrentPages(MiniDumpRecord selectedAddressRangeRecord, int characterOffsetWithinPage) {
        File file;
        block10: {
            System.out.println("SelectedAddressRangeRecord = " + selectedAddressRangeRecord.getDDirMdAddr31() + " character offset within page = " + characterOffsetWithinPage);
            file = this.getFile().getLocation().toFile();
            if (file.exists()) break block10;
            return false;
        }
        try {
            if (this.currentDumpPagesTopIndex + 2 > this.addresses.size()) {
                this.currentDumpPagesTopIndex = this.addresses.size() - 2;
            }
            if (this.currentDumpPagesTopIndex < 0) {
                this.currentDumpPagesTopIndex = 0;
            }
            int i = 0;
            while (i < 2) {
                MiniDumpRecord record;
                this.currentVisiblePages[i] = record = MiniDumpRecordReader.readPage(file, this.addresses.get(this.currentDumpPagesTopIndex + i), this.abendingASID);
                this.currentVisiblePageIndex[i] = this.currentDumpPagesTopIndex + i;
                if (i == 0) {
                    this.dumpText.setText(record.formatPage(this.getPriorPageAddress(new Address(record.getDDirMdAddr64(), record.getDDirMdAddr31())), this.currentStartAddress).toString().trim());
                } else {
                    this.dumpText.append("\n" + record.formatPage(this.getPriorPageAddress(new Address(record.getDDirMdAddr64(), record.getDDirMdAddr31())), this.currentStartAddress).toString().trim());
                }
                ++i;
            }
            this.dumpText.redraw();
            this.addStyleRanges();
            int charOffset = 0;
            int i2 = 0;
            while (i2 < 2) {
                if (this.currentVisiblePages[i2].equals(selectedAddressRangeRecord)) {
                    charOffset += characterOffsetWithinPage;
                    break;
                }
                charOffset += this.currentVisiblePages[i2].getTotalLengthOfFormattedText();
                ++i2;
            }
            this.dumpText.setFocus();
            this.dumpText.setSelection(charOffset);
            this.dumpText.showSelection();
            return true;
        }
        catch (Exception e) {
            FAPlugin.getDefault().log(4, NLS.getString("DumpEditor.DispCurrPageErr"), e, true);
            return false;
        }
    }

    public boolean moveToAddress(Address address) {
        Address oldStartAddress = this.currentStartAddress;
        if (address.getAddress64() != 0L) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)NLS.getString("DumpEditor.64NotSupportedTitle"), (String)NLS.getString("DumpEditor.64NotSupportedMsg"));
            return true;
        }
        this.currentStartAddress = address;
        int i = 0;
        while (i < this.addresses.size()) {
            Address pageStart = this.addresses.get(i);
            if (pageStart.getAddress31() == 0L) {
                if (address.getAddress31() >= pageStart.getAddress31() && address.getAddress31() < pageStart.getAddress31() + 2048L) {
                    this.currentDumpPagesTopIndex = 0;
                    this.displayCurrentPages();
                    this.adjustCurosrLocation(address);
                    this.addressCombo.setText(address.toString());
                    return true;
                }
            } else if (address.getAddress31() >= pageStart.getAddress31() && address.getAddress31() < pageStart.getAddress31() + 4096L) {
                this.currentDumpPagesTopIndex = i;
                this.displayCurrentPages();
                this.adjustCurosrLocation(address);
                this.addressCombo.setText(address.toString());
                return true;
            }
            ++i;
        }
        this.currentStartAddress = oldStartAddress;
        return false;
    }

    private void adjustCurosrLocation(Address address) {
        int offsetSkip = 0;
        int lineNoSkip = 0;
        MiniDumpRecord record = null;
        int i = 0;
        while (i < 2) {
            if (address.getAddress31() < this.currentVisiblePages[i].getDDirMdAddr31() + 4096L) {
                record = this.currentVisiblePages[i];
                break;
            }
            offsetSkip += this.currentVisiblePages[i].getTotalLengthOfFormattedText();
            lineNoSkip += this.currentVisiblePages[i].getNumberOfLines();
            ++i;
        }
        int lineNumberWithinPage = record.getLineNumberForAddress(address.getAddress31());
        int offsetAtLineStart = this.dumpText.getOffsetAtLine(lineNoSkip + lineNumberWithinPage);
        int offsetWithinLine = record.getOffsetWithinLine(address.getAddress31());
        this.dumpText.setSelection(offsetAtLineStart + offsetWithinLine, offsetAtLineStart + offsetWithinLine + 2);
        this.dumpText.showSelection();
        this.dumpText.setFocus();
        this.setActivePage(0);
    }

    private void addStyleRanges() {
        int currentIndex = 0;
        ArrayList<StyleRange> list = new ArrayList<StyleRange>();
        int i = 0;
        while (i < 2) {
            currentIndex += MiniDumpFormatter.prepareStyleRange(this.currentVisiblePages[i].formatPage(this.getPriorPageAddress(new Address(this.currentVisiblePages[i].getDDirMdAddr64(), this.currentVisiblePages[i].getDDirMdAddr31())), this.currentStartAddress).toString(), currentIndex, list);
            ++i;
        }
        StyleRange[] styleRanges = new StyleRange[list.size()];
        int i2 = 0;
        while (i2 < styleRanges.length) {
            styleRanges[i2] = (StyleRange)list.get(i2);
            ++i2;
        }
        this.dumpText.setStyleRanges(styleRanges);
    }

    private Address getPriorPageAddress(Address currentAddr) {
        int priorIndex = 0;
        int i = 0;
        while (i < this.addresses.size()) {
            Address tmp = this.addresses.get(i);
            if (tmp.equals(currentAddr)) {
                return this.addresses.get(priorIndex);
            }
            priorIndex = i++;
        }
        System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ DID NOT FIND PRIOR ADDRESS RANGE FOR " + currentAddr.toString());
        return this.addresses.get(priorIndex);
    }

    public MiniDumpRecord readRecord(Address address) {
        return MiniDumpRecordReader.readPage(this.getFile().getLocation().toFile(), address, this.abendingASID);
    }

    private void createUserNoteMenu(Menu menu) {
        this.userNoteMenuItem = new MenuItem(menu, 8);
        this.userNoteMenuItem.setText(NLS.getString("DumpEditor.UserNoteAction"));
        this.userNoteMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                System.out.println("@@@ Caret is at " + DumpBrowser.this.dumpText.getCaretOffset());
                int charOffset = DumpBrowser.this.dumpText.getCaretOffset();
                int charSoFar = 0;
                MiniDumpRecord record = null;
                int i = 0;
                while (i < 2) {
                    if (charOffset < DumpBrowser.this.currentVisiblePages[i].getTotalLengthOfFormattedText() + charSoFar) {
                        record = DumpBrowser.this.currentVisiblePages[i];
                        break;
                    }
                    charSoFar += DumpBrowser.this.currentVisiblePages[i].getTotalLengthOfFormattedText();
                    ++i;
                }
                Address selectedAddr = record.getSelectedAddress(charOffset - charSoFar);
                if (selectedAddr != null) {
                    UserNoteEntry entry = DumpBrowser.this.userNotes.getUserNote(selectedAddr);
                    String currentData = entry != null ? entry.getNotes() : "";
                    UserNotePage page = new UserNotePage(Display.getCurrent().getActiveShell(), selectedAddr, currentData);
                    if (page.open() != 0) {
                        return;
                    }
                    if (entry == null) {
                        entry = new UserNoteEntry(selectedAddr, page.getUserNote());
                    } else {
                        entry.setNotes(page.getUserNote());
                    }
                    DumpBrowser.this.userNotes.insertUserNote(entry);
                    DumpBrowser.this.userNoteDisplayPage.displayUserNotes();
                    System.out.println("Done updating the page...");
                    try {
                        MiniDumpRecordReader.updateUserNotes(DumpBrowser.this.getFile().getLocation().toFile(), new File(String.valueOf(DumpBrowser.this.getFile().getLocation().toString()) + ".tmp"), DumpBrowser.this.userNotes);
                    }
                    catch (Exception e) {
                        FAPlugin.getDefault().log(4, NLS.getString("DumpEditor.UserNoteSaveFailure"), e, true);
                    }
                    System.out.println("Entered value is " + page.getUserNote());
                } else {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)NLS.getString("DumpEditor.InvalidUserNoteAddrTitle"), (String)NLS.getString("DumpEditor.InvalidUserNoteAddrMsg"));
                }
            }
        });
    }
}

