/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.dump.editor;

import com.ibm.etools.fa.common.Address;
import com.ibm.etools.fa.common.UserNoteEntry;
import com.ibm.etools.fa.common.UserNotes;
import com.ibm.etools.fa.dump.editor.DumpBrowser;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.util.NLS;
import java.util.ArrayList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class UserNoteDisplayPage
extends FormPage {
    private static final String ADDRESS_LOOKUP_HEADER = "addr:";
    private DumpBrowser browser;
    private UserNotes userNotes;
    private FormToolkit toolkit = null;
    private ScrolledForm form = null;
    private FormText formText = null;

    public UserNoteDisplayPage(DumpBrowser browser, UserNotes userNotes) {
        super((FormEditor)browser, UserNoteDisplayPage.class.getName(), NLS.getString("UserNote"));
        this.browser = browser;
        this.userNotes = userNotes;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.toolkit = managedForm.getToolkit();
        this.form = managedForm.getForm();
        this.form.getBody().setLayout((Layout)new GridLayout(1, false));
        this.formText = this.toolkit.createFormText(this.form.getBody(), true);
        this.formText.setLayoutData((Object)new TableWrapData(128));
        this.formText.setFont(JFaceResources.getFont((String)"com.ibm.etools.fa.defaultFont"));
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.formText.setLayoutData((Object)data);
        this.formText.setWhitespaceNormalized(false);
        this.formText.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                String url = e.getHref().toString();
                System.out.println("Activating " + url);
                if (url.startsWith(UserNoteDisplayPage.ADDRESS_LOOKUP_HEADER)) {
                    try {
                        long address = Long.parseLong(url.substring(UserNoteDisplayPage.ADDRESS_LOOKUP_HEADER.length(), url.length()).trim(), 16);
                        UserNoteDisplayPage.this.browser.moveToAddress(new Address(0L, address));
                    }
                    catch (Exception e1) {
                        FAPlugin.getDefault().log(1, NLS.getString("FAReportBrowser.ErrAddrDisp"), e1, false);
                        return;
                    }
                }
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        this.displayUserNotes();
    }

    public void displayUserNotes() {
        ArrayList entries = this.userNotes.getUserNotes();
        StringBuffer sb = new StringBuffer(100);
        sb.append("<form>\n");
        int i = 0;
        while (i < entries.size()) {
            UserNoteEntry entry = (UserNoteEntry)entries.get(i);
            sb.append("<li><A href=\"addr:" + entry.getAddress().toString() + "\">" + entry.getAddress().toString() + "</A></li>\n");
            sb.append("<p>" + entry.getNotes() + "</p>\n");
            ++i;
        }
        sb.append("</form>\n");
        if (this.formText != null) {
            this.formText.setText(sb.toString(), true, false);
            this.formText.redraw();
            this.form.redraw();
        }
    }
}

