/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.jobs;

import com.ibm.etools.fa.jobs.FAJob;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.subsystem.FASubSystem;
import com.ibm.etools.fa.util.EditorManagement;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.util.RSESystemManagement;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class DownlodReportJob
extends FAJob {
    private IFile reportFile = null;
    private String systemName = null;
    private String histFileName = null;
    private String faultID = null;
    private String projPath = null;

    public DownlodReportJob(String systemName, String histFileName, String faultID, IFile reportFile, String projPath) {
        this.systemName = systemName;
        this.histFileName = histFileName;
        this.faultID = faultID;
        this.reportFile = reportFile;
        this.projPath = projPath;
    }

    public void runJob() throws CoreException {
        Job browseReportJob = new Job(String.valueOf(NLS.getString("BrowseReportAction.JobTitle")) + " " + this.histFileName + "(" + this.faultID + ")"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("", 4);
                    FASubSystem faSubSystem = RSESystemManagement.getFASubSystem(DownlodReportJob.this.systemName);
                    if (faSubSystem == null) {
                        DownlodReportJob.this.openErrorThreadSafe(NLS.getString("HistoryFilesView.NoSystemTitle"), String.valueOf(NLS.getString("HistoryFilesView.NoSystemMsg")) + " " + DownlodReportJob.this.systemName);
                        DownlodReportJob.this.jobStatus = Status.OK_STATUS;
                        DownlodReportJob.this.jobSuccessful = false;
                        return Status.OK_STATUS;
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        DownlodReportJob.this.jobStatus = Status.CANCEL_STATUS;
                        DownlodReportJob.this.jobSuccessful = false;
                        return Status.CANCEL_STATUS;
                    }
                    if (!faSubSystem.readHistoryFileMemberReportOnly(DownlodReportJob.this.histFileName, DownlodReportJob.this.faultID, String.valueOf(FAPlugin.getDefault().getConfigProject().getLocation().toString()) + File.separator + DownlodReportJob.this.projPath, String.valueOf(DownlodReportJob.this.faultID) + ".far")) {
                        DownlodReportJob.this.openErrorThreadSafe(NLS.getString("ReadHistMemTitle"), NLS.getString("ReadHistMemMsg"));
                        DownlodReportJob.this.jobStatus = Status.OK_STATUS;
                        DownlodReportJob.this.jobSuccessful = false;
                        return Status.OK_STATUS;
                    }
                    DownlodReportJob.this.reportFile.refreshLocal(1, monitor);
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        DownlodReportJob.this.jobStatus = Status.CANCEL_STATUS;
                        DownlodReportJob.this.jobSuccessful = false;
                        return Status.CANCEL_STATUS;
                    }
                    EditorManagement em = new EditorManagement();
                    em.openEditorFromWorkerThread(DownlodReportJob.this.reportFile, monitor);
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        DownlodReportJob.this.jobStatus = Status.CANCEL_STATUS;
                        DownlodReportJob.this.jobSuccessful = false;
                        return Status.CANCEL_STATUS;
                    }
                    DownlodReportJob.this.jobStatus = Status.OK_STATUS;
                    DownlodReportJob.this.jobSuccessful = true;
                    return Status.OK_STATUS;
                }
                catch (Exception exception) {
                    DownlodReportJob.this.openErrorThreadSafe(NLS.getString("BrowseReportAction.FailureTitle"), NLS.getString("BrowseReportAction.FailureMsg"));
                    DownlodReportJob.this.jobStatus = Status.OK_STATUS;
                    DownlodReportJob.this.jobSuccessful = false;
                    return Status.OK_STATUS;
                }
            }
        };
        browseReportJob.setPriority(30);
        browseReportJob.setRule((ISchedulingRule)FAPlugin.getDefault().getConfigProject());
        browseReportJob.schedule();
    }
}

