/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.jobs;

import com.ibm.etools.fa.jobs.FAJob;
import com.ibm.etools.fa.langx.Langx;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.subsystem.FASubSystem;
import com.ibm.etools.fa.util.EditorManagement;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.util.RSESystemManagement;
import com.ibm.ftt.ui.os390editors.Os390SolutionsEditor;
import com.ibm.lpex.core.LpexView;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public class ProcessLangxFileJob
extends FAJob {
    private final String FA_TMP_DIRECTORY_NAME = "C:\\FA\\";
    private String systemName = null;
    private String langxDataSetName = null;
    private String langxMemberName = null;
    private int lineNo = -1;
    private IFile srcFile = null;

    public ProcessLangxFileJob(String systemName, String langxDataSetName, String langxMemberName, int lineNo, IFile srcFile) {
        this.systemName = systemName;
        this.langxDataSetName = langxDataSetName;
        this.langxMemberName = langxMemberName;
        this.lineNo = lineNo;
        this.srcFile = srcFile;
    }

    public void runJob() throws CoreException {
        Job processLangxJob = new Job(String.valueOf(NLS.getString("ProcessLangxFileJob.JobName")) + " " + this.langxDataSetName){

            private boolean checkFATmpDirectory() {
                try {
                    File dir = new File("C:\\FA\\");
                    if (!dir.exists()) {
                        return dir.mkdir();
                    }
                    return true;
                }
                catch (Exception e) {
                    FAPlugin.getDefault().log(4, NLS.getString("FAReportBrowser.FATmpDirErr"), e, true);
                    return false;
                }
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("", 2);
                    FASubSystem faSubSystem = RSESystemManagement.getFASubSystem(ProcessLangxFileJob.this.systemName);
                    if (faSubSystem == null) {
                        ProcessLangxFileJob.this.openErrorThreadSafe(NLS.getString("HistoryFilesView.NoSystemTitle"), String.valueOf(NLS.getString("HistoryFilesView.NoSystemMsg")) + " " + ProcessLangxFileJob.this.systemName);
                        ProcessLangxFileJob.this.jobStatus = Status.OK_STATUS;
                        ProcessLangxFileJob.this.jobSuccessful = false;
                        return Status.OK_STATUS;
                    }
                    monitor.worked(1);
                    if (!this.checkFATmpDirectory()) {
                        ProcessLangxFileJob.this.jobStatus = Status.OK_STATUS;
                        ProcessLangxFileJob.this.jobSuccessful = false;
                        return Status.OK_STATUS;
                    }
                    faSubSystem.readDataSetMember(ProcessLangxFileJob.this.langxDataSetName, "C:\\FA\\", String.valueOf(ProcessLangxFileJob.this.langxMemberName) + ".lx");
                    System.out.println("Finished reading...");
                    Langx langx = new Langx();
                    langx.parseLangx("C:\\FA\\" + ProcessLangxFileJob.this.langxMemberName + ".lx", ProcessLangxFileJob.this.srcFile.getLocation().toString(), "C:\\FA\\" + ProcessLangxFileJob.this.systemName + "-" + ProcessLangxFileJob.this.langxDataSetName + ".log");
                    ProcessLangxFileJob.this.srcFile.refreshLocal(0, monitor);
                    ProcessLangxFileJob.this.jobStatus = Status.OK_STATUS;
                    ProcessLangxFileJob.this.jobSuccessful = true;
                    monitor.worked(1);
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    ProcessLangxFileJob.this.openErrorThreadSafe(NLS.getString("ProcessLangxFileJob.ErrTitle"), NLS.getString("ProcessLangxFileJob.ErrMsg"));
                    FAPlugin.getDefault().log(4, NLS.getString("ProcessLangxFileJob.ErrMsg"), e, false);
                    ProcessLangxFileJob.this.jobStatus = Status.OK_STATUS;
                    ProcessLangxFileJob.this.jobSuccessful = false;
                    return Status.OK_STATUS;
                }
            }
        };
        processLangxJob.setPriority(30);
        processLangxJob.setRule((ISchedulingRule)FAPlugin.getDefault().getConfigProject());
        processLangxJob.addJobChangeListener(new IJobChangeListener(){

            public void done(IJobChangeEvent event) {
                if (ProcessLangxFileJob.this.jobSuccessful) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            try {
                                IEditorPart editor = EditorManagement.openEditor(ProcessLangxFileJob.this.srcFile);
                                if (editor instanceof Os390SolutionsEditor && ProcessLangxFileJob.this.lineNo != -1) {
                                    System.out.println("Moving to " + ProcessLangxFileJob.this.lineNo);
                                    LpexView view = ((Os390SolutionsEditor)editor).getActiveLpexView();
                                    view.doDefaultCommand("locate line " + ProcessLangxFileJob.this.lineNo);
                                }
                            }
                            catch (Exception exception) {
                                ProcessLangxFileJob.this.openErrorThreadSafe(NLS.getString("ProcessLangxFileJob.ErrTitle"), NLS.getString("ProcessLangxFileJob.ErrMsg"));
                                return;
                            }
                        }
                    });
                }
            }

            public void aboutToRun(IJobChangeEvent event) {
            }

            public void awake(IJobChangeEvent event) {
            }

            public void running(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void sleeping(IJobChangeEvent event) {
            }
        });
        processLangxJob.schedule();
    }
}

