/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.jobs;

import com.ibm.etools.fa.jobs.FAJob;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.subsystem.FASubSystem;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.util.RSESystemManagement;
import com.ibm.etools.fa.view.details.DetailedHistoryFileView;
import com.ibm.etools.fa.view.details.FAHistoryFileViewData;
import com.ibm.etools.fa.view.summary.HistoryFileElement;
import com.ibm.etools.fa.view.summary.HistoryFilesView;
import com.ibm.etools.fa.view.summary.ViewElement;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class RetrieveHistFileInfoForViewnJob
extends FAJob {
    private String systemAliasName = null;
    private ViewElement viewElement = null;
    private boolean retrieveAll = false;
    private ArrayList<HistoryFileElement> newHistFileElements;

    public RetrieveHistFileInfoForViewnJob(String systemAliasName, ViewElement viewElement, boolean retrieveAll) {
        this.systemAliasName = systemAliasName;
        this.viewElement = viewElement;
        this.retrieveAll = retrieveAll;
    }

    public void runJob() throws CoreException {
        System.out.println("RetrieveHistFileInfoForViewnJob running.....");
        this.newHistFileElements = new ArrayList();
        Job readHistFileJob = new Job(String.valueOf(NLS.getString("RetrieveHistFileInfoForViewnJob.JobName")) + " " + this.viewElement.getLabel()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(String.valueOf(NLS.getString("AddNewHistoryFileAction.JobName")) + " " + RetrieveHistFileInfoForViewnJob.this.viewElement.getLabel(), 1 + RetrieveHistFileInfoForViewnJob.this.viewElement.getViewInfo().getHistoryFiles().size());
                    FASubSystem faSubSystem = RSESystemManagement.getFASubSystem(RetrieveHistFileInfoForViewnJob.this.systemAliasName);
                    if (faSubSystem == null) {
                        RetrieveHistFileInfoForViewnJob.this.openErrorThreadSafe(NLS.getString("HistoryFilesView.NoSystemTitle"), String.valueOf(NLS.getString("HistoryFilesView.NoSystemMsg")) + " " + RetrieveHistFileInfoForViewnJob.this.systemAliasName);
                        RetrieveHistFileInfoForViewnJob.this.jobSuccessful = false;
                        RetrieveHistFileInfoForViewnJob.this.jobStatus = Status.OK_STATUS;
                        return Status.OK_STATUS;
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        RetrieveHistFileInfoForViewnJob.this.jobSuccessful = false;
                        RetrieveHistFileInfoForViewnJob.this.jobStatus = Status.CANCEL_STATUS;
                        return Status.CANCEL_STATUS;
                    }
                    int i = 0;
                    while (i < RetrieveHistFileInfoForViewnJob.this.viewElement.getViewInfo().getHistoryFiles().size()) {
                        IProject configProj = FAPlugin.getDefault().getConfigProject();
                        IFile localCacheFile = FAPlugin.getDefault().getFile(String.valueOf(RetrieveHistFileInfoForViewnJob.this.systemAliasName) + File.separator + RetrieveHistFileInfoForViewnJob.this.viewElement.getViewInfo().getHistoryFiles().get(i) + File.separator + "$$INDEX");
                        localCacheFile.refreshLocal(1, monitor);
                        final FAHistoryFileViewData histFileData = new FAHistoryFileViewData(RetrieveHistFileInfoForViewnJob.this.systemAliasName, (String)RetrieveHistFileInfoForViewnJob.this.viewElement.getViewInfo().getHistoryFiles().get(i), localCacheFile.getLocation().toString());
                        HistoryFileElement histFileElement = new HistoryFileElement((String)RetrieveHistFileInfoForViewnJob.this.viewElement.getViewInfo().getHistoryFiles().get(i), histFileData);
                        histFileElement = (HistoryFileElement)RetrieveHistFileInfoForViewnJob.this.viewElement.addIfNew(histFileElement);
                        if (!localCacheFile.exists() || localCacheFile.exists() && RetrieveHistFileInfoForViewnJob.this.retrieveAll) {
                            if (!faSubSystem.readHistoryFile((String)RetrieveHistFileInfoForViewnJob.this.viewElement.getViewInfo().getHistoryFiles().get(i), String.valueOf(configProj.getLocation().toString()) + File.separator + RetrieveHistFileInfoForViewnJob.this.systemAliasName + File.separator + RetrieveHistFileInfoForViewnJob.this.viewElement.getViewInfo().getHistoryFiles().get(i) + File.separator, "$$INDEX")) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    public void run() {
                                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell().getShell(), (String)NLS.getString("RetrieveHistFileInfoForViewnJob.ReadErrTitle"), (String)(String.valueOf(NLS.getString("RetrieveHistFileInfoForViewnJob.ReadErrMsg")) + " " + histFileData.getHistFileName()));
                                    }
                                });
                            } else {
                                localCacheFile.refreshLocal(1, monitor);
                                RetrieveHistFileInfoForViewnJob.this.newHistFileElements.add(histFileElement);
                                monitor.worked(1);
                                if (monitor.isCanceled()) {
                                    RetrieveHistFileInfoForViewnJob.this.jobSuccessful = false;
                                    RetrieveHistFileInfoForViewnJob.this.jobStatus = Status.CANCEL_STATUS;
                                    return Status.OK_STATUS;
                                }
                            }
                        } else {
                            RetrieveHistFileInfoForViewnJob.this.newHistFileElements.add(histFileElement);
                        }
                        ++i;
                    }
                    RetrieveHistFileInfoForViewnJob.this.jobSuccessful = true;
                    RetrieveHistFileInfoForViewnJob.this.jobStatus = Status.OK_STATUS;
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    RetrieveHistFileInfoForViewnJob.this.openErrorThreadSafe(NLS.getString("RetrieveHistFileInfoForViewnJob.ErrTitle"), NLS.getString("RetrieveHistFileInfoForViewnJob.ErrMsg"));
                    FAPlugin.getDefault().log(4, NLS.getString("RetrieveHistFileInfoForViewnJob.ErrMsg"), (Exception)((Object)e), false);
                    RetrieveHistFileInfoForViewnJob.this.jobSuccessful = false;
                    RetrieveHistFileInfoForViewnJob.this.jobStatus = Status.OK_STATUS;
                    return Status.OK_STATUS;
                }
            }
        };
        readHistFileJob.setPriority(30);
        readHistFileJob.setRule((ISchedulingRule)FAPlugin.getDefault().getConfigProject());
        readHistFileJob.addJobChangeListener(new IJobChangeListener(){

            public void running(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void sleeping(IJobChangeEvent event) {
            }

            public void aboutToRun(IJobChangeEvent event) {
            }

            public void awake(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                if (RetrieveHistFileInfoForViewnJob.this.jobSuccessful) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            try {
                                IWorkbenchPage activePage = FAPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                HistoryFilesView faView = (HistoryFilesView)activePage.findView("com.ibm.etools.fa.view.summary.HistoryFilesView");
                                faView.refresh();
                                activePage = FAPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                if (activePage.findView("com.ibm.etools.fa.view.details.DetailedHistoryFileView") != null) {
                                    DetailedHistoryFileView view = (DetailedHistoryFileView)activePage.showView("com.ibm.etools.fa.view.details.DetailedHistoryFileView");
                                    ArrayList<FAHistoryFileViewData> viewData = new ArrayList<FAHistoryFileViewData>();
                                    int i = 0;
                                    while (i < RetrieveHistFileInfoForViewnJob.this.newHistFileElements.size()) {
                                        viewData.add(((HistoryFileElement)RetrieveHistFileInfoForViewnJob.this.newHistFileElements.get(i)).getHistoryFileData());
                                        ++i;
                                    }
                                    view.populateTable(viewData, RetrieveHistFileInfoForViewnJob.this.viewElement.getLabel());
                                }
                            }
                            catch (Exception e) {
                                RetrieveHistFileInfoForViewnJob.this.openErrorThreadSafe(NLS.getString("RetrieveHistFileInfoForViewnJob.ErrPopulateViewTitle"), NLS.getString("RetrieveHistFileInfoForViewnJob.ErrPopulateViewMsg"));
                                FAPlugin.getDefault().log(4, NLS.getString("RetrieveHistFileInfoForViewnJob.ErrPopulateViewMsg"), e, false);
                                return;
                            }
                        }
                    });
                }
            }
        });
        readHistFileJob.schedule();
    }
}

