/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.jobs;

import com.ibm.etools.fa.jobs.FAJob;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.subsystem.FASubSystem;
import com.ibm.etools.fa.util.ISPFProfileInformation;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.util.RSESystemManagement;
import com.ibm.etools.fa.view.details.FAHistoryFileViewData;
import com.ibm.etools.fa.view.summary.HistoryFileElement;
import com.ibm.etools.fa.view.summary.HistoryFilesContainerElement;
import com.ibm.etools.fa.view.summary.HistoryFilesView;
import com.ibm.etools.fa.view.summary.SystemElement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;

public class RetrieveIspfProfileJob
extends FAJob {
    static final String FA_PROFILE_INFO_PREFIX = "FA-ISPFPROF";
    static final String FA_OLDHIST_INFO_PREFIX = "OLDHIST";
    static final String FA_OLDENT_INFO_PREFIX = "OLDENT";
    private String systemName = null;
    private SystemElement systemElement = null;
    private ISPFProfileInformation profInfo = null;
    private String localPath;
    private String localFileName;
    private String execName;
    private String ispfProfDsn;
    private String tmpDsn;
    private String appID;

    public RetrieveIspfProfileJob(String systemName, SystemElement systemElement, String localPath, String localFileName, String execName, String ispfProfDsn, String tmpDsn, String appID) {
        this.systemName = systemName;
        this.systemElement = systemElement;
        this.localPath = localPath;
        this.localFileName = localFileName;
        this.execName = execName;
        this.ispfProfDsn = ispfProfDsn;
        this.tmpDsn = tmpDsn;
        this.appID = appID;
    }

    public void runJob() throws CoreException {
        Job downloadFaultEntryJob = new Job(NLS.getString("RetrieveIspfProfileJob.name")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    FASubSystem faSubSystem;
                    monitor.beginTask("", 2);
                    File outputFile = new File(String.valueOf(RetrieveIspfProfileJob.this.localPath) + RetrieveIspfProfileJob.this.localFileName);
                    if (outputFile.exists()) {
                        ISPFProfileInformation iSPFProfileInformation = RetrieveIspfProfileJob.this.readISPFProfileInformation(outputFile);
                        RetrieveIspfProfileJob.this.profInfo = iSPFProfileInformation;
                        if (iSPFProfileInformation != null) {
                            RetrieveIspfProfileJob.this.jobStatus = Status.OK_STATUS;
                            RetrieveIspfProfileJob.this.jobSuccessful = true;
                            return Status.OK_STATUS;
                        }
                    }
                    if ((faSubSystem = RSESystemManagement.getFASubSystem(RetrieveIspfProfileJob.this.systemName)) == null) {
                        RetrieveIspfProfileJob.this.openErrorThreadSafe(NLS.getString("HistoryFilesView.NoSystemTitle"), String.valueOf(NLS.getString("HistoryFilesView.NoSystemMsg")) + " " + RetrieveIspfProfileJob.this.systemName);
                        RetrieveIspfProfileJob.this.jobStatus = Status.OK_STATUS;
                        RetrieveIspfProfileJob.this.jobSuccessful = false;
                        return Status.OK_STATUS;
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        RetrieveIspfProfileJob.this.jobStatus = Status.CANCEL_STATUS;
                        RetrieveIspfProfileJob.this.jobSuccessful = false;
                        return Status.CANCEL_STATUS;
                    }
                    if (!faSubSystem.readISPFProfile(RetrieveIspfProfileJob.this.localPath, RetrieveIspfProfileJob.this.localFileName, RetrieveIspfProfileJob.this.execName, RetrieveIspfProfileJob.this.ispfProfDsn, RetrieveIspfProfileJob.this.tmpDsn, RetrieveIspfProfileJob.this.appID)) {
                        RetrieveIspfProfileJob.this.openErrorThreadSafe(NLS.getString("RetrieveIspfProfileJobFailure.Title"), NLS.getString("RetrieveIspfProfileJobFailure.Msg"));
                        RetrieveIspfProfileJob.this.jobStatus = Status.OK_STATUS;
                        RetrieveIspfProfileJob.this.jobSuccessful = false;
                        return Status.OK_STATUS;
                    }
                    RetrieveIspfProfileJob.this.profInfo = RetrieveIspfProfileJob.this.readISPFProfileInformation(outputFile);
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        RetrieveIspfProfileJob.this.jobStatus = Status.CANCEL_STATUS;
                        RetrieveIspfProfileJob.this.jobSuccessful = false;
                        return Status.CANCEL_STATUS;
                    }
                    RetrieveIspfProfileJob.this.jobStatus = Status.OK_STATUS;
                    RetrieveIspfProfileJob.this.jobSuccessful = true;
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    RetrieveIspfProfileJob.this.openErrorThreadSafe(NLS.getString("RetrieveIspfProfileJobFailure.Title"), NLS.getString("RetrieveIspfProfileJobFailure.Msg"));
                    FAPlugin.getDefault().log(4, NLS.getString("RetrieveIspfProfileJobFailure.Msg"), e, false);
                    RetrieveIspfProfileJob.this.jobStatus = Status.OK_STATUS;
                    RetrieveIspfProfileJob.this.jobSuccessful = false;
                    return Status.OK_STATUS;
                }
            }
        };
        downloadFaultEntryJob.setPriority(30);
        downloadFaultEntryJob.setRule((ISchedulingRule)FAPlugin.getDefault().getConfigProject());
        downloadFaultEntryJob.addJobChangeListener(new IJobChangeListener(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if ((this).RetrieveIspfProfileJob.this.jobSuccessful) {
                            ArrayList<String> histFileNames = RetrieveIspfProfileJob.this.profInfo.getHistoryFiles();
                            int i = 0;
                            while (i < histFileNames.size()) {
                                System.out.println(String.valueOf(i) + ": " + histFileNames.get(i));
                                String histFileName = histFileNames.get(i);
                                try {
                                    HistoryFilesContainerElement histFileContainerEle = new HistoryFilesContainerElement();
                                    histFileContainerEle = (HistoryFilesContainerElement)RetrieveIspfProfileJob.this.systemElement.addIfNew(histFileContainerEle);
                                    IFile localCacheFile = FAPlugin.getDefault().getFile(String.valueOf(RetrieveIspfProfileJob.this.systemName) + File.separator + histFileName + File.separator + "$$INDEX");
                                    FAHistoryFileViewData histFileData = new FAHistoryFileViewData(RetrieveIspfProfileJob.this.systemName, histFileName, localCacheFile.getLocation().toString());
                                    HistoryFileElement histFileElement = new HistoryFileElement(histFileName, histFileData);
                                    histFileElement = (HistoryFileElement)histFileContainerEle.addIfNew(histFileElement);
                                    if (localCacheFile.exists()) {
                                        RetrieveIspfProfileJob.this.updateViews(histFileData, histFileElement);
                                    }
                                }
                                catch (Exception e) {
                                    FAPlugin.getDefault().log(2, NLS.getString("RetrieveIspfProfileJobFailure.Msg"), e, false);
                                }
                                ++i;
                            }
                            IWorkbenchPage activePage = FAPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            HistoryFilesView faView = (HistoryFilesView)activePage.findView("com.ibm.etools.fa.view.summary.HistoryFilesView");
                            faView.expand(RetrieveIspfProfileJob.this.systemElement, 2);
                            faView.refresh();
                            if (histFileNames.size() == 0) {
                                RetrieveIspfProfileJob.this.openInformationThreadSafe(NLS.getString("RetrieveIspfProfileJob.NoHistFileTitle"), String.valueOf(NLS.getString("RetrieveIspfProfileJob.NoHistFileMsg")) + " " + RetrieveIspfProfileJob.this.ispfProfDsn);
                            }
                            System.out.println("Just expanded!");
                        } else {
                            RetrieveIspfProfileJob.this.openInformationThreadSafe(NLS.getString("RetrieveIspfProfileJob.HistFileRetrieveErrTitle"), String.valueOf(NLS.getString("RetrieveIspfProfileJob.HistFileRetrieveErrMsg")) + " " + RetrieveIspfProfileJob.this.ispfProfDsn);
                        }
                    }
                });
            }

            public void aboutToRun(IJobChangeEvent event) {
            }

            public void awake(IJobChangeEvent event) {
            }

            public void running(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void sleeping(IJobChangeEvent event) {
            }
        });
        downloadFaultEntryJob.schedule();
    }

    private void updateViews(FAHistoryFileViewData data, HistoryFileElement histFileElement) throws Exception {
        IWorkbenchPage activePage = FAPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        HistoryFilesView faView = (HistoryFilesView)activePage.findView("com.ibm.etools.fa.view.summary.HistoryFilesView");
        faView.refresh();
    }

    /*
     * Loose catch block
     */
    private ISPFProfileInformation readISPFProfileInformation(File localFile) {
        ISPFProfileInformation iSPFProfileInformation;
        BufferedReader reader;
        block25: {
            ISPFProfileInformation info = new ISPFProfileInformation();
            reader = null;
            reader = new BufferedReader(new FileReader(localFile));
            String line = reader.readLine().trim();
            while (line != null) {
                if ((line = line.trim()).startsWith(FA_PROFILE_INFO_PREFIX)) {
                    if (line.indexOf(FA_OLDHIST_INFO_PREFIX) != -1) {
                        System.out.println("OLDHIST line [" + line + "]");
                        try {
                            line = line.substring(line.indexOf(91) + 1, line.lastIndexOf(93));
                            if (line.charAt(0) != '(' && line.indexOf("'") != -1) {
                                String histFileName = line.substring(line.indexOf("'") + 1, line.lastIndexOf("'"));
                                System.out.println("Adding [" + histFileName + "]");
                                info.addHistoryFile(histFileName);
                            }
                        }
                        catch (Exception exception) {}
                    } else if (line.indexOf(FA_OLDENT_INFO_PREFIX) != -1) {
                        System.out.println("OLDENT line [" + line + "]");
                        try {
                            if (line.indexOf("'") != -1) {
                                String faultEntryName = line.substring(line.indexOf("'") + 1, line.lastIndexOf("'"));
                                System.out.println("Adding [" + faultEntryName + "]");
                                info.addFualtEntry(faultEntryName);
                            }
                        }
                        catch (Exception exception) {}
                    } else {
                        System.out.println("FA line, but Not interested in [" + line + "]");
                    }
                } else {
                    System.out.println("Not interested in [" + line + "]");
                }
                line = reader.readLine();
            }
            iSPFProfileInformation = info;
            if (reader == null) break block25;
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return iSPFProfileInformation;
        catch (Exception e) {
            block26: {
                try {
                    FAPlugin.getDefault().log(4, NLS.getString("RetrieveIspfProfileJobFailure.Msg"), e, true);
                    if (reader == null) break block26;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            return null;
        }
    }
}

