/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pages;

import com.ibm.etools.fa.util.GUIUtility;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.view.details.ColumnConfigurationData;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HistoryFileColumnSelectionPage
extends TitleAreaDialog {
    private boolean cancelButtonPressed = false;
    private ColumnConfigurationData configData;
    private List notDisplayList;
    private List displayList;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private Button addAllButton;
    private Button removeAllButton;
    private Button defaultButton;
    private Text configurationDataName;
    private String configurationDataNameValue;

    public HistoryFileColumnSelectionPage(Shell parentShell, ColumnConfigurationData data) {
        super(parentShell);
        this.configData = data;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(NLS.getString("HistoryFileColumnSelectionPage.Title"));
        this.setMessage(NLS.getString("HistoryFileColumnSelectionPage.Msg"));
        Composite mainComposite = GUIUtility.createComposite(parent, 1);
        this.createConfigNameComposite(mainComposite);
        Composite bodyComposite = GUIUtility.createComposite(mainComposite, 4);
        this.createNotInDisplayList(bodyComposite);
        this.createAddRemoveButtons(bodyComposite);
        this.createInDisplayList(bodyComposite);
        this.createOrderButtons(bodyComposite);
        return mainComposite;
    }

    private void createConfigNameComposite(Composite parent) {
        Composite nameComposite = GUIUtility.createComposite(parent, 2);
        GUIUtility.createLabel(nameComposite, NLS.getString("HistoryFileColumnSelectionPage.ConfigName"), 1);
        this.configurationDataName = GUIUtility.createTextField(nameComposite);
        this.configurationDataName.setText(this.configData.getConfigDataName());
    }

    private void createNotInDisplayList(Composite parent) {
        Composite composite = GUIUtility.createComposite(parent, 1);
        GUIUtility.createLabel(composite, NLS.getString("HistoryFileColumnSelectionPage.NotUsedColumnDesc"), 1);
        this.notDisplayList = new List(composite, 832);
        GridData data = new GridData(768);
        data.heightHint = this.notDisplayList.getFont().getFontData()[0].getHeight() * 30;
        data.widthHint = this.notDisplayList.getFont().getFontData()[0].getHeight() * 20;
        this.notDisplayList.setLayoutData((Object)data);
        ArrayList<String> list = this.configData.getNonDisplayColumnNames();
        int i = 0;
        while (i < list.size()) {
            this.sortedInsert(this.notDisplayList, list.get(i));
            ++i;
        }
        this.notDisplayList.redraw();
        ListViewer viewer = new ListViewer(this.notDisplayList);
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                HistoryFileColumnSelectionPage.this.addItemAction();
            }
        });
    }

    private void addItemAction() {
        int selectionIndex = this.notDisplayList.getSelectionIndex();
        if (selectionIndex == -1) {
            return;
        }
        String item = this.notDisplayList.getItem(selectionIndex);
        this.notDisplayList.remove(selectionIndex);
        if (this.notDisplayList.getItemCount() > 0) {
            if (selectionIndex == this.notDisplayList.getItemCount()) {
                --selectionIndex;
            }
            if (selectionIndex < 0) {
                selectionIndex = 0;
            }
            this.notDisplayList.setSelection(selectionIndex);
        }
        this.notDisplayList.redraw();
        this.displayList.add(item);
        this.displayList.redraw();
    }

    private void removeItemAction() {
        int selectionIndex = this.displayList.getSelectionIndex();
        if (selectionIndex == -1) {
            return;
        }
        String item = this.displayList.getItem(selectionIndex);
        this.displayList.remove(selectionIndex);
        if (this.displayList.getItemCount() > 0) {
            if (selectionIndex == this.displayList.getItemCount()) {
                --selectionIndex;
            }
            if (selectionIndex < 0) {
                selectionIndex = 0;
            }
            this.displayList.setSelection(selectionIndex);
        }
        this.displayList.redraw();
        this.sortedInsert(this.notDisplayList, item);
        this.notDisplayList.redraw();
    }

    private void createAddRemoveButtons(Composite parent) {
        Composite composite = GUIUtility.createComposite(parent, 1);
        GridData buttonData = new GridData();
        buttonData.heightHint = 25;
        buttonData.widthHint = 70;
        this.addButton = new Button(composite, 8);
        this.addButton.setText(NLS.getString("Add"));
        this.addButton.setLayoutData((Object)buttonData);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HistoryFileColumnSelectionPage.this.addItemAction();
            }
        });
        this.addAllButton = new Button(composite, 8);
        this.addAllButton.setText(NLS.getString("AddAll"));
        this.addAllButton.setLayoutData((Object)buttonData);
        this.addAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < HistoryFileColumnSelectionPage.this.notDisplayList.getItemCount()) {
                    String item = HistoryFileColumnSelectionPage.this.notDisplayList.getItem(i);
                    HistoryFileColumnSelectionPage.this.displayList.add(item);
                    ++i;
                }
                HistoryFileColumnSelectionPage.this.notDisplayList.removeAll();
                HistoryFileColumnSelectionPage.this.notDisplayList.redraw();
                HistoryFileColumnSelectionPage.this.displayList.setSelection(0);
            }
        });
        GUIUtility.createLabel(composite, "", 1);
        this.removeButton = new Button(composite, 8);
        this.removeButton.setText(NLS.getString("Remove"));
        this.removeButton.setLayoutData((Object)buttonData);
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HistoryFileColumnSelectionPage.this.removeItemAction();
            }
        });
        this.removeAllButton = new Button(composite, 8);
        this.removeAllButton.setText(NLS.getString("RemoveAll"));
        this.removeAllButton.setLayoutData((Object)buttonData);
        this.removeAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < HistoryFileColumnSelectionPage.this.displayList.getItemCount()) {
                    String item = HistoryFileColumnSelectionPage.this.displayList.getItem(i);
                    HistoryFileColumnSelectionPage.this.sortedInsert(HistoryFileColumnSelectionPage.this.notDisplayList, item);
                    ++i;
                }
                HistoryFileColumnSelectionPage.this.displayList.removeAll();
                HistoryFileColumnSelectionPage.this.displayList.redraw();
                HistoryFileColumnSelectionPage.this.notDisplayList.redraw();
                HistoryFileColumnSelectionPage.this.notDisplayList.setSelection(0);
            }
        });
        GUIUtility.createLabel(composite, "", 1);
        this.defaultButton = new Button(composite, 8);
        this.defaultButton.setText(NLS.getString("Default"));
        this.defaultButton.setLayoutData((Object)buttonData);
        this.defaultButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HistoryFileColumnSelectionPage.this.configData.setDefaults();
                HistoryFileColumnSelectionPage.this.displayList.removeAll();
                HistoryFileColumnSelectionPage.this.notDisplayList.removeAll();
                ArrayList<String> list = HistoryFileColumnSelectionPage.this.configData.getDisplayColumnNames();
                int i = 0;
                while (i < list.size()) {
                    HistoryFileColumnSelectionPage.this.displayList.add(list.get(i));
                    ++i;
                }
                HistoryFileColumnSelectionPage.this.displayList.redraw();
                list = HistoryFileColumnSelectionPage.this.configData.getNonDisplayColumnNames();
                i = 0;
                while (i < list.size()) {
                    HistoryFileColumnSelectionPage.this.sortedInsert(HistoryFileColumnSelectionPage.this.notDisplayList, list.get(i));
                    ++i;
                }
                HistoryFileColumnSelectionPage.this.notDisplayList.redraw();
            }
        });
    }

    private void createInDisplayList(Composite parent) {
        Composite composite = GUIUtility.createComposite(parent, 1);
        GUIUtility.createLabel(composite, NLS.getString("HistoryFileColumnSelectionPage.UsedColumnDesc"), 1);
        this.displayList = new List(composite, 832);
        GridData data = new GridData(768);
        data.heightHint = this.displayList.getFont().getFontData()[0].getHeight() * 30;
        data.widthHint = this.displayList.getFont().getFontData()[0].getHeight() * 20;
        this.displayList.setLayoutData((Object)data);
        ArrayList<String> list = this.configData.getDisplayColumnNames();
        int i = 0;
        while (i < list.size()) {
            this.displayList.add(list.get(i));
            ++i;
        }
        this.displayList.redraw();
        ListViewer viewer = new ListViewer(this.displayList);
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                HistoryFileColumnSelectionPage.this.removeItemAction();
            }
        });
    }

    private void createOrderButtons(Composite parent) {
        Composite composite = GUIUtility.createComposite(parent, 1);
        GridData buttonData = new GridData();
        buttonData.heightHint = 25;
        buttonData.widthHint = 70;
        this.upButton = new Button(composite, 8);
        this.upButton.setText(NLS.getString("Up"));
        this.upButton.setLayoutData((Object)buttonData);
        this.upButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = HistoryFileColumnSelectionPage.this.displayList.getSelectionIndex();
                if (selectionIndex == -1) {
                    return;
                }
                String item = HistoryFileColumnSelectionPage.this.displayList.getItem(selectionIndex);
                HistoryFileColumnSelectionPage.this.displayList.remove(selectionIndex);
                if (--selectionIndex < 0) {
                    selectionIndex = 0;
                }
                HistoryFileColumnSelectionPage.this.displayList.add(item, selectionIndex);
                HistoryFileColumnSelectionPage.this.displayList.setSelection(selectionIndex);
                HistoryFileColumnSelectionPage.this.displayList.redraw();
            }
        });
        this.downButton = new Button(composite, 8);
        this.downButton.setText(NLS.getString("Down"));
        this.downButton.setLayoutData((Object)buttonData);
        this.downButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = HistoryFileColumnSelectionPage.this.displayList.getSelectionIndex();
                if (selectionIndex == -1) {
                    return;
                }
                String item = HistoryFileColumnSelectionPage.this.displayList.getItem(selectionIndex);
                HistoryFileColumnSelectionPage.this.displayList.remove(selectionIndex);
                if (++selectionIndex > HistoryFileColumnSelectionPage.this.displayList.getItemCount()) {
                    selectionIndex = HistoryFileColumnSelectionPage.this.displayList.getItemCount();
                }
                HistoryFileColumnSelectionPage.this.displayList.add(item, selectionIndex);
                HistoryFileColumnSelectionPage.this.displayList.setSelection(selectionIndex);
                HistoryFileColumnSelectionPage.this.displayList.redraw();
            }
        });
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected void cancelPressed() {
        this.cancelButtonPressed = true;
        super.cancelPressed();
    }

    public boolean close() {
        if (this.cancelButtonPressed) {
            return super.close();
        }
        if (!this.validateHeadings()) {
            return false;
        }
        if (!this.validateConfigurationDataName()) {
            return false;
        }
        String[] items = this.displayList.getItems();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < items.length) {
            list.add(items[i]);
            ++i;
        }
        this.configData.setNewColumns(list);
        this.configData.setConfigDataName(this.configurationDataNameValue);
        return super.close();
    }

    private boolean validateHeadings() {
        if (this.displayList.getItemCount() == 0) {
            this.setMessage(NLS.getString("HistoryFileColumnSelectionPage.NoCols"), 3);
            return false;
        }
        return true;
    }

    private boolean validateConfigurationDataName() {
        String value = this.configurationDataName.getText().trim();
        if (value.length() == 0) {
            this.setMessage(NLS.getString("HistoryFileColumnSelectionPage.NoConfigName"), 3);
            return false;
        }
        this.configurationDataNameValue = value;
        return true;
    }

    public ColumnConfigurationData getNewColumnConfiguration() {
        return this.configData;
    }

    public String getColumnConfigurationName() {
        return this.configurationDataNameValue;
    }

    private void sortedInsert(List list, String newItem) {
        int i = 0;
        while (i < list.getItemCount()) {
            String currentItem = list.getItem(i);
            if (currentItem.compareTo(newItem) > 0) {
                list.add(newItem, i);
                return;
            }
            ++i;
        }
        list.add(newItem);
    }
}

