/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.report.editor;

import com.ibm.etools.fa.common.XMSegmentElement;
import com.ibm.etools.fa.report.editor.FAReportBrowser;
import com.ibm.etools.fa.util.NLS;
import java.util.ArrayList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class MainReportPage
extends FormPage {
    private XMSegmentElement rootElement;
    private XMSegmentElement abendJobElement = null;
    private ArrayList<XMSegmentElement> eventNumberElements = new ArrayList();
    private XMSegmentElement eventSummaryElement = null;
    private XMSegmentElement summaryElement = null;
    private XMSegmentElement synopsisElement = null;
    private FormToolkit toolkit = null;
    private ScrolledForm form = null;

    public MainReportPage(FormEditor editor, XMSegmentElement xmSegmentElement) {
        super(editor, MainReportPage.class.getName(), NLS.getString("MainReportPage.Title"));
        this.rootElement = xmSegmentElement;
    }

    private void initXMElements() {
        if (this.abendJobElement == null) {
            this.abendJobElement = new XMSegmentElement();
            this.abendJobElement.appendContent(NLS.getString("n/a"));
        }
        if (this.eventSummaryElement == null) {
            this.eventSummaryElement = new XMSegmentElement();
            this.eventSummaryElement.appendContent(NLS.getString("n/a"));
        }
        if (this.summaryElement == null) {
            this.summaryElement = new XMSegmentElement();
            this.summaryElement.appendContent(NLS.getString("n/a"));
        }
        if (this.synopsisElement == null) {
            this.synopsisElement = new XMSegmentElement();
            this.synopsisElement.appendContent(NLS.getString("n/a"));
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.searchRequiredElement(this.rootElement);
        this.initXMElements();
        this.toolkit = managedForm.getToolkit();
        this.form = managedForm.getForm();
        TableWrapLayout layout = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)layout);
        ((FAReportBrowser)this.getEditor()).createBrowseDumpHyperLink(this.form.getBody(), this.toolkit);
        ((FAReportBrowser)this.getEditor()).createRichTextFormSectionWithoutExpansion(this.form.getBody(), NLS.getString("MainReportPage.SummaryTitle"), NLS.getString("MainReportPage.SummaryDesc"), this.summaryElement.getContents().toString(), this.toolkit);
        ((FAReportBrowser)this.getEditor()).createRichTextFormSectionWithoutExpansion(this.form.getBody(), NLS.getString("MainReportPage.SynopsisTitle"), NLS.getString("MainReportPage.SynopsisDesc"), this.synopsisElement.getContents().toString(), this.toolkit);
        this.createEventComposite(this.form.getBody());
        ((FAReportBrowser)this.getEditor()).createRichTextFormSection(this.form.getBody(), NLS.getString("MainReportPage.AbendJobTitle"), NLS.getString("MainReportPage.AbendJobDesc"), this.abendJobElement.getContents().toString(), false, this.toolkit, this.form);
        this.toolkit.paintBordersFor(this.form.getBody());
    }

    private void createEventComposite(Composite parent) {
        Section section = this.toolkit.createSection(parent, 384);
        section.setActiveToggleColor(this.toolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(this.toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        this.toolkit.createCompositeSeparator((Composite)section);
        section.setText(NLS.getString("MainReportPage.EventSummaryTitle"));
        section.setDescription(NLS.getString("MainReportPage.EventSummaryDesc"));
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite eventComposite = this.toolkit.createComposite((Composite)section);
        eventComposite.setLayout((Layout)new TableWrapLayout());
        section.setClient((Control)eventComposite);
        Label eventSummaryLabel = this.toolkit.createLabel(eventComposite, this.eventSummaryElement.getContents().toString(), 64);
        eventSummaryLabel.setFont(JFaceResources.getFont((String)"com.ibm.etools.fa.defaultFont"));
        int i = 0;
        while (i < this.eventNumberElements.size()) {
            XMSegmentElement anEvent = this.eventNumberElements.get(i);
            if (anEvent.getContents().indexOf("P O I N T   O F   F A I L U R E") != -1) {
                ((FAReportBrowser)this.getEditor()).createExpandableWithRichText(eventComposite, String.valueOf(NLS.getString("Event")) + " " + (i + 1), anEvent.getContents().toString(), true, this.toolkit, this.form, Display.getDefault().getSystemColor(3));
            } else {
                ((FAReportBrowser)this.getEditor()).createExpandableWithRichText(eventComposite, String.valueOf(NLS.getString("Event")) + " " + (i + 1), anEvent.getContents().toString(), false, this.toolkit, this.form, null);
            }
            ++i;
        }
    }

    private void searchRequiredElement(XMSegmentElement root) {
        if (root.getStartTag().startsWith("<AbendJobInfo")) {
            this.abendJobElement = root;
        } else if (root.getStartTag().startsWith("<Event number")) {
            this.eventNumberElements.add(root);
        } else if (root.getStartTag().startsWith("<EventSummary")) {
            this.eventSummaryElement = root;
        } else if (root.getStartTag().startsWith("<Summary")) {
            this.summaryElement = root;
        } else if (root.getStartTag().startsWith("<Synopsis")) {
            this.synopsisElement = root;
        }
        ArrayList children = root.getChildren();
        int i = 0;
        while (i < children.size()) {
            this.searchRequiredElement((XMSegmentElement)children.get(i));
            ++i;
        }
    }
}

