/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class EditorManagement {
    private IEditorPart editorUsed;

    public IEditorPart openEditorFromWorkerThread(final IFile file, final IProgressMonitor monitor) {
        this.editorUsed = null;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    file.refreshLocal(1, monitor);
                    String editorID = "org.eclipse.ui.DefaultTextEditor";
                    IEditorDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
                    if (descriptor != null) {
                        editorID = descriptor.getId();
                    }
                    EditorManagement.this.editorUsed = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(file), editorID);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return this.editorUsed;
    }

    public static IEditorPart openEditor(IFile file) throws CoreException {
        file.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        String editorID = "org.eclipse.ui.DefaultTextEditor";
        IEditorDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        if (descriptor != null) {
            editorID = descriptor.getId();
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(file), editorID);
    }

    public static void closeEditor(IFile file) throws CoreException {
        file.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)new FileEditorInput(file));
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editor, true);
    }
}

