/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.util;

import com.ibm.etools.fa.common.HistoryIndexFileEntry;
import com.ibm.etools.fa.util.NLS;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.TimeZone;

public class HistoryIndexFileEntryFormatter {
    public static String DDirHdAbend(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        byte format = entry.DDirHdAbendFormat();
        if (format == 1) {
            int i = HistoryIndexFileEntryFormatter.parseSignedInt(entry.getHistoryIndexFileEntryRawData(), 156);
            if ((i >>>= 20) != 0) {
                Formatter formatter = new Formatter(new StringBuffer());
                formatter.format("S%03X", i);
                return formatter.toString().toUpperCase();
            }
            i = HistoryIndexFileEntryFormatter.parseSignedInt(entry.getHistoryIndexFileEntryRawData(), 156);
            Formatter formatter = new Formatter(new StringBuffer());
            formatter.format("U%04d", i >>>= 8);
            return formatter.toString().toUpperCase();
        }
        if (format == 2) {
            return HistoryIndexFileEntryFormatter.removeZeros(new String(entry.getHistoryIndexFileEntryRawData(), 156, 4, "Cp1047")).toUpperCase();
        }
        if (format == 3) {
            String prefix = HistoryIndexFileEntryFormatter.removeZeros(new String(entry.getHistoryIndexFileEntryRawData(), 156, 2, "Cp1047"));
            short i = HistoryIndexFileEntryFormatter.parseSignedShort(entry.getHistoryIndexFileEntryRawData(), 158);
            Formatter formatter = new Formatter(new StringBuffer());
            formatter.format("%2S%04d", prefix, i);
            return formatter.toString().toUpperCase();
        }
        if (format == 4) {
            return HistoryIndexFileEntryFormatter.removeZeros(new String(entry.getHistoryIndexFileEntryRawData(), 156, 4, "Cp1047")).toUpperCase();
        }
        return NLS.getString("n/a");
    }

    public static String DDirHdIAbend(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        byte format = entry.DDirHdIAbendFormat();
        if (format == 1) {
            int i = HistoryIndexFileEntryFormatter.parseSignedInt(entry.getHistoryIndexFileEntryRawData(), 308);
            if ((i >>>= 20) != 0) {
                Formatter formatter = new Formatter(new StringBuffer());
                formatter.format("S%03X", i);
                return formatter.toString().toUpperCase();
            }
            i = HistoryIndexFileEntryFormatter.parseSignedInt(entry.getHistoryIndexFileEntryRawData(), 308);
            Formatter formatter = new Formatter(new StringBuffer());
            formatter.format("U%04d", i >>>= 8);
            return formatter.toString().toUpperCase();
        }
        if (format == 2) {
            return HistoryIndexFileEntryFormatter.removeZeros(new String(entry.getHistoryIndexFileEntryRawData(), 308, 4, "Cp1047")).toUpperCase();
        }
        if (format == 3) {
            String prefix = HistoryIndexFileEntryFormatter.removeZeros(new String(entry.getHistoryIndexFileEntryRawData(), 308, 2, "Cp1047"));
            short i = HistoryIndexFileEntryFormatter.parseSignedShort(entry.getHistoryIndexFileEntryRawData(), 310);
            Formatter formatter = new Formatter(new StringBuffer());
            formatter.format("%2S%04d", prefix, i);
            return formatter.toString().toUpperCase();
        }
        if (format == 4) {
            return HistoryIndexFileEntryFormatter.removeZeros(new String(entry.getHistoryIndexFileEntryRawData(), 308, 4, "Cp1047")).toUpperCase();
        }
        return NLS.getString("n/a");
    }

    public static String Sys_Job(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        if ((entry.DDirHdJType() & 0xF) == 8) {
            if (entry.DDirHdJobname().length() == 0) {
                return NLS.getString("n/a");
            }
            return entry.DDirHdJobname();
        }
        if (entry.DDirHdTsName().length() == 0) {
            return NLS.getString("n/a");
        }
        return entry.DDirHdTsName();
    }

    public static String CICS_Trn(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        if ((entry.DDirHdJType() & 0xF) == 8) {
            if (entry.DDirHdTranID().length() == 0) {
                return NLS.getString("n/a");
            }
            return entry.DDirHdTranID();
        }
        return NLS.getString("n/a");
    }

    public static String Task(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        if ((entry.DDirHdJType() & 0xF) == 8) {
            if (entry.DDirHdTranNo().length() == 0) {
                return NLS.getString("n/a");
            }
            return entry.DDirHdTranNo();
        }
        return NLS.getString("n/a");
    }

    public static String Job_Tran(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        if ((entry.DDirHdJType() & 0xF) == 8) {
            if (entry.DDirHdTranID().length() == 0) {
                return NLS.getString("n/a");
            }
            return entry.DDirHdTranID();
        }
        if (entry.DDirHdJobname().length() == 0) {
            return NLS.getString("n/a");
        }
        return entry.DDirHdJobname();
    }

    public static String MVS_Dump(HistoryIndexFileEntry entry) {
        if ((entry.DDirHdJType() & 0xF) == 8) {
            System.out.println("MVS_Dump: returning No 1: DDirHdJType = " + entry.DDirHdJType());
            return NLS.getString("No");
        }
        if (entry.DDirHdDSNf() == 255) {
            System.out.println("MVS_Dump: returning No 2: DDirHdDSNF = " + entry.DDirHdDSNf());
            return NLS.getString("No");
        }
        if (entry.DDirHdDSN_Off() != 0 && entry.DDirHdDSNf() != 2) {
            System.out.println("MVS_Dump: returning Yes: DDirHdDSN_off = " + entry.DDirHdDSN_Off() + " DDirHdDSNf = " + entry.DDirHdDSNf());
            return NLS.getString("Yes");
        }
        System.out.println("MVS_Dump: returning No 3");
        return NLS.getString("No");
    }

    public static String Stepname(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        if ((entry.DDirHdJType() & 0xF) == 8) {
            return NLS.getString("n/a");
        }
        if (entry.DDirHdStepname().length() == 0) {
            return NLS.getString("n/a");
        }
        return entry.DDirHdStepname();
    }

    public static String Job_Type(HistoryIndexFileEntry entry) {
        if ((entry.DDirHdJType() & 0xF) == 8) {
            return "CICS";
        }
        byte type = entry.DDirHdType();
        if (type == 1 && (entry.DDirHdTOC() & 0x80) == 0) {
            return "DumpReg";
        }
        if ((type & 0xF) == 4) {
            return "CICSsys";
        }
        if ((type & 0xF0) == 128) {
            return "Batch";
        }
        if ((type & 0xF0) == 64) {
            return "STC";
        }
        if ((type & 0xF0) == 32) {
            return "TSO";
        }
        return NLS.getString("n/a");
    }

    public static String Term_ID(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        if ((entry.DDirHdJType() & 0xF) == 8) {
            if (entry.DDirHdTermId().length() == 0) {
                return NLS.getString("n/a");
            }
            return entry.DDirHdTermId();
        }
        return NLS.getString("n/a");
    }

    public static String Netname(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        if ((entry.DDirHdJType() & 0xF) == 8) {
            if (entry.DDirHdNetName().length() == 0) {
                return NLS.getString("n/a");
            }
            return entry.DDirHdNetName();
        }
        return NLS.getString("n/a");
    }

    public static String Fault_ID(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        String value = entry.DDirHdCFaultID().trim();
        return value.length() == 0 ? NLS.getString("n/a") : value;
    }

    public static String User_ID(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        String value = entry.DDirHdUid().trim();
        return value.length() == 0 ? NLS.getString("n/a") : value;
    }

    public static String Abend(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        String value = HistoryIndexFileEntryFormatter.DDirHdAbend(entry);
        return value.length() == 0 ? NLS.getString("n/a") : value;
    }

    public static String Date(HistoryIndexFileEntry entry) {
        byte[] clockData = entry.DDirHdClock();
        if (HistoryIndexFileEntryFormatter.allZeros(clockData)) {
            return NLS.getString("n/a");
        }
        long start1970 = Long.parseLong("7D91048BCA000", 16);
        Formatter formatter = new Formatter(new StringBuffer());
        formatter.format("%02X%02X%02X%02X%02X%02X%02X%02X", clockData[0], clockData[1], clockData[2], clockData[3], clockData[4], clockData[5], clockData[6], clockData[7]);
        String hexValue = formatter.toString();
        hexValue = hexValue.substring(0, 13);
        long value = Long.parseLong(hexValue, 16);
        long diff = value - start1970;
        Date date = new Date((diff /= 1000000L) * 1000L);
        DateFormat dateFormat = DateFormat.getDateInstance(1);
        TimeZone tz = TimeZone.getTimeZone("GMT");
        dateFormat.setTimeZone(tz);
        return dateFormat.format(date);
    }

    public static String Time(HistoryIndexFileEntry entry) {
        byte[] clockData = entry.DDirHdClock();
        if (HistoryIndexFileEntryFormatter.allZeros(clockData)) {
            return NLS.getString("n/a");
        }
        long start1970 = Long.parseLong("7D91048BCA000", 16);
        Formatter formatter = new Formatter(new StringBuffer());
        formatter.format("%02X%02X%02X%02X%02X%02X%02X%02X", clockData[0], clockData[1], clockData[2], clockData[3], clockData[4], clockData[5], clockData[6], clockData[7]);
        String hexValue = formatter.toString();
        hexValue = hexValue.substring(0, 13);
        long value = Long.parseLong(hexValue, 16);
        long diff = value - start1970;
        Date date = new Date((diff /= 1000000L) * 1000L);
        DateFormat timeFormat = DateFormat.getTimeInstance(1);
        TimeZone tz = TimeZone.getTimeZone("GMT");
        timeFormat.setTimeZone(tz);
        return timeFormat.format(date);
    }

    public static String Appl_ID(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        String value = entry.DDirHdApplID().trim();
        return value.length() == 0 ? NLS.getString("n/a") : value;
    }

    public static String Class(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        String value = entry.DDirHdJClass().trim();
        return value.length() == 0 ? NLS.getString("n/a") : value;
    }

    public static String Dup_Date(HistoryIndexFileEntry entry) {
        byte[] clockData = entry.DDirHdDupClock();
        if (HistoryIndexFileEntryFormatter.allZeros(clockData)) {
            return NLS.getString("n/a");
        }
        long start1970 = Long.parseLong("7D91048BCA000", 16);
        Formatter formatter = new Formatter(new StringBuffer());
        formatter.format("%02X%02X%02X%02X%02X%02X%02X%02X", clockData[0], clockData[1], clockData[2], clockData[3], clockData[4], clockData[5], clockData[6], clockData[7]);
        String hexValue = formatter.toString();
        hexValue = hexValue.substring(0, 13);
        long value = Long.parseLong(hexValue, 16);
        long diff = value - start1970;
        Date date = new Date((diff /= 1000000L) * 1000L);
        DateFormat dateFormat = DateFormat.getDateInstance(1);
        TimeZone tz = TimeZone.getTimeZone("GMT");
        dateFormat.setTimeZone(tz);
        return dateFormat.format(date);
    }

    public static String Dup_Time(HistoryIndexFileEntry entry) {
        byte[] clockData = entry.DDirHdDupClock();
        if (HistoryIndexFileEntryFormatter.allZeros(clockData)) {
            return NLS.getString("n/a");
        }
        long start1970 = Long.parseLong("7D91048BCA000", 16);
        Formatter formatter = new Formatter(new StringBuffer());
        formatter.format("%02X%02X%02X%02X%02X%02X%02X%02X", clockData[0], clockData[1], clockData[2], clockData[3], clockData[4], clockData[5], clockData[6], clockData[7]);
        String hexValue = formatter.toString();
        hexValue = hexValue.substring(0, 13);
        long value = Long.parseLong(hexValue, 16);
        long diff = value - start1970;
        Date date = new Date((diff /= 1000000L) * 1000L);
        DateFormat timeFormat = DateFormat.getTimeInstance(1);
        TimeZone tz = TimeZone.getTimeZone("GMT");
        timeFormat.setTimeZone(tz);
        return timeFormat.format(date);
    }

    public static String Dups(HistoryIndexFileEntry entry) {
        return String.valueOf(entry.DDirHdDupCount());
    }

    public static String EXEC_Pgm(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        String value = entry.DDirHdPgmNm().trim();
        return value.length() == 0 ? NLS.getString("n/a") : value;
    }

    public static String History_File_DSN(HistoryIndexFileEntry entry) {
        return entry.getHistoryFileName();
    }

    public static String I_Abend(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        String value = HistoryIndexFileEntryFormatter.DDirHdIAbend(entry);
        return value.length() == 0 ? NLS.getString("n/a") : value;
    }

    public static String IMS_Pgm(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        String value = entry.DDirHdImsPrgName().trim();
        return value.length() == 0 ? NLS.getString("n/a") : value;
    }

    public static String Job_ID(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        String value = entry.DDirHdJobID().trim();
        return value.length() == 0 ? NLS.getString("n/a") : value;
    }

    public static String Jobname(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        String value = entry.DDirHdJobname().trim();
        return value.length() == 0 ? NLS.getString("n/a") : value;
    }

    public static String Lock(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        byte[] lock = new byte[]{entry.DDirHdLock()};
        if (lock[0] == 0) {
            return " ";
        }
        return HistoryIndexFileEntryFormatter.removeZeros(new String(lock, 0, 1, "Cp1047"));
    }

    public static String Minidump(HistoryIndexFileEntry entry) {
        if (entry.DDirHdMdPages() > 0L) {
            return NLS.getString("Yes");
        }
        return NLS.getString("No");
    }

    public static String Module(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        String value = entry.DDirPofModule().trim();
        return value.length() == 0 ? NLS.getString("n/a") : value;
    }

    public static String MD_Pages(HistoryIndexFileEntry entry) {
        return String.valueOf(entry.DDirHdMdPages());
    }

    public static String MVS_Dump_DSN(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        int endOffset;
        if (HistoryIndexFileEntryFormatter.MVS_Dump(entry).equals(NLS.getString("No"))) {
            return NLS.getString("n/a");
        }
        int startOffset = entry.DDirHdDSN_Off();
        if (startOffset == (endOffset = HistoryIndexFileEntryFormatter.getZeroIndex(entry.getHistoryIndexFileEntryRawData(), startOffset))) {
            return NLS.getString("n/a");
        }
        int recordLength = HistoryIndexFileEntryFormatter.parseUnsignedShort(entry.getHistoryIndexFileEntryRawData(), 0);
        if (startOffset > recordLength || endOffset > recordLength) {
            return NLS.getString("n/a");
        }
        String dsn = HistoryIndexFileEntryFormatter.removeZeros(new String(entry.getHistoryIndexFileEntryRawData(), startOffset, endOffset - startOffset, "Cp1047")).trim();
        if (dsn.length() > 0) {
            return dsn;
        }
        return NLS.getString("n/a");
    }

    public static String Offset(HistoryIndexFileEntry entry) {
        Formatter f = new Formatter(new StringBuffer());
        f.format("%X", entry.DDirPofOffset());
        return f.toString().toUpperCase();
    }

    public static String Program(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        String value = entry.DDirPofCsect().trim();
        return value.length() == 0 ? NLS.getString("n/a") : value;
    }

    public static String System(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        String value = entry.DDirHdTsName().trim();
        return value.length() == 0 ? NLS.getString("n/a") : value;
    }

    public static String User_Title(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        String value = entry.DDirHdUsrTitle().trim();
        return value.length() == 0 ? NLS.getString("n/a") : value;
    }

    public static String Username(HistoryIndexFileEntry entry) throws UnsupportedEncodingException {
        String value = entry.DDirHdUsrName().trim();
        return value.length() == 0 ? NLS.getString("n/a") : value;
    }

    private static String removeZeros(String s) {
        int i = 0;
        while (i < s.length()) {
            if (i == 0 && s.charAt(i) == '\u0000') {
                s = " ";
                return s;
            }
            if (s.charAt(i) == '\u0000') {
                s = s.substring(0, i).trim();
                return s;
            }
            ++i;
        }
        return s;
    }

    private static int getZeroIndex(byte[] data, int start) {
        int i = start;
        while (i < data.length) {
            if (data[i] == 0) {
                return i;
            }
            ++i;
        }
        return i - 1;
    }

    private static int parseUnsignedShort(byte[] buffer, int start) {
        int i1 = (buffer[start++] & 0xFF) << 8;
        int i2 = buffer[start++] & 0xFF;
        return i1 | i2;
    }

    private static int parseSignedInt(byte[] buffer, int start) {
        int i1 = (buffer[start++] & 0xFF) << 24;
        int i2 = (buffer[start++] & 0xFF) << 16;
        int i3 = (buffer[start++] & 0xFF) << 8;
        int i4 = buffer[start++] & 0xFF;
        return i1 | i2 | i3 | i4;
    }

    private static short parseSignedShort(byte[] buffer, int start) {
        short i1 = (short)((buffer[start++] & 0xFF) << 8);
        short i2 = (short)(buffer[start++] & 0xFF);
        return (short)(i1 | i2);
    }

    private static boolean allZeros(byte[] buffer) {
        int i = 0;
        while (i < buffer.length) {
            if (buffer[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

