/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.view.summary.actions;

import com.ibm.etools.fa.jobs.RetrieveHistoryFileInformationJob;
import com.ibm.etools.fa.pages.AddNewHistoryFilePage;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.subsystem.FASubSystem;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.util.RSESystemManagement;
import com.ibm.etools.fa.view.details.DetailedHistoryFileView;
import com.ibm.etools.fa.view.details.FAHistoryFileViewData;
import com.ibm.etools.fa.view.summary.HistoryFileElement;
import com.ibm.etools.fa.view.summary.RootElement;
import com.ibm.etools.fa.view.summary.actions.HistoryFileViewAction;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class AddNewHistoryFileAction
extends HistoryFileViewAction {
    public void run(IAction action) {
        try {
            RootElement selectedRoot = (RootElement)this.selectedElement;
            FASubSystem[] faSubSystems = RSESystemManagement.getAllFASubSystems();
            if (faSubSystems == null || faSubSystems.length == 0) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)NLS.getString("HistoryFilesView.NoSubSysTitle"), (String)NLS.getString("HistoryFilesView.NoSubSysMsg"));
                return;
            }
            String[] systemNames = new String[faSubSystems.length];
            int i = 0;
            while (i < faSubSystems.length) {
                systemNames[i] = faSubSystems[i].getSystemConnection().getAliasName();
                ++i;
            }
            AddNewHistoryFilePage page = new AddNewHistoryFilePage(Display.getCurrent().getActiveShell(), systemNames);
            if (page.open() != 0) {
                return;
            }
            String selectedSystemName = page.getSelectedSystemName();
            IFile localCacheFile = FAPlugin.getDefault().getFile(String.valueOf(selectedSystemName) + File.separator + page.getHistoryFileName() + File.separator + "$$INDEX");
            FAHistoryFileViewData data = new FAHistoryFileViewData(page.getSelectedSystemName(), page.getHistoryFileName(), localCacheFile.getLocation().toString());
            HistoryFileElement histFileElement = this.addNewHistoryFile(data, selectedRoot);
            if (data.hasCachedHistFile()) {
                this.updateViews(data, histFileElement);
            } else {
                RetrieveHistoryFileInformationJob job = new RetrieveHistoryFileInformationJob(data);
                job.runJob();
            }
        }
        catch (Exception e) {
            FAPlugin.getDefault().log(4, NLS.getString("AddNewHistoryFileAction.AddHistFileErrMsg"), e, true);
            return;
        }
    }

    private void updateViews(FAHistoryFileViewData data, HistoryFileElement histFileElement) throws Exception {
        IWorkbenchPage activePage = FAPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage.findView("com.ibm.etools.fa.view.details.DetailedHistoryFileView") != null) {
            DetailedHistoryFileView view = (DetailedHistoryFileView)activePage.showView("com.ibm.etools.fa.view.details.DetailedHistoryFileView");
            ArrayList<FAHistoryFileViewData> viewList = new ArrayList<FAHistoryFileViewData>();
            viewList.add(histFileElement.getHistoryFileData());
            view.populateTable(viewList, histFileElement.getHistoryFileData().getHistFileName());
        }
    }
}

