/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.view.summary.actions;

import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.view.summary.HistoryFilesContainerElement;
import com.ibm.etools.fa.view.summary.SystemElement;
import com.ibm.etools.fa.view.summary.ViewsContainerElement;
import com.ibm.etools.fa.view.summary.actions.HistoryFileViewAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;

public class DeleteCachedInfoAction
extends HistoryFileViewAction {
    public void run(IAction action) {
        try {
            if (this.selectedElement instanceof ViewsContainerElement) {
                this.removeCachedViewsInfo((ViewsContainerElement)this.selectedElement);
                return;
            }
            if (this.selectedElement instanceof HistoryFilesContainerElement) {
                this.removeCachedIspfProfInfo((HistoryFilesContainerElement)this.selectedElement);
                return;
            }
            System.out.println("Selected item type not supported: " + this.selectedElement.getClass().getName());
        }
        catch (Exception e) {
            FAPlugin.getDefault().log(4, NLS.getString("DeleteCachedInfoAction.errMsg"), e, true);
            return;
        }
    }

    private void removeCachedViewsInfo(ViewsContainerElement selElem) throws Exception {
        SystemElement systemElement = (SystemElement)selElem.getParent();
        IProject configProj = FAPlugin.getDefault().getConfigProject();
        IFolder folder = configProj.getFolder(systemElement.getLabel());
        if (folder.exists()) {
            IResource[] members = folder.members();
            int i = 0;
            while (i < members.length) {
                IFile tmpFile;
                String fileExtension;
                if (members[i] instanceof IFile && (fileExtension = "." + (tmpFile = (IFile)members[i]).getFileExtension()).equals(".viewCachInfo")) {
                    tmpFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                ++i;
            }
        }
    }

    private void removeCachedIspfProfInfo(HistoryFilesContainerElement selElem) throws Exception {
        SystemElement systemElement = (SystemElement)selElem.getParent();
        IFolder folder = FAPlugin.getDefault().getConfigProject().getFolder(systemElement.getLabel());
        folder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        IResource[] children = folder.members();
        int i = 0;
        while (i < children.length) {
            IFile file;
            if (children[i] instanceof IFile && (file = (IFile)children[i]).getLocation().getFileExtension().equalsIgnoreCase("ispfHistFilesCache")) {
                file.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            ++i;
        }
        folder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
    }
}

