//KENICHI                   ??=ifndef LEAWI_INCLUDED
//KENICHI                   ??=ifdef __COMPILER_VER__
//KENICHI                    ??=pragma filetag("IBM-1047")
//KENICHI                   ??=endif
                   #define LEAWI_INCLUDED
                   #pragma nomargins nosequence
                   #pragma checkout(suspend)
 /***************************************************************
 *  <leawi.h> header file (31-bit only)                         *
 *                                                              *
 * LICENSED MATERIALS - PROPERTY OF IBM                         *
 *                                                              *
 * 5694-A01                                                     *
 *                                                              *
 * (C) COPYRIGHT IBM CORP. 1998, 2004                           *
 *                                                              *
 * US GOVERNMENT USERS RESTRICTED RIGHTS - USE,                 *
 * DUPLICATION OR DISCLOSURE RESTRICTED BY GSA ADP              *
 * SCHEDULE CONTRACT WITH IBM CORP.                             *
 *                                                              *
 * STATUS = HLE7709                                             *
 ***************************************************************/
 
  #ifdef __cplusplus
  extern "C" {
  #endif
 
  #ifndef __EDC_LE
    #define __EDC_LE 0x10000000
  #endif
 
  #if __TARGET_LIB__ >= __EDC_LE
 
  #ifndef _LP64
 
   #if !defined(__features_h)  || defined(__inc_features)
     #include <features.h>
   #endif
 
   typedef signed short int _INT2;
 
   typedef signed      long _INT4;
 
   typedef float            _FLOAT4;
   typedef double           _FLOAT8;
   typedef long double      _FLOAT16;
   typedef void *           _POINTER;
   typedef char             _CHAR2   [  2];
   typedef char             _CHAR3   [  3];
   typedef char             _CHAR4   [  4];
   typedef char             _CHAR17  [ 17];
   typedef char             _CHAR80  [ 80];
   typedef char             _CHAR255 [255];
 
   struct _COMPLEX4 {
      float real,
            imaginary;
   };
   typedef struct _COMPLEX4  _COMPLEX4;
 
   struct _COMPLEX8 {
      double real,
             imaginary;
   };
   typedef struct _COMPLEX8  _COMPLEX8;
 
   struct _COMPLEX16 {
      long double real,
                  imaginary;
   };
   typedef struct _COMPLEX16 _COMPLEX16;
 
   struct _FEEDBACK {
      short     tok_sev;       /* severity                    */
      short     tok_msgno;     /* message number              */
      int       tok_case :2,   /* flags - case/sev/control    */
                tok_sever:3,
                tok_ctrl :3 ;
      char      tok_facid[3];  /* facility ID                 */
      int     tok_isi     ;    /* index into ISI block        */
   };
   typedef struct _FEEDBACK  _FEEDBACK;
 
   struct _VSTRING {
      _INT2    length;
      _CHAR255 string;
   };
   typedef struct _VSTRING   _VSTRING;
 
   struct _ENTRY {
      _POINTER address;
      _POINTER nesting;        /* user must init nesting=NULL */
   };
   typedef struct _ENTRY     _ENTRY;
 
   struct _CEECIB {
   /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
   /* Condition Information Block - Prefix area.                Area 0*/
   /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
      char       cib_eye[4];        /* Eye catcher.                   */
      struct _CEECIB *cib_back;     /* Previous CIB.                  */
      struct _CEECIB *cib_fwrd;     /* Next CIB.                      */
      short int  cib_siz;           /* Size of ceexeb                 */
      short int  cib_ve;            /* Version code of ceexeb         */
      int        cib_Plat_id;       /* Action Code.                   */
      int        rsvd;              /* Reserved. Do not use.          */
 
   /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
   /* CIB Area provides for CSC Information.                    Area 1*/
   /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
      _FEEDBACK  cib_cond;          /* Current LE/370 condition       */
      void      *cib_machine;       /* Address of associated machine  */
                                    /*   the exception. I_Pgm_loc     */
      _FEEDBACK  cib_old_cond;      /* Initial LE/370 Condition       */
 
      int        cib_flg_1: 8,
                 cib_flg_2: 8,
                 cib_flg_3: 8,
                 cib_flg_4_rsvd1: 1,/* Reserved.                      */
                 cib_flg_4_rsvd2: 1,/* Reserved.                      */
                 cib_flg_4_rsvd3: 1,/* Reserved.                      */
                 cib_flg_4_rsvd4: 1,/* Reserved.                      */
                 cib_rsm_mve: 1,    /* Resume cursor moved explicit   */
                 cib_msg_out: 1,    /* Message service processed      */
                                    /*  condition.                    */
                 cib_rsm_mvr: 1,    /* Resume cursor moved relative.  */
                 cib_flg_4_rsvd5: 1;/* Reserved.                      */
 
                                    /* The Handle Cursor.             */
      void      *cib_hdl_sf;        /* Pointer to Stack Frame.        */
      _ENTRY     cib_hdl_entry;     /* Pointer to Current Handler.    */
 
                                    /* The Resume Cursor.             */
      void      *cib_rsm_sf;        /* Save area part.                */
      void      *cib_rsm_point;     /* Instruction address part       */
      void      *cib_rsm_machine;   /* Address of associated machine  */
                                    /*  state.                        */
      int        cib_cond_default;  /* Default condition handler.     */
      #if __EDC_TARGET >= __EDC_LE210
      void      *cib_ph_callee_sf;  /* pointer to DSA for physical
                                       callee for cib_hdl_sf          */
      char       cib_hdl_sf_fmt;    /* stack format for cib_hdl_sf
                                       (0=up, 1=down)                 */
      char       cib_ph_callee_sf_fmt; /* stack format for
                                          cib_ph_callee_sf
                                          (0=up, 1=down)              */
      char       cib_area1_rsvd[54];/* Reserved.                      */
      #else
      char       cib_area1_rsvd[60];/* Reserved.                      */
      #endif
 
   /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
   /* Vector hardware and math routines support                 Area 3*/
   /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
      char       cib_vsr[8];        /* Vector status reg save area    */
      void      *cib_vstor;         /* A(of vector envir.save areas)  */
      void      *cib_vrpsa;         /* A(1st vec reg pair save area)  */
      struct CEEMCB *cib_mcb;       /* A(MCB at time of interrupt)    */
      char       cib_mrn[8];        /* Math routine name.             */
 
                                    /* Math flag.                     */
      int        cib_mdsf1b0: 1,    /* ON for AWI and CWI, else OFF.  */
                 cib_mdsf1b1: 1,    /* ON for AWI, else OFF.          */
                 cib_mathrest: 6,   /* Method of math invocation.     */
                 cib_vma_rsvd: 24;  /* Reserved.                      */
 
   /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
   /* LE/370 Exception Manager Flags.                           Area 4*/
   /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
                                    /* Status Flags.                  */
                                    /* LE/370 Events.                 */
      int        cib_abf: 1,        /* ABEND Caused.                  */
                 cib_pcf: 1,        /* Program Check Caused.          */
                 cib_kill: 1,       /* Signal via CEEOKILL.           */
                 cib_flg_5_rsvd: 1, /* Empty.                         */
                 cib_tiu: 1,        /* Condition management raised TIU*/
                 cib_promo: 1,      /*  new condition result from a   */
                                    /*  promote.                      */
                 cib_sgl: 1,        /* Signalled condition.           */
                 cib_ext: 1,        /* Attention Interrupt Caused.    */
 
                                    /* LE/370 Actions                 */
                 cib_arcv: 1,       /* Abend reason code valid.       */
                 cib_mrc: 1,        /* Math routine condition.        */
                 cib_alw_rsm: 1,    /* Allow resume operation.        */
                 cib_mrc_typ: 1,    /* MRC type 1.                    */
                 cib_enable_only: 1,/* Enable only pass (no cond.pass)*/
                 cib_owning_sf: 1,  /* Hcursor pointing to owning SF  */
                 cib_sf0: 1,        /* Doing post SF0 scan.           */
                 cib_tc_done: 1,    /* members informed of condition. */
 
                                    /* Named Conditions.              */
                 cib_stg: 1,        /* Storage Condition.             */
                 cib_flg_7_rsvd1: 1,/* Empty.                         */
                 cib_flg_7_rsvd2: 1,/* Empty.                         */
                 cib_flg_7_rsvd3: 1,/* Empty.                         */
                 cib_flg_7_rsvd4: 1,/* Empty.                         */
                 cib_flg_7_rsvd5: 1,/* Empty.                         */
                 cib_flg_7_rsvd6: 1,/* Empty.                         */
                 cib_norec: 1,      /* Do not allow recursion cond.   */
                 cib_flg_8: 8;      /* Flags used to ask for dump.    */
 
   /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
   /* LE/370 Extras.                                            Area 5*/
   /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
   /* ----------------------------------------------------------------*/
   /* ABEND Codes copied from the  SDWA                               */
   /* --------------------------------------------------------------- */
      int        cib_abcd;          /* Abend code word.               */
      int        cib_abrc;          /* Abend Reason Word.             */
      char       cib_abname[8];     /* Abend. Load module name in sdwa*/
 
   /* ----------------------------------------------------------------*/
   /* Information relating to the most significant Save area.         */
   /* ----------------------------------------------------------------*/
      void      *cib_pl;            /* Pointer to the prologue        */
                                    /*  see cib_ppav for version of   */
                                    /*  PPA we are pointing at.       */
      void      *cib_sv2;           /* Save area of first significant */
                                    /*  LE/370 Program                */
      void      *cib_sv1;           /* Address of save area at time   */
                                    /*  of the exception.             */
      void      *cib_int;           /* Address of instruction causing */
 
    /* ---------------------------------------------------------------*/
    /* Miscellaneous information.                                     */
    /* ---------------------------------------------------------------*/
      struct QDATA  *cib_qdata;     /* Q data token                   */
      int         cib_fdbk;          /* Address of feedback token for */
                                     /*  signaled conditions.         */
      int         cib_fun;           /* Member list function code     */
      char        cib_toke[4];       /* Token from CEEHDL routines or */
                                     /*  Ptr to SF that cased the poll*/
                                     /*  to invoke Mbr Ex Handler.    */
      char        cib_mid[4];        /* ID Code at time of interrupt. */
      int         cib_state;         /* Code used to identify activity*/
                                     /*  associated with this event.  */
      int         cib_rtcc;          /* Action Code.                  */
      int         cib_ppav;          /* Version of PPA in Cib_pl      */
                                     /*  -1 = C/370 Version one       */
                                     /*   1 = LE/370 Verion 1.1.0     */
      char        cib_ab_term_exit[8];
                                     /* Name of the abnorm term exit  */
                                     /*  in control.                  */
      int         cib_sdwa_ptr;      /* Address of SDWA associated    */
                                     /*  with the condition.          */
      int         cib_signo;         /* OpenMVS signal number         */
                                     /*  (This field will be zero if  */
                                     /*   the associated condition has*/
                                     /*   not been mapped to an       */
                                     /*   OpenMVS signal)             */
      void       *cib_ppsd;          /* Pointer to LE's copy of the   */
                                     /*  PPSD (See OpenMVS's BPXYPPSD */
                                     /*  or LE's CEEOSIGD for a       */
                                     /*  description of the PPSD)     */
      char        cib_area5_rsvd[4]; /* Reserved.                     */
   };
   typedef struct _CEECIB _CEECIB;
 
   struct QDATA {
      int   * qdata_parmcnt;         /* Number of parameters in qdata.*/
      char  * qdata_rtnname;         /* Math routine with condition.  */
      void  * qdata_resdesc;         /* Qdata descriptor for result.  */
      void  * qdata_result;          /* Result to return to math rtn. */
      void  * qdata_arg1desc;        /* Qdata descriptor for arg1.    */
      void  * qdata_arg1;            /* Argument 1.                   */
      void  * qdata_arg2desc;        /* Qdata descriptor for arg2.    */
      void  * qdata_arg2;            /* Argument 2.                   */
      void  * qdata_resumedesc;      /* Qdata descriptor for resume.  */
      void  * qdata_resume;          /* Resume value.                 */
   };
 
   struct CEEMCB {
      char         mcb_filler[444];  /* Mcb stuff.                    */
      struct QDATA mcb_qdata;        /* QDATA area.                   */
   };                                /* Not interested in the reset.  */
 
   /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
   /* Constants                                                       */
   /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
   #define CIB_VER_NUM        4      /* Version code of CIB.          */
   #define CIB_PLATFORM       3      /* Platform code of CIB.         */
 
   #define OMIT_FC ((_FEEDBACK *)(0))
   #ifndef NULL
     #ifdef __cplusplus
       #define NULL 0
     #else
       #define NULL  ((void *)(0))
     #endif
   #endif
 
   #pragma map(CEE3PRM,"CEE3PRM")
   void CEE3PRM (_CHAR80, _FEEDBACK *);
 
   #pragma map(CEEGTST,"CEEGTST")
   void CEEGTST( _INT4 *, _INT4 *, _POINTER *, _FEEDBACK *);
 
   #pragma map(CEEFRST,"CEEFRST")
   void CEEFRST( _POINTER *, _FEEDBACK *);
 
   #pragma map(CEECMI,"CEECMI")
   void CEECMI( _FEEDBACK *, _INT4 *,_VSTRING *, _FEEDBACK *);
 
   #pragma map(CEECZST,"CEECZST")
   void CEECZST( _POINTER *, _INT4 *, _FEEDBACK *);
 
   #pragma map(CEECRHP,"CEECRHP")
   void CEECRHP( _INT4 *, _INT4 *, _INT4 *, _INT4 *, _FEEDBACK *);
 
   #pragma map(CEEDSHP,"CEEDSHP")
   void CEEDSHP( _INT4 *, _FEEDBACK *);
 
   #pragma map(CEE3RPH,"CEE3RPH")
   void CEE3RPH( _CHAR80, _FEEDBACK *);
 
   #pragma map(CEENCOD,"CEENCOD")
   void CEENCOD( _INT2 *, _INT2 *, _INT2 *, _INT2 *, _INT2 *,
                 _CHAR3, _INT4 *,_FEEDBACK *,_FEEDBACK *);
 
   #pragma map(CEEDCOD,"CEEDCOD")
   void CEEDCOD( _FEEDBACK *, _INT2 *, _INT2 *, _INT2 *, _INT2 *,
                 _INT2 *, _CHAR3, _INT4 *, _FEEDBACK *);
 
   #pragma map(CEEMOUT,"CEEMOUT")
   void CEEMOUT( _VSTRING *, _INT4 *, _FEEDBACK *);
 
   #pragma map(CEEMSG,"CEEMSG")
   void CEEMSG ( _FEEDBACK *, _INT4 *, _FEEDBACK *);
 
   #pragma map(CEEMGET,"CEEMGET")
   void CEEMGET( _FEEDBACK *, _CHAR80, _INT4 *, _FEEDBACK *);
 
   #pragma map(CEE3LNG,"CEE3LNG")
   void CEE3LNG( _INT4 *, _CHAR3, _FEEDBACK *);
 
   #pragma map(CEE3CTY,"CEE3CTY")
   void CEE3CTY( _INT4 *, _CHAR2, _FEEDBACK *);
 
   #pragma map(CEE3MDS,"CEE3MDS")
   void CEE3MDS( _CHAR2, _CHAR2, _FEEDBACK *);
 
   #pragma map(CEE3MCS,"CEE3MCS")
   void CEE3MCS( _CHAR2, _CHAR2, _FEEDBACK *);
 
   #pragma map(CEE3MTS,"CEE3MTS")
   void CEE3MTS( _CHAR2, _CHAR2, _FEEDBACK *);
 
   #pragma map(CEEFMDA,"CEEFMDA")
   void CEEFMDA( _CHAR2, _CHAR80, _FEEDBACK *);
 
   #pragma map(CEEFMTM,"CEEFMTM")
   void CEEFMTM( _CHAR2, _CHAR80, _FEEDBACK *);
 
   #pragma map(CEEFMDT,"CEEFMDT")
   void CEEFMDT( _CHAR2, _CHAR80, _FEEDBACK *);
 
   #pragma map(CEEHDLR,"CEEHDLR")
   void CEEHDLR( _ENTRY *, _INT4 *, _FEEDBACK *);
 
   #pragma map(CEEHDLU,"CEEHDLU")
   void CEEHDLU( _ENTRY *, _FEEDBACK *);
 
   #pragma map(CEEMRCE,"CEEMRCE")
   void CEEMRCE( _INT4 *, _FEEDBACK *);
 
   #pragma map(CEEMRCR,"CEEMRCR")
   void CEEMRCR( _INT4 *, _FEEDBACK *);
 
   #pragma map(CEESGL,"CEESGL")
   void CEESGL ( _FEEDBACK *, _INT4 *, _FEEDBACK *);
 
   #pragma map(CEE3SPM,"CEE3SPM")
   void CEE3SPM( _INT4 *, _CHAR80, _FEEDBACK *);
 
   #pragma map(CEEGQDT,"CEEGQDT")
   void CEEGQDT( _FEEDBACK *, _INT4 *, _FEEDBACK *);
 
   #pragma map(CEEGPID,"CEEGPID")
   void CEEGPID( _INT4 *, _INT4 *, _FEEDBACK *);
 
   #pragma map(CEEITOK,"CEEITOK")
   void CEEITOK( _FEEDBACK *, _FEEDBACK *);
 
   #pragma map(CEE3SRC,"CEE3SRC")
   void CEE3SRC( _INT4 *, _FEEDBACK *);
 
   #pragma map(CEE3SRP,"CEE3SRP")
   void CEE3SRP( _INT4 *, _FEEDBACK *);
 
   #pragma map(CEE3GRC,"CEE3GRC")
   void CEE3GRC( _INT4 *, _FEEDBACK *);
 
   #pragma map(CEE3GRO,"CEE3GRO")
   void CEE3GRO( _INT4 *, _FEEDBACK *);
 
   #pragma map(CEE3GRN,"CEE3GRN")
   void CEE3GRN( _CHAR80, _FEEDBACK *);
 
   #pragma map(CEE3CNC,"CEE3CNC")
   void CEE3CNC( _INT4 *, _FEEDBACK *);
 
   #pragma map(CEE3ABD,"CEE3ABD")
   void CEE3ABD( _INT4 *, _INT4 *);
 
   #pragma map(CEE3CIB,"CEE3CIB")
   void CEE3CIB(_FEEDBACK *, _CEECIB **, _FEEDBACK *);
 
   #pragma map(CEETEST,"CEETEST")
   void CEETEST( _VSTRING *, _FEEDBACK *);
 
   #ifdef __AE_BIMODAL_F
     #pragma map (__cee3dmp_e,"CEE3DMP")
     #pragma map (__cee3dmp_a,"\174\174A00358")
   #endif /* __AE_BIMODAL_F */
 
   #ifdef __NATIVE_ASCII_F
     #pragma map(CEE3DMP,"\174\174A00358")
   #else
     #pragma map(CEE3DMP,"CEE3DMP")
   #endif
 
   void CEE3DMP( _CHAR80, _CHAR255, _FEEDBACK *);
 
   #ifdef __AE_BIMODAL_F
    __new4102(void,__cee3dmp_a,(_CHAR80, _CHAR255, _FEEDBACK *));
    __new4102(void,__cee3dmp_e,(_CHAR80, _CHAR255, _FEEDBACK *));
   #endif  /* __AE_BIMODAL_F */
 
   #pragma map(CEEDAYS,"CEEDAYS")
   void CEEDAYS( _VSTRING *, _VSTRING *, _INT4 *, _FEEDBACK *);
 
   #pragma map(CEEDATE,"CEEDATE")
   void CEEDATE( _INT4 *, _VSTRING *, _CHAR80, _FEEDBACK *);
 
   #pragma map(CEESECS,"CEESECS")
   void CEESECS( _VSTRING *, _VSTRING *, _FLOAT8 *, _FEEDBACK *);
 
   #pragma map(CEEDATM,"CEEDATM")
   void CEEDATM( _FLOAT8 *, _VSTRING *, _CHAR80, _FEEDBACK *);
 
   #pragma map(CEEISEC,"CEEISEC")
   void CEEISEC( _INT4 *, _INT4 *, _INT4 *, _INT4 *, _INT4 *, _INT4 *,
                 _INT4 *, _FLOAT8 *, _FEEDBACK *);
 
   #pragma map(CEESECI,"CEESECI")
   void CEESECI( _FLOAT8 *, _INT4 *, _INT4 *, _INT4 *, _INT4 *,
                 _INT4 *, _INT4 *, _INT4 *, _FEEDBACK *);
 
   #pragma map(CEEDYWK,"CEEDYWK")
   void CEEDYWK( _INT4 *, _INT4 *, _FEEDBACK *);
 
   #pragma map(CEEUTC,"CEEUTC")
   void CEEUTC ( _INT4 *, _FLOAT8 *, _FEEDBACK *);
 
   #pragma map(CEEGMT,"CEEGMT")
   void CEEGMT ( _INT4 *, _FLOAT8 *, _FEEDBACK *);
 
   #pragma map(CEEGMTO,"CEEGMTO")
   void CEEGMTO( _INT4 *, _INT4 *, _FLOAT8 *, _FEEDBACK *);
 
   #pragma map(CEELOCT,"CEELOCT")
   void CEELOCT( _INT4 *, _FLOAT8 *, _CHAR17, _FEEDBACK *);
 
   #pragma map(CEESCEN,"CEESCEN")
   void CEESCEN( _INT4 *, _FEEDBACK *);
 
   #pragma map(CEEQCEN,"CEEQCEN")
   void CEEQCEN( _INT4 *, _FEEDBACK *);
 
   #pragma map(CEERAN0,"CEERAN0")
   void CEERAN0( _INT4 *, _FLOAT8 *, _FEEDBACK *);
 
   #pragma map(CEE3USR,"CEE3USR")
   void CEE3USR( _INT4 *, _INT4 *, _INT4 *, _FEEDBACK *);
 
   #pragma map(CEETDLI,"CEETDLI")
   #ifdef __cplusplus
     #ifdef __XPLINK__
       extern "OS_UPSTACK" void CEETDLI(...);
     #else
       extern "OS" void CEETDLI(...);
     #endif
   #else
     #ifdef __XPLINK__
       #pragma linkage(CEETDLI, OS_UPSTACK)
     #else
       #pragma linkage(CEETDLI, OS)
     #endif
     void CEETDLI();
   #endif
 
   #pragma map(CEESSLOG,"CEESSLOG")
   void CEESSLOG( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDLOG,"CEESDLOG")
   void CEESDLOG( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQLOG,"CEESQLOG")
   void CEESQLOG( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESTLOG,"CEESTLOG")
   void CEESTLOG( _COMPLEX4 *, _FEEDBACK *, _COMPLEX4 *);
 
   #pragma map(CEESELOG,"CEESELOG")
   void CEESELOG( _COMPLEX8 *, _FEEDBACK *, _COMPLEX8 *);
 
   #pragma map(CEESRLOG,"CEESRLOG")
   void CEESRLOG( _COMPLEX16 *, _FEEDBACK *, _COMPLEX16 *);
 
   #pragma map(CEESSLG1,"CEESSLG1")
   void CEESSLG1( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDLG1,"CEESDLG1")
   void CEESDLG1( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQLG1,"CEESQLG1")
   void CEESQLG1( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESSLG2,"CEESSLG2")
   void CEESSLG2( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDLG2,"CEESDLG2")
   void CEESDLG2( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQLG2,"CEESQLG2")
   void CEESQLG2( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESSEXP,"CEESSEXP")
   void CEESSEXP( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDEXP,"CEESDEXP")
   void CEESDEXP( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQEXP,"CEESQEXP")
   void CEESQEXP( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESTEXP,"CEESTEXP")
   void CEESTEXP( _COMPLEX4 *, _FEEDBACK *, _COMPLEX4 *);
 
   #pragma map(CEESEEXP,"CEESEEXP")
   void CEESEEXP( _COMPLEX8 *, _FEEDBACK *, _COMPLEX8 *);
 
   #pragma map(CEESREXP,"CEESREXP")
   void CEESREXP( _COMPLEX16 *, _FEEDBACK *, _COMPLEX16 *);
 
   #pragma map(CEESIXPI,"CEESIXPI")
   void CEESIXPI( _INT4 *, _INT4 *, _FEEDBACK *, _INT4 *);
 
   #pragma map(CEESSXPI,"CEESSXPI")
   void CEESSXPI( _FLOAT4 *, _INT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDXPI,"CEESDXPI")
   void CEESDXPI( _FLOAT8 *, _INT4 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQXPI,"CEESQXPI")
   void CEESQXPI( _FLOAT16 *, _INT4 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESTXPI,"CEESTXPI")
   void CEESTXPI( _COMPLEX4 *, _INT4 *, _FEEDBACK *, _COMPLEX4 *);
 
   #pragma map(CEESEXPI,"CEESEXPI")
   void CEESEXPI( _COMPLEX8 *, _INT4 *, _FEEDBACK *, _COMPLEX8 *);
 
   #pragma map(CEESRXPI,"CEESRXPI")
   void CEESRXPI( _COMPLEX16 *, _INT4 *, _FEEDBACK *, _COMPLEX16 *);
 
   #pragma map(CEESSXPS,"CEESSXPS")
   void CEESSXPS( _FLOAT4 *, _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDXPD,"CEESDXPD")
   void CEESDXPD( _FLOAT8 *, _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQXPQ,"CEESQXPQ")
   void CEESQXPQ( _FLOAT16 *, _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESQXP2,"CEESQXP2")
   void CEESQXP2( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESTXPT,"CEESTXPT")
   void CEESTXPT( _COMPLEX4 *, _COMPLEX4 *, _FEEDBACK *, _COMPLEX4 *);
 
   #pragma map(CEESEXPE,"CEESEXPE")
   void CEESEXPE( _COMPLEX8 *, _COMPLEX8 *, _FEEDBACK *, _COMPLEX8 *);
 
   #pragma map(CEESRXPR,"CEESRXPR")
   void CEESRXPR( _COMPLEX16 *, _COMPLEX16 *,_FEEDBACK *,_COMPLEX16 *);
 
   #pragma map(CEESSASN,"CEESSASN")
   void CEESSASN( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDASN,"CEESDASN")
   void CEESDASN( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQASN,"CEESQASN")
   void CEESQASN( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESSACS,"CEESSACS")
   void CEESSACS( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDACS,"CEESDACS")
   void CEESDACS( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQACS,"CEESQACS")
   void CEESQACS( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESSATN,"CEESSATN")
   void CEESSATN( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDATN,"CEESDATN")
   void CEESDATN( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQATN,"CEESQATN")
   void CEESQATN( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESTATN,"CEESTATN")
   void CEESTATN( _COMPLEX4 *, _FEEDBACK *, _COMPLEX4 *);
 
   #pragma map(CEESEATN,"CEESEATN")
   void CEESEATN( _COMPLEX8 *, _FEEDBACK *, _COMPLEX8 *);
 
   #pragma map(CEESRATN,"CEESRATN")
   void CEESRATN( _COMPLEX16 *, _FEEDBACK *, _COMPLEX16 *);
 
   #pragma map(CEESSAT2,"CEESSAT2")
   void CEESSAT2( _FLOAT4 *, _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDAT2,"CEESDAT2")
   void CEESDAT2( _FLOAT8 *, _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQAT2,"CEESQAT2")
   void CEESQAT2( _FLOAT16 *, _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESSSIN,"CEESSSIN")
   void CEESSSIN( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDSIN,"CEESDSIN")
   void CEESDSIN( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQSIN,"CEESQSIN")
   void CEESQSIN( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESTSIN,"CEESTSIN")
   void CEESTSIN( _COMPLEX4 *, _FEEDBACK *, _COMPLEX4 *);
 
   #pragma map(CEESESIN,"CEESESIN")
   void CEESESIN( _COMPLEX8 *, _FEEDBACK *, _COMPLEX8 *);
 
   #pragma map(CEESRSIN,"CEESRSIN")
   void CEESRSIN( _COMPLEX16 *, _FEEDBACK *, _COMPLEX16 *);
 
   #pragma map(CEESSCOS,"CEESSCOS")
   void CEESSCOS( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDCOS,"CEESDCOS")
   void CEESDCOS( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQCOS,"CEESQCOS")
   void CEESQCOS( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESTCOS,"CEESTCOS")
   void CEESTCOS( _COMPLEX4 *, _FEEDBACK *, _COMPLEX4 *);
 
   #pragma map(CEESECOS,"CEESECOS")
   void CEESECOS( _COMPLEX8 *, _FEEDBACK *, _COMPLEX8 *);
 
   #pragma map(CEESRCOS,"CEESRCOS")
   void CEESRCOS( _COMPLEX16 *, _FEEDBACK *, _COMPLEX16 *);
 
   #pragma map(CEESSTAN,"CEESSTAN")
   void CEESSTAN( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDTAN,"CEESDTAN")
   void CEESDTAN( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQTAN,"CEESQTAN")
   void CEESQTAN( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESTTAN,"CEESTTAN")
   void CEESTTAN( _COMPLEX4 *, _FEEDBACK *, _COMPLEX4 *);
 
   #pragma map(CEESETAN,"CEESETAN")
   void CEESETAN( _COMPLEX8 *, _FEEDBACK *, _COMPLEX8 *);
 
   #pragma map(CEESRTAN,"CEESRTAN")
   void CEESRTAN( _COMPLEX16 *, _FEEDBACK *, _COMPLEX16 *);
 
   #pragma map(CEESSCTN,"CEESSCTN")
   void CEESSCTN( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDCTN,"CEESDCTN")
   void CEESDCTN( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQCTN,"CEESQCTN")
   void CEESQCTN( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESSSNH,"CEESSSNH")
   void CEESSSNH( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDSNH,"CEESDSNH")
   void CEESDSNH( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQSNH,"CEESQSNH")
   void CEESQSNH( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESTSNH,"CEESTSNH")
   void CEESTSNH( _COMPLEX4 *, _FEEDBACK *, _COMPLEX4 *);
 
   #pragma map(CEESESNH,"CEESESNH")
   void CEESESNH( _COMPLEX8 *, _FEEDBACK *, _COMPLEX8 *);
 
   #pragma map(CEESRSNH,"CEESRSNH")
   void CEESRSNH( _COMPLEX16 *, _FEEDBACK *, _COMPLEX16 *);
 
   #pragma map(CEESSCSH,"CEESSCSH")
   void CEESSCSH( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDCSH,"CEESDCSH")
   void CEESDCSH( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQCSH,"CEESQCSH")
   void CEESQCSH( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESTCSH,"CEESTCSH")
   void CEESTCSH( _COMPLEX4 *, _FEEDBACK *, _COMPLEX4 *);
 
   #pragma map(CEESECSH,"CEESECSH")
   void CEESECSH( _COMPLEX8 *, _FEEDBACK *, _COMPLEX8 *);
 
   #pragma map(CEESRCSH,"CEESRCSH")
   void CEESRCSH( _COMPLEX16 *, _FEEDBACK *, _COMPLEX16 *);
 
   #pragma map(CEESSTNH,"CEESSTNH")
   void CEESSTNH( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDTNH,"CEESDTNH")
   void CEESDTNH( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQTNH,"CEESQTNH")
   void CEESQTNH( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESTTNH,"CEESTTNH")
   void CEESTTNH( _COMPLEX4 *, _FEEDBACK *, _COMPLEX4 *);
 
   #pragma map(CEESETNH,"CEESETNH")
   void CEESETNH( _COMPLEX8 *, _FEEDBACK *, _COMPLEX8 *);
 
   #pragma map(CEESRTNH,"CEESRTNH")
   void CEESRTNH( _COMPLEX16 *, _FEEDBACK *, _COMPLEX16 *);
 
   #pragma map(CEESSATH,"CEESSATH")
   void CEESSATH( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDATH,"CEESDATH")
   void CEESDATH( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQATH,"CEESQATH")
   void CEESQATH( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESTATH,"CEESTATH")
   void CEESTATH( _COMPLEX4 *, _FEEDBACK *, _COMPLEX4 *);
 
   #pragma map(CEESEATH,"CEESEATH")
   void CEESEATH( _COMPLEX8 *, _FEEDBACK *, _COMPLEX8 *);
 
   #pragma map(CEESRATH,"CEESRATH")
   void CEESRATH( _COMPLEX16 *, _FEEDBACK *, _COMPLEX16 *);
 
   #pragma map(CEESSSQT,"CEESSSQT")
   void CEESSSQT( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDSQT,"CEESDSQT")
   void CEESDSQT( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQSQT,"CEESQSQT")
   void CEESQSQT( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESTSQT,"CEESTSQT")
   void CEESTSQT( _COMPLEX4 *, _FEEDBACK *, _COMPLEX4 *);
 
   #pragma map(CEESESQT,"CEESESQT")
   void CEESESQT( _COMPLEX8 *, _FEEDBACK *, _COMPLEX8 *);
 
   #pragma map(CEESRSQT,"CEESRSQT")
   void CEESRSQT( _COMPLEX16 *, _FEEDBACK *, _COMPLEX16 *);
 
   #pragma map(CEESSERF,"CEESSERF")
   void CEESSERF( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDERF,"CEESDERF")
   void CEESDERF( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQERF,"CEESQERF")
   void CEESQERF( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESSERC,"CEESSERC")
   void CEESSERC( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDERC,"CEESDERC")
   void CEESDERC( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQERC,"CEESQERC")
   void CEESQERC( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESSGMA,"CEESSGMA")
   void CEESSGMA( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDGMA,"CEESDGMA")
   void CEESDGMA( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESSLGM,"CEESSLGM")
   void CEESSLGM( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDLGM,"CEESDLGM")
   void CEESDLGM( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESIABS,"CEESIABS")
   void CEESIABS( _INT4 *, _FEEDBACK *, _INT4 *);
 
   #pragma map(CEESSABS,"CEESSABS")
   void CEESSABS( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDABS,"CEESDABS")
   void CEESDABS( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQABS,"CEESQABS")
   void CEESQABS( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESTABS,"CEESTABS")
   void CEESTABS( _COMPLEX4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESEABS,"CEESEABS")
   void CEESEABS( _COMPLEX8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESRABS,"CEESRABS")
   void CEESRABS( _COMPLEX16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESIMOD,"CEESIMOD")
   void CEESIMOD( _INT4 *, _INT4 *, _FEEDBACK *, _INT4 *);
 
   #pragma map(CEESSMOD,"CEESSMOD")
   void CEESSMOD( _FLOAT4 *, _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDMOD,"CEESDMOD")
   void CEESDMOD( _FLOAT8 *, _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQMOD,"CEESQMOD")
   void CEESQMOD( _FLOAT16 *, _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESSINT,"CEESSINT")
   void CEESSINT( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDINT,"CEESDINT")
   void CEESDINT( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQINT,"CEESQINT")
   void CEESQINT( _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESTIMG,"CEESTIMG")
   void CEESTIMG( _COMPLEX4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESEIMG,"CEESEIMG")
   void CEESEIMG( _COMPLEX8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESRIMG,"CEESRIMG")
   void CEESRIMG( _COMPLEX16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESTCJG,"CEESTCJG")
   void CEESTCJG( _COMPLEX4 *, _FEEDBACK *, _COMPLEX4 *);
 
   #pragma map(CEESECJG,"CEESECJG")
   void CEESECJG( _COMPLEX8 *, _FEEDBACK *, _COMPLEX8 *);
 
   #pragma map(CEESRCJG,"CEESRCJG")
   void CEESRCJG( _COMPLEX16 *, _FEEDBACK *, _COMPLEX16 *);
 
   #pragma map(CEESSNWN,"CEESSNWN")
   void CEESSNWN( _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDNWN,"CEESDNWN")
   void CEESDNWN( _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESSNIN,"CEESSNIN")
   void CEESSNIN( _FLOAT4 *, _FEEDBACK *, _INT4 *);
 
   #pragma map(CEESDNIN,"CEESDNIN")
   void CEESDNIN( _FLOAT8 *, _FEEDBACK *, _INT4 *);
 
   #pragma map(CEESIDIM,"CEESIDIM")
   void CEESIDIM( _INT4 *, _INT4 *, _FEEDBACK *, _INT4 *);
 
   #pragma map(CEESSDIM,"CEESSDIM")
   void CEESSDIM( _FLOAT4 *, _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDDIM,"CEESDDIM")
   void CEESDDIM( _FLOAT8 *, _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQDIM,"CEESQDIM")
   void CEESQDIM( _FLOAT16 *, _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESISGN,"CEESISGN")
   void CEESISGN( _INT4 *, _INT4 *, _FEEDBACK *, _INT4 *);
 
   #pragma map(CEESSSGN,"CEESSSGN")
   void CEESSSGN( _FLOAT4 *, _FLOAT4 *, _FEEDBACK *, _FLOAT4 *);
 
   #pragma map(CEESDSGN,"CEESDSGN")
   void CEESDSGN( _FLOAT8 *, _FLOAT8 *, _FEEDBACK *, _FLOAT8 *);
 
   #pragma map(CEESQSGN,"CEESQSGN")
   void CEESQSGN( _FLOAT16 *, _FLOAT16 *, _FEEDBACK *, _FLOAT16 *);
 
   #pragma map(CEESTMLT,"CEESTMLT")
   void CEESTMLT( _COMPLEX4 *, _COMPLEX4 *, _FEEDBACK *, _COMPLEX4 *);
 
   #pragma map(CEESEMLT,"CEESEMLT")
   void CEESEMLT( _COMPLEX8 *, _COMPLEX8 *, _FEEDBACK *, _COMPLEX8 *);
 
   #pragma map(CEESRMLT,"CEESRMLT")
   void CEESRMLT( _COMPLEX16 *, _COMPLEX16 *,_FEEDBACK *,_COMPLEX16 *);
 
   #pragma map(CEESTDVD,"CEESTDVD")
   void CEESTDVD( _COMPLEX4 *, _COMPLEX4 *, _FEEDBACK *, _COMPLEX4 *);
 
   #pragma map(CEESEDVD,"CEESEDVD")
   void CEESEDVD( _COMPLEX8 *, _COMPLEX8 *, _FEEDBACK *, _COMPLEX8 *);
 
   #pragma map(CEESRDVD,"CEESRDVD")
   void CEESRDVD( _COMPLEX16 *,_COMPLEX16 *,_FEEDBACK *,_COMPLEX16 *);
 
  #endif    /* !defined(_LP64)             */
 
  #endif    /*  __TARGET_LIB__ >= __EDC_LE */
 
  #ifdef __cplusplus
  }
  #endif
 
//KENICHI                   #pragma checkout(resume)
//KENICHI                   ??=endif   /* LEAWI_INCLUDED */
