/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model;

import com.ibm.fmi.model.FieldGroup;
import com.ibm.fmi.model.event.FMIModelDisplayLineChangeEvent;
import com.ibm.fmi.model.event.FMIModelFieldChangeEvent;
import com.ibm.fmi.model.event.FMIModelMultiDisplayLineChangeEvent;
import com.ibm.fmi.model.event.IFMIModelListener;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;

public class FieldGroupArray
extends FieldGroup
implements IFMIModelListener {
    public final int UNDEFINED = -1;
    public final int LIMIT = 50;
    protected FieldGroup template = null;
    protected int endSlackBytes;
    protected int rightMostSlack;

    public FieldGroupArray(FieldGroup template, int level, int recordOffset, int length, int size) throws FMIModelException {
        super(template.name, level, recordOffset, length, template.symbol, FieldGroupArray.getGroups(template, size));
        this.template = template;
        this.numSlackBytes = template.numSlackBytes * size;
        this.ebcdicWidth = template.ebcdicWidth * size;
        int curIncrement = 0;
        FieldGroup[] fieldGroupArray = this.children;
        int n = 0;
        int n2 = fieldGroupArray.length;
        while (n < n2) {
            FieldGroup f = fieldGroupArray[n];
            f.setParent(this);
            f.incrementRecordOffset(curIncrement);
            curIncrement += template.getMaxEbcdicWidth();
            ++n;
        }
        this.editable = false;
        this.empty = false;
        this.hasContent = false;
    }

    protected int setChildrenEbcdic(byte[] ebcdic, int decrement, boolean initializing, boolean forceVal, boolean fireEvent) throws FMIConversionException, FMIKeyException, FMIModelException {
        if (decrement != 0) {
            this.recordOffset -= decrement;
        }
        FieldGroup[] fieldGroupArray = this.children;
        int n = 0;
        int n2 = fieldGroupArray.length;
        while (n < n2) {
            FieldGroup f = fieldGroupArray[n];
            if (!f.isEmpty()) {
                decrement = f.setEbcdic(ebcdic, decrement, initializing, forceVal, fireEvent);
            }
            ++n;
        }
        this.actualWidth = this.ebcdicWidth;
        this.initialized = true;
        return decrement;
    }

    private static FieldGroup[] getGroups(FieldGroup template, int size) throws FMIModelException {
        FieldGroup[] children = new FieldGroup[size];
        template.setSlackBytes(template);
        int i = 0;
        while (i < children.length) {
            children[i] = template.copy();
            children[i].addNameIndex(i);
            ++i;
        }
        return children;
    }

    public FieldGroupArray copy() throws FMIModelException {
        FieldGroup[] copyChildren = new FieldGroup[this.children.length];
        int i = 0;
        while (i < copyChildren.length) {
            copyChildren[i] = this.children[i].copy();
            ++i;
        }
        FieldGroupArray copy = new FieldGroupArray(this.template, this.level, this.recordOffset, this.ebcdicWidth, this.children.length);
        copy.numSlackBytes = this.numSlackBytes;
        copy.hasRedefine = this.hasRedefine;
        copy.setParentResource(this.parentResource);
        FieldGroup[] fieldGroupArray = this.children;
        int n = 0;
        int n2 = fieldGroupArray.length;
        while (n < n2) {
            FieldGroup child = fieldGroupArray[n];
            child.setParent(copy);
            ++n;
        }
        this.setStartLayoutIndex(this.startLayoutIndex);
        return copy;
    }

    public void handleFieldChangeEvent(FMIModelFieldChangeEvent event) throws FMIModelException {
        this.fireModelFieldChangeEvent(event);
    }

    public void handleDisplayLineChangeEvent(FMIModelDisplayLineChangeEvent event) throws FMIModelException {
        throw new FMIModelException("Internal Error: Unknown");
    }

    public void handleMultiDisplayLineChangeEvent(FMIModelMultiDisplayLineChangeEvent event) throws FMIModelException {
        throw new FMIModelException("Internal Error: Unknown");
    }

    public int setSlackBytes(FieldGroup nextGroup) {
        if (nextGroup != null && nextGroup.isAligned()) {
            int endPosition = this.recordOffset + this.ebcdicWidth;
            if (nextGroup.requiresFullWordBoundary() && endPosition % 4 != 0) {
                this.endSlackBytes = 4 - endPosition % 4;
            } else if (nextGroup.requiresHalfWordBoundary() && endPosition % 2 != 0) {
                this.endSlackBytes = 1;
            }
        }
        this.numSlackBytes += this.endSlackBytes;
        return this.numSlackBytes;
    }
}

