/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.event;

import com.ibm.fmi.model.event.FMIModelDisplayLineChangeEvent;
import com.ibm.fmi.model.event.FMIModelFieldChangeEvent;
import com.ibm.fmi.model.event.FMIModelMultiDisplayLineChangeEvent;
import com.ibm.fmi.model.event.IFMIModelListener;
import com.ibm.fmi.model.exception.FMIModelException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class FMIResource {
    private ArrayList<IFMIModelListener> listeners = null;

    public void addModelListener(IFMIModelListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeModelListener(IFMIModelListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public abstract void addModelListenerAllLevels(IFMIModelListener var1);

    public abstract void removeModelListenerAllLevels(IFMIModelListener var1);

    public void fireModelFieldChangeEvent(FMIModelFieldChangeEvent event) throws FMIModelException {
        if (this.listeners != null) {
            for (IFMIModelListener listener : this.listeners) {
                listener.handleFieldChangeEvent(event);
            }
        }
    }

    public void fireModelDisplayLineChangeEvent(FMIModelDisplayLineChangeEvent event) throws FMIModelException {
        if (this.listeners != null) {
            int i = 0;
            while (i < this.listeners.size()) {
                this.listeners.get(i).handleDisplayLineChangeEvent(event);
                ++i;
            }
        }
    }

    public void fireModelMultiDisplayLineChangeEvent(FMIModelMultiDisplayLineChangeEvent event) throws FMIModelException {
        if (this.listeners != null) {
            int i = 0;
            while (i < this.listeners.size()) {
                this.listeners.get(i).handleMultiDisplayLineChangeEvent(event);
                ++i;
            }
        }
    }

    public List getModelListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        return Collections.unmodifiableList(this.listeners);
    }
}

