/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.client.propertyPages;

import com.ibm.etools.systems.core.SystemPlugin;
import com.ibm.etools.systems.filters.SystemFilter;
import com.ibm.etools.systems.subsystems.SubSystem;
import com.ibm.fmi.client.validators.ValidatorPdsMemberFQPath;
import com.ibm.ftt.resources.core.PhysicalPropertyManager;
import com.ibm.ftt.resources.core.physical.IPhysicalResource;
import com.ibm.ftt.resources.zos.PBResourceMvsUtils;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import com.ibm.ftt.resources.zos.zosfactory.ZOSPhysicalResourceFinder;
import com.ibm.ftt.resources.zos.zosfactory.ZOSResourceIdentifier;
import com.ibm.ftt.resources.zos.zosfactory.ZosfactoryFactory;
import com.ibm.ftt.resources.zos.zosphysical.ZOSDataSet;
import com.ibm.ftt.resources.zos.zosphysical.ZOSDataSetMember;
import com.ibm.ftt.resources.zos.zosphysical.ZOSPartitionedDataSet;
import com.ibm.ftt.resources.zos.zosphysical.ZOSResource;
import com.ibm.ftt.resources.zos.zosphysical.ZOSSequentialDataSet;
import com.ibm.ftt.rse.mvs.client.subsystems.MVSFileSubSystem;
import com.ibm.ftt.ui.rse.utils.RSEViewLabelAndContentProvider;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.PropertyPage;

public class TemplateAssociationPropertyPage
extends PropertyPage
implements SelectionListener,
ISelectionChangedListener,
ModifyListener,
VerifyListener {
    boolean once = true;
    Composite thisPage;
    Button checkBox;
    Combo filterSelection;
    TreeViewer treeView;
    Tree tree;
    Text FQpath;
    MVSFileSubSystem mvsSS = null;
    SystemFilter[] filters = null;
    ZOSDataSetMember selectedTemplate = null;
    boolean manuallyEntered = false;
    protected PhysicalPropertyManager physicalManager = (PhysicalPropertyManager)PhysicalPropertyManager.getManager();

    protected void initialize() {
        MVSFileResource owner = (MVSFileResource)this.getElement();
        SubSystem ss = owner.getSubSystem();
        this.filters = PBResourceMvsUtils.getFilters((SubSystem)ss);
        if (this.filters.length == 0) {
            TemplateAssociationPropertyPage.createErrorDialog("No filters are available", "");
        }
        this.findInitialTemplate();
    }

    protected void findInitialTemplate() {
        MVSFileResource owner = (MVSFileResource)this.getElement();
        String templateName = this.physicalManager.getPersistentProperty((IPhysicalResource)owner.getZOSResource(), "FM Template");
        if (templateName != null && !templateName.equals("")) {
            ValidatorPdsMemberFQPath validator = new ValidatorPdsMemberFQPath();
            int retCode = validator.validateFQPdsMemberName(templateName);
            if (retCode != 0) {
                String reason = validator.getFQMemberValidationErrorMessage(retCode);
                TemplateAssociationPropertyPage.createErrorDialog("Error in persisted template path", reason);
                return;
            }
            if (!this.setSelectedTemplateFromString(templateName)) {
                TemplateAssociationPropertyPage.createErrorDialog("Error in persisted template path", "Can't find template");
            }
        }
    }

    protected Control createContents(Composite parent) {
        this.initialize();
        this.thisPage = new Composite(parent, 0);
        GridLayout pageLayout = new GridLayout();
        pageLayout.numColumns = 4;
        this.thisPage.setLayout((Layout)pageLayout);
        this.thisPage.setLayoutData((Object)new GridData());
        Label entirePath = new Label(this.thisPage, 0);
        entirePath.setText("Fully qualified path:");
        GridData fqpLabelData = new GridData();
        fqpLabelData.horizontalSpan = 4;
        entirePath.setLayoutData((Object)fqpLabelData);
        this.FQpath = new Text(this.thisPage, 2048);
        if (this.selectedTemplate != null) {
            this.FQpath.setText(this.getMVSFQPathFromResource((ZOSResource)this.selectedTemplate));
        }
        this.FQpath.addModifyListener((ModifyListener)this);
        this.FQpath.addVerifyListener((VerifyListener)this);
        GridData FQpathData = new GridData();
        FQpathData.widthHint = 225;
        FQpathData.horizontalSpan = 3;
        this.FQpath.setLayoutData((Object)FQpathData);
        Label sep = new Label(this.thisPage, 258);
        GridData sepData = new GridData();
        sepData.horizontalSpan = 4;
        sepData.heightHint = 30;
        sepData.widthHint = 400;
        sepData.grabExcessHorizontalSpace = true;
        sep.setLayoutData((Object)sepData);
        Label PDSLabel = new Label(this.thisPage, 0);
        PDSLabel.setText("Browse for Template/Copybook: ");
        GridData labelData = new GridData();
        labelData.horizontalSpan = 4;
        PDSLabel.setLayoutData((Object)labelData);
        this.filterSelection = new Combo(this.thisPage, 8);
        this.filterSelection.addSelectionListener((SelectionListener)this);
        GridData filterSelectionData = new GridData();
        filterSelectionData.horizontalSpan = 1;
        this.filterSelection.setLayoutData((Object)filterSelectionData);
        this.populateFilterCombo();
        Label blankLabel = new Label(this.thisPage, 0);
        GridData blankData = new GridData();
        blankData.horizontalSpan = 1;
        blankLabel.setLayoutData((Object)blankData);
        Label checkLabel = new Label(this.thisPage, 0);
        checkLabel.setText("Known Templates and Copybooks only");
        GridData checkLabelData = new GridData();
        checkLabelData.horizontalSpan = 1;
        checkLabelData.horizontalAlignment = 131072;
        checkLabelData.widthHint = 190;
        checkLabelData.grabExcessHorizontalSpace = true;
        checkLabel.setLayoutData((Object)checkLabelData);
        this.checkBox = new Button(this.thisPage, 32);
        GridData checkData = new GridData();
        checkData.horizontalSpan = 1;
        checkData.widthHint = 20;
        this.checkBox.setLayoutData((Object)checkData);
        this.tree = new Tree(this.thisPage, 2048);
        GridData treeData = new GridData();
        treeData.heightHint = 200;
        treeData.widthHint = 400;
        treeData.grabExcessHorizontalSpace = true;
        treeData.horizontalSpan = 4;
        this.tree.setLayoutData((Object)treeData);
        return this.thisPage;
    }

    public void populateFilterCombo() {
        int i = 0;
        while (i < this.filters.length) {
            this.filterSelection.add(this.filters[i].getName());
            ++i;
        }
    }

    public void widgetDefaultSelected(SelectionEvent se) {
        this.widgetSelected(se);
    }

    public void widgetSelected(SelectionEvent se) {
        if (se.getSource() == this.filterSelection) {
            RSEViewLabelAndContentProvider provider = new RSEViewLabelAndContentProvider(true);
            this.treeView = new TreeViewer(this.tree);
            this.treeView.addSelectionChangedListener((ISelectionChangedListener)this);
            this.treeView.setContentProvider((IContentProvider)provider);
            this.treeView.setLabelProvider((IBaseLabelProvider)provider);
            SystemFilter curFilter = this.filters[this.filterSelection.getSelectionIndex()];
            ViewerFilter myFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parent, Object element) {
                    if (!TemplateAssociationPropertyPage.this.checkBox.getSelection() && element instanceof MVSFileResource) {
                        return !(((MVSFileResource)element).getZOSResource() instanceof ZOSSequentialDataSet);
                    }
                    if (element instanceof MVSFileResource) {
                        MVSFileResource file = (MVSFileResource)element;
                        ZOSResource resource = file.getZOSResource();
                        if (resource instanceof ZOSPartitionedDataSet) {
                            ((ZOSPartitionedDataSet)resource).refresh(1, null);
                            List members = ((ZOSPartitionedDataSet)resource).getMembers();
                            int i = 0;
                            while (i < members.size()) {
                                Object cur = members.get(i);
                                if (cur instanceof ZOSDataSetMember && (((ZOSDataSetMember)cur).getFileExtension().equals("tmpl") || ((ZOSDataSetMember)cur).getFileExtension().equals("cpy") || ((ZOSDataSetMember)cur).getFileExtension().equals("inc"))) {
                                    return true;
                                }
                                ++i;
                            }
                        } else if (resource instanceof ZOSDataSetMember && (((ZOSDataSetMember)resource).getFileExtension().equals("tmpl") || ((ZOSDataSetMember)resource).getFileExtension().equals("cpy") || ((ZOSDataSetMember)resource).getFileExtension().equals("inc"))) {
                            return true;
                        }
                    }
                    return false;
                }
            };
            this.treeView.addFilter(myFilter);
            this.treeView.setInput((Object)curFilter);
        }
    }

    public String getMVSFQPathFromResource(ZOSResource zResource) {
        String path = zResource.getFullPath().removeFileExtension().toString();
        path = path.replace('/', '(');
        path = String.valueOf(path) + ')';
        return path;
    }

    public void clearPage() {
        this.FQpath.setText("");
        this.selectedTemplate = null;
    }

    protected void performApply() {
        this.validateTemplate();
    }

    public boolean performOk() {
        return this.validateTemplate();
    }

    public boolean okToLeave() {
        if (!this.FQpath.getText().equals("") && !this.validateTemplate()) {
            MessageBox messageBox = new MessageBox(SystemPlugin.getActiveWorkbenchShell(), 192);
            messageBox.setMessage("The Template path provided is invalid.  Would you like to leave thepage without specifying a path?)");
            if (messageBox.open() == 128) {
                return false;
            }
        }
        return true;
    }

    public boolean validateTemplate() {
        String pathString = null;
        if (this.FQpath != null && (pathString = this.FQpath.getText()).length() == 0) {
            this.selectedTemplate = null;
            this.associateTemplate();
            return true;
        }
        if (pathString.indexOf(32) > -1) {
            TemplateAssociationPropertyPage.createErrorDialog("Cannot Use Provided Template Path", "Path Provided Contains Spaces");
            return false;
        }
        ValidatorPdsMemberFQPath validator = new ValidatorPdsMemberFQPath();
        int retCode = validator.validateFQPdsMemberName(pathString);
        if (retCode != 0) {
            String reason = validator.getFQMemberValidationErrorMessage(retCode);
            TemplateAssociationPropertyPage.createErrorDialog("Cannot Use Provided Template Path", reason);
            return false;
        }
        if (this.manuallyEntered && !this.setSelectedTemplateFromString(this.FQpath.getText())) {
            TemplateAssociationPropertyPage.createErrorDialog("Cannot Use Provided Template Path", "Dataset Member Does Not Exist");
        }
        this.associateTemplate();
        return true;
    }

    public void changeExtension() {
        this.selectedTemplate.setFileExtension("tmpl");
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean validateExtensionChange() {
        if (this.selectedTemplate == null) {
            this.clearPage();
        }
        if (this.selectedTemplate.getFileExtension().equals("tmpl")) {
            this.associateTemplate();
            return true;
        }
        MessageBox messageBox = new MessageBox(SystemPlugin.getActiveWorkbenchShell(), 192);
        messageBox.setMessage("This dataset is not currently mapped as a template. Do you still want to use it (will be mapped as template)?");
        if (messageBox.open() == 64) {
            this.associateTemplate();
            return true;
        }
        this.clearPage();
        return false;
    }

    public void associateTemplate() {
        MVSFileResource resource = (MVSFileResource)this.getElement();
        if (this.selectedTemplate == null) {
            this.physicalManager.setPersistentProperty((IPhysicalResource)resource.getZOSResource(), "FM Template", "");
        } else {
            String path = this.getMVSFQPathFromResource((ZOSResource)this.selectedTemplate);
            this.physicalManager.setPersistentProperty((IPhysicalResource)resource.getZOSResource(), "FM Template", path);
        }
    }

    public void selectionChanged(SelectionChangedEvent se) {
        ZOSResource resource;
        Object selected;
        if (se.getSource() == this.treeView && (selected = ((IStructuredSelection)this.treeView.getSelection()).getFirstElement()) instanceof MVSFileResource && (resource = ((MVSFileResource)selected).getZOSResource()) instanceof ZOSDataSetMember) {
            this.selectedTemplate = (ZOSDataSetMember)resource;
            String path = resource.getFullPath().removeFileExtension().toString();
            path = path.replace('/', '(');
            path = String.valueOf(path) + ')';
            this.FQpath.setText(path);
            this.manuallyEntered = false;
        }
    }

    public boolean setSelectedTemplateFromString(String FQpath) {
        boolean found = false;
        String sysName = ((MVSFileResource)this.getElement()).getSubSystem().getSystemConnectionName();
        String PDSname = FQpath.substring(0, FQpath.indexOf(40));
        String memberName = FQpath.substring(FQpath.indexOf(40) + 1, FQpath.length() - 1);
        ZOSResourceIdentifier identifier = ZosfactoryFactory.eINSTANCE.createZOSResourceIdentifier();
        identifier.setDataSetName(PDSname);
        identifier.setSystem(sysName);
        ZOSDataSet resource = (ZOSDataSet)ZOSPhysicalResourceFinder.eINSTANCE.findPhysicalResource(identifier);
        if (resource != null && resource instanceof ZOSPartitionedDataSet) {
            ZOSPartitionedDataSet pds = (ZOSPartitionedDataSet)resource;
            pds.refresh(1, null);
            List members = pds.getMembers();
            int i = 0;
            while (i < members.size()) {
                Object memberObject = members.get(i);
                if (memberObject instanceof ZOSDataSetMember && (((ZOSDataSetMember)memberObject).getName().equals(memberName) || ((ZOSDataSetMember)memberObject).getNameWithoutExtension().equals(memberName))) {
                    this.selectedTemplate = (ZOSDataSetMember)memberObject;
                    found = true;
                    break;
                }
                ++i;
            }
        }
        return found;
    }

    public void modifyText(ModifyEvent event) {
        if (event.getSource() == this.FQpath) {
            this.manuallyEntered = true;
        }
    }

    public static void createErrorDialog(String message, String reason) {
        ErrorDialog.openError((Shell)SystemPlugin.getActiveWorkbenchShell(), (String)"Template Association Error", (String)message, (IStatus)new Status(4, "FMDialog", 0, reason, null));
    }

    public void verifyText(VerifyEvent ve) {
        String upper;
        ve.text = upper = ve.text.trim().toUpperCase();
    }
}

