/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.client.resources.zos.filesystem.impl;

import com.ibm.etools.systems.dstore.core.model.DataElement;
import com.ibm.etools.systems.dstore.core.model.DataStore;
import com.ibm.etools.systems.subsystems.RemoteFileException;
import com.ibm.fmi.client.FMIClientUtilities;
import com.ibm.fmi.client.propertyPages.FMIPreferencePage;
import com.ibm.ftt.resources.zos.filesystem.MVSObject;
import com.ibm.ftt.resources.zos.filesystem.MVSResource;
import com.ibm.ftt.resources.zos.util.RSEClient;
import com.ibm.ftt.rse.mvs.util.FFSResponse;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

public class FMIDataSetImpl {
    private MVSResource dataset;

    public FMIDataSetImpl(MVSResource dataset) {
        this.dataset = dataset;
    }

    public IFile getFile(IProgressMonitor monitor, Object editObject, String templateName) throws InterruptedException, RemoteFileException {
        DataElement dataElement = this.dataset.getDataElement();
        DataStore dataStore = dataElement.getDataStore();
        IFile file = this.dataset.getLocalResource();
        String parentPath = file.getParent().getLocation().makeAbsolute().toOSString();
        dataStore.getAttribute(7);
        dataStore.setAttribute(7, parentPath);
        Integer.toString(this.dataset.getMVSFileSystem().getDownloadBufferSize());
        DataElement[] args = new DataElement[7];
        String workstationPath = FMIClientUtilities.getLocalPath(this.dataset);
        args[0] = RSEClient.argument((MVSObject)this.dataset, (String)FMIClientUtilities.getRemoteDataset(this.dataset));
        args[1] = RSEClient.argument((MVSObject)this.dataset, (String)FMIClientUtilities.getRemoteMember(this.dataset));
        args[2] = RSEClient.argument((MVSObject)this.dataset, (String)workstationPath);
        args[3] = RSEClient.argument((MVSObject)this.dataset, (String)templateName);
        args[4] = RSEClient.argument((MVSObject)this.dataset, (String)FMIClientUtilities.getLocalTemplateName(workstationPath));
        args[5] = RSEClient.argument((MVSObject)this.dataset, (String)this.dataset.getTransfer(), (String)this.dataset.getHostCp(), (String)this.dataset.getLocalCp());
        args[6] = RSEClient.argument((MVSObject)this.dataset, (String)String.valueOf(FMIPreferencePage.getMaxDownloadBytes()));
        monitor.worked(25);
        monitor.setTaskName("Opening Edit Session...");
        FFSResponse ffsResponse = RSEClient.command((MVSObject)this.dataset, (String)"C_FMI_OPEN_EDIT_SESSION", (DataElement[])args, (int)600, (IProgressMonitor)monitor);
        if (!ffsResponse.isSuccess()) {
            String errorMessage = ffsResponse.getMessage();
            monitor.setCanceled(true);
            throw new RemoteFileException(errorMessage);
        }
        DataElement[] dArgs = new DataElement[6];
        int i = 0;
        while (i < 6) {
            dArgs[i] = args[i];
            ++i;
        }
        monitor.worked(75);
        monitor.setTaskName("Downloading Data Set...");
        ffsResponse = RSEClient.command((MVSObject)this.dataset, (String)"C_FMI_DOWNLOAD", (DataElement[])dArgs, (int)6000, (IProgressMonitor)monitor);
        if (!ffsResponse.isSuccess()) {
            String errorMessage = ffsResponse.getMessage();
            monitor.setCanceled(true);
            FMIClientUtilities.cleanUpDatasets(workstationPath);
            throw new RemoteFileException(errorMessage);
        }
        monitor.worked(100);
        monitor.done();
        return file;
    }
}

