/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.dialog;

import com.ibm.fmi.model.DefiningObject;
import com.ibm.fmi.ui.UiPlugin;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordDialog
extends MessageDialog {
    protected CLabel prompt = null;
    protected String promptText = UiPlugin.getString("RecordDialog.definingObjectPrompt");
    protected ArrayList<Combo> comboFields = new ArrayList();
    protected int[] values;
    protected Vector<DefiningObject> input;

    public RecordDialog(Vector<DefiningObject> input, Shell parentShell) {
        super(parentShell, UiPlugin.getString("RecordDialog.title"), null, "", 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.input = input;
    }

    protected Control createCustomArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        Composite composite = new Composite((Composite)sc, 0);
        sc.setLayoutData((Object)new GridData(1808));
        sc.setContent((Control)composite);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        for (DefiningObject definingObject : this.input) {
            Label label = new Label(composite, 64);
            label.setText(definingObject.getName());
            label.setToolTipText("#" + definingObject.getSymbol() + "\n " + definingObject.getConverterSymbol() + " " + (definingObject.getRecordOffset() + 1) + ":" + definingObject.getActualEbcdicWidth());
            gd = new GridData(4, 1, true, false);
            gd.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)gd);
            Combo combo = new Combo(composite, 12);
            int i = definingObject.getLowerBound();
            while (i <= definingObject.getUpperBound()) {
                combo.add("" + i);
                ++i;
            }
            combo.setText(combo.getItem(0));
            gd = new GridData(1, 0x1000000, false, true);
            gd.widthHint = this.convertWidthInCharsToPixels(200);
            this.comboFields.add(combo);
        }
        composite.setSize(composite.computeSize(-1, -1));
        return sc;
    }

    protected Control createMessageArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.prompt = new CLabel(composite, 0);
        this.setMessage(null);
        return composite;
    }

    public void setMessage(String string) {
        if (string == null || string.equals("")) {
            this.prompt.setText(this.promptText);
            this.prompt.setImage(this.getQuestionImage());
        } else {
            this.prompt.setText(string);
            this.prompt.setImage(this.getErrorImage());
        }
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        if (buttonId == 0) {
            this.okPressed();
        } else if (buttonId == 1) {
            this.cancelPressed();
        }
        this.close();
    }

    public void okPressed() {
        this.values = new int[this.comboFields.size()];
        int i = 0;
        while (i < this.comboFields.size()) {
            this.values[i] = Integer.parseInt(this.comboFields.get(i).getText());
            ++i;
        }
    }

    public int[] getValues() {
        return this.values;
    }
}

