/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.providers;

import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.shadowline.ShadowLine;
import com.ibm.fmi.ui.UiPlugin;
import com.ibm.fmi.ui.providers.HexRecordWrapper;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Item;

public class FMICharModeCellModifier
implements ICellModifier {
    public boolean canModify(Object element, String property) {
        return property != null && property.equals(UiPlugin.getString("DATA_TITLE")) && !(element instanceof ShadowLine);
    }

    public Object getValue(Object element, String property) {
        Record rec = null;
        if (element instanceof HexRecordWrapper) {
            return ((HexRecordWrapper)element).getHexString();
        }
        if (element instanceof Record) {
            rec = (Record)element;
        }
        try {
            return rec.getASCIIString();
        }
        catch (FMIConversionException e) {
            UiPlugin.trace(0, this, UiPlugin.getString("Error.display.AN"), e);
        }
        catch (FMIModelException e) {
            UiPlugin.trace(0, this, UiPlugin.getString("Error.display.AN"), e);
        }
        return "";
    }

    public void modify(Object element, String property, Object value) {
        if (!property.equals(UiPlugin.getString("DATA_TITLE"))) {
            return;
        }
        if (element instanceof Item) {
            element = ((Item)element).getData();
        }
        if (element instanceof Record) {
            Record record = (Record)element;
            try {
                record.setAsciiString((String)value, true);
            }
            catch (FMIConversionException e) {
                UiPlugin.trace(0, this, "property " + property + " on element " + element + " is invalid.", e);
            }
            catch (FMIParseException e) {
                UiPlugin.trace(0, this, "property " + property + " on element " + element + " is invalid.", e);
            }
            catch (FMIKeyException e) {
                UiPlugin.trace(0, this, "property " + property + " on element " + element + " is invalid.", e);
            }
            catch (FMIModelException e) {
                UiPlugin.trace(0, this, "property " + property + " on element " + element + " is invalid.", e);
            }
        } else if (element instanceof HexRecordWrapper) {
            try {
                ((HexRecordWrapper)element).setHexString((String)value);
            }
            catch (FMIConversionException e) {
                UiPlugin.trace(0, this, "property " + property + " on element " + element + " is invalid.", e);
            }
        }
    }
}

