/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.providers;

import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.Field;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.TemplattedData;
import com.ibm.fmi.model.shadowline.ExcludedSet;
import com.ibm.fmi.model.shadowline.SuppressedSet;
import com.ibm.fmi.model.shadowline.UnselectedSet;
import com.ibm.fmi.ui.UiPlugin;
import com.ibm.fmi.ui.providers.HexRecordWrapper;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class FMITableModeLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private TemplattedData tData;

    public FMITableModeLabelProvider(TemplattedData tData) {
        this.tData = tData;
    }

    public Image getColumnImage(Object object, int columnIndex) {
        if (columnIndex == 0) {
            if (object instanceof DisplayLine && ((DisplayLine)object).containsDuplicateKey()) {
                return JFaceResources.getImage((String)"dialog_message_error_image");
            }
            if (object instanceof ExcludedSet) {
                return UiPlugin.getDefault().getImageRegistry().get("icons/excluded_icon.gif");
            }
            if (object instanceof SuppressedSet) {
                return UiPlugin.getDefault().getImageRegistry().get("icons/SuppressRecord_1.jpg");
            }
            if (object instanceof UnselectedSet) {
                return UiPlugin.getDefault().getImageRegistry().get("icons/unselected_icon.gif");
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return null;
        }
        if (element instanceof DisplayLine) {
            DisplayLine theLine = (DisplayLine)element;
            if (theLine instanceof Record) {
                Field field = ((Record)theLine).getDisplayField(columnIndex - 1);
                if (field.isEmpty()) {
                    return "";
                }
                return field.getAsciiStr();
            }
            return "";
        }
        if (element instanceof HexRecordWrapper) {
            HexRecordWrapper wrapper = (HexRecordWrapper)element;
            return wrapper.getHexString(columnIndex - 1);
        }
        return UiPlugin.getString("Editor.error.unrecognized");
    }

    public Color getForeground(Object element, int columnIndex) {
        Record record;
        Field field;
        Color blue = Display.getDefault().getSystemColor(9);
        if (columnIndex == 0) {
            return null;
        }
        if (element != null && element instanceof Record && this.tData.getKey() != null && (field = (record = (Record)element).getDisplayField(columnIndex - 1)).isKeyField()) {
            return blue;
        }
        if (element != null && element instanceof Record && columnIndex > 0 && !((Record)element).getDisplayField(columnIndex - 1).isValid()) {
            return Display.getDefault().getSystemColor(3);
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return null;
        }
        Record record = null;
        if (element instanceof Record) {
            record = (Record)element;
        } else if (element instanceof HexRecordWrapper) {
            record = ((HexRecordWrapper)element).getRecord();
        }
        if (record == null) {
            return Display.getDefault().getSystemColor(15);
        }
        if (columnIndex > 0 && !record.getDisplayField(columnIndex - 1).isEditable()) {
            return Display.getDefault().getSystemColor(15);
        }
        return null;
    }
}

