/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.providers;

import com.ibm.fmi.model.Field;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.ui.UiPlugin;

public class HexRecordWrapper {
    private Record record = null;
    private boolean firstDigit;
    private final String CANTSETVALUE = "CANTSETVALUE";

    public HexRecordWrapper(Record displayLine, boolean firstDigit) {
        this.record = displayLine;
        this.firstDigit = firstDigit;
    }

    public boolean isFirstDigit() {
        return this.firstDigit;
    }

    public void setFirstDigit(boolean firstDigit) {
        this.firstDigit = firstDigit;
    }

    public Record getRecord() {
        return this.record;
    }

    public void setRecord(Record displayLine) {
        this.record = displayLine;
    }

    public String getHexString() {
        byte[] bytes = this.record.getEbcdic();
        StringBuffer buff = new StringBuffer(bytes.length);
        int i = 0;
        while (i < bytes.length) {
            int number = 0;
            number = this.isFirstDigit() ? (bytes[i] & 0xF0) >> 4 : bytes[i] & 0xF;
            buff.append(Integer.toHexString(number));
            ++i;
        }
        return buff.toString().toUpperCase();
    }

    public void setHexString(String value) throws FMIConversionException {
        byte[] bytes = this.record.getEbcdic();
        int i = 0;
        while (i < bytes.length) {
            int num = bytes[i] & 0xFF;
            byte byteNum = i < value.length() ? Byte.parseByte(value.substring(i, i + 1), 16) : (byte)0;
            num = this.firstDigit ? (num & 0xF) + (byteNum << 4) : (num & 0xF0) + byteNum;
            bytes[i] = (byte)num;
            ++i;
        }
        try {
            this.record.setEbcdic(bytes, false, true, true);
        }
        catch (FMIParseException e) {
            UiPlugin.trace(0, this, UiPlugin.getString("Error.set.EBCDIC"), e);
        }
        catch (FMIKeyException e) {
            UiPlugin.trace(0, this, UiPlugin.getString("Error.set.EBCDIC"), e);
        }
        catch (FMIModelException e) {
            UiPlugin.trace(0, this, UiPlugin.getString("Error.set.EBCDIC"), e);
        }
    }

    public String getHexString(int fieldIndex) {
        if (!(this.record instanceof Record)) {
            return null;
        }
        Field field = this.record.getDisplayField(fieldIndex);
        if (field.isEmpty()) {
            return "";
        }
        byte[] bytes = field.getEbcdicValue();
        StringBuffer buff = new StringBuffer(bytes.length);
        int i = 0;
        while (i < bytes.length) {
            int number = 0;
            number = this.isFirstDigit() ? (bytes[i] & 0xF0) >> 4 : bytes[i] & 0xF;
            buff.append(Integer.toHexString(number));
            ++i;
        }
        return buff.toString().toUpperCase();
    }

    public void setHexString(String value, int fieldIndex) throws FMIConversionException, FMIKeyException, FMIModelException {
        if (!(this.record instanceof Record)) {
            throw new FMIConversionException("CANTSETVALUE");
        }
        Field field = this.record.getDisplayField(fieldIndex);
        byte[] bytes = field.getEbcdicValue();
        int i = 0;
        while (i < bytes.length) {
            int num = bytes[i] & 0xFF;
            byte byteNum = i < value.length() ? Byte.parseByte(value.substring(i, i + 1), 16) : (byte)0;
            num = this.firstDigit ? (num & 0xF) + (byteNum << 4) : (num & 0xF0) + byteNum;
            bytes[i] = (byte)num;
            ++i;
        }
        field.setEbcdic(bytes, 0, false, true, true);
    }

    public int getFieldCount() {
        return this.record.getLayout().numDisplayFields();
    }
}

